package sound;

import java.applet.Applet;
import java.applet.AudioClip;

/**
 * BGMに関連した定数を集めたクラスです。
 * @author Kumano Tatsuo
 * Created on 2005/01/09 16:43:46
 */
class Const {
    /**
     * Constの一覧
     */
    static final String[] BGM_FILES = new String[] { "GM_AKIRA.MID", "GM_ASU.MID", "GM_BANKA.MID",
            "GM_BLUE.MID", "GM_COFF.MID", "GM_DENS2.MID", "GM_DUCK.MID", "GM_EIKO.MID",
            "GM_FOREV.MID", "GM_FUSE.MID", "GM_GENKI.MID", "GM_HOP.MID", "GM_HOP_D.MID",
            "GM_KITT.MID", "GM_KOGA.MID", "GM_KOMO.MID", "GM_KOUY.MID", "GM_KUMO.MID",
            "GM_KURA.MID", "GM_KYOU.MID", "GM_LAKE.MID", "GM_MAYO.MID", "GM_MIZU.MID",
            "GM_MODO.MID", "GM_MUJA.MID", "GM_NAHA.MID", "GM_NEVER.MID", "GM_NIJI.MID",
            "GM_OKA.MID", "GM_OSOU.MID", "GM_PKAN.MID", "GM_POKO.MID", "GM_SMIL.MID",
            "GM_TOKEI.MID", "GM_TORI.MID", "GM_TRE.MID", "GM_TUMO.MID", "GM_UNKO.MID",
            "GM_UWA2.MID", "GM_YOUK.MID", "GM_YUKA.MID", "GM_YUMEH.MID", "GM_YUYA.MID",
            "GM__YUME.MID" };

    /**
     * 泡が固定したときの音
     */
    static final AudioClip SE_PUT = Applet.newAudioClip(Const.class.getResource("BubbleA_16.wav"));

    /**
     * 泡を消したときの音
     */
    static final AudioClip SE_REMOVE = Applet.newAudioClip(Const.class
            .getResource("BubbleB_16.wav"));

    /**
     * 連鎖反応の音
     */
    static final AudioClip[] SE_CHAIN = {
            Applet.newAudioClip(Const.class.getResource("BubbleC_11.wav")),
            Applet.newAudioClip(Const.class.getResource("BubbleD_16.wav")),
            Applet.newAudioClip(Const.class.getResource("BubbleE_16.wav")) };

    /**
     * おじゃまの音
     */
    static final AudioClip[] SE_JAM = {
            Applet.newAudioClip(Const.class.getResource("pochi00_11.wav")),
            Applet.newAudioClip(Const.class.getResource("pochi01_11.wav")),
            Applet.newAudioClip(Const.class.getResource("pochi02_11.wav")),
            Applet.newAudioClip(Const.class.getResource("pochi03_11.wav")),
            Applet.newAudioClip(Const.class.getResource("pochi04_11.wav")) };
}
