package sound;

import java.applet.Applet;
import java.applet.AudioClip;
import java.util.Random;

/**
 * BGMを管理するクラスです。
 * @author Kumano Tatsuo
 * Created on 2005/01/09 16:36:29
 */
public class BGM {
    /**
     * オーディオクリップ
     */
    AudioClip ac = null;

    /**
     * ランダムに撰んだBGMを演奏します。
     */
    public void play() {
        this.stop();
        this.ac = Applet.newAudioClip(Const.class.getResource(Const.BGM_FILES[new Random()
                .nextInt(Const.BGM_FILES.length)]));
        this.ac.loop();
    }

    /**
     * 演奏中のBGMを終了します。
     */
    public void stop() {
        if (this.ac != null) {
            this.ac.stop();
        }
    }
}
