package bubble;
import java.awt.geom.Point2D;

/**
 * ゲームの情報を取得するためのクラスです。
 * @author Kumano Tatsuo
 * Created on 2005/01/01 14:21:05
 */
public class ReadOnlyGame {
    
    /**
     * ゲーム
     */
    private final Game game;

    /**
     * コンストラクタです。
     * @param game ゲーム
     */
    public ReadOnlyGame(Game game) {
        this.game = game;
    }
    
    /**
     * 泡を左に動かします。
     */
    public void moveLeft() {
        this.game.setRight(false);
        this.game.setLeft(true);
    }

    /**
     * 泡を右に動かします。
     */
    public void moveRight() {
        this.game.setLeft(false);
        this.game.setRight(true);
    }

    /**
     * 泡を上に動かします。
     */
    public void moveUp() {
        this.game.setUp(true);
    }

    /**
     * 泡の移動を止めます。
     */
    public void stop() {
        this.game.setLeft(false);
        this.game.setRight(false);
        this.game.setUp(false);
    }

    /**
     * 動いている泡の色を取得します。
     * @return 色
     */
    public int getColor() {
        return this.game.getColor();
    }

    /**
     * 動いている泡の座標を取得します。
     * @return 座標
     */
    public Point2D getLocation() {
        return this.game.getLocation();
    }

    /**
     * 固定した泡の色を取得します。
     * @param row 行
     * @param col 列
     * @return 泡の色
     */
    public int getData(int row, int col) {
        return this.game.getData(row, col);
    }
    
    /**
     * 相手から受け取ったおじゃまぷよの数を取得します。
     * @return おじゃまの数
     */
    public int getGotJam(){
        return this.game.getGotJam();
    }
}
