package bubble;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.RenderingHints;
import java.util.ConcurrentModificationException;

/**
 * メインパネルです。
 * @author Kumano Tatsuo
 * 作成日：2004/10/13
 */
public class MainPanel extends Panel {
    /**
     * プレイヤ1のゲームの状態
     */
    private Game game1;

    /**
     * プレイヤ2のゲームの状態
     */
    private Game game2;

    /**
     * ダブルバッファリングのためのイメージ
     */
    private Image image;

    /**
     * パネルが初期化されるときに呼び出されます。
     * @param game1 プレイヤ1のゲームの状態
     * @param game2 プレイヤ2のゲームの状態
     */
    public MainPanel(Game game1, Game game2) {
        this.game1 = game1;
        this.game2 = game2;
    }

    /**
     *  パネルが再描画されるたびに呼び出されます。
     * @param graphics グラフィクスコンテキスト
     */
    public void paint(Graphics graphics) {
        if (this.image == null) {
            this.image = createImage(Const.SCREEN_WIDTH, Const.SCREEN_HEIGHT);
            Graphics g = this.image.getGraphics();
            for (int i = 0; i < Const.IMAGE_BUBBLES.length; ++i) {
                g.drawImage(Const.IMAGE_BUBBLES[i], 0, 0, this);
            }
            g.drawImage(Const.IMAGE_JAM_YELLOW, 0, 0, this);
            g.drawImage(Const.IMAGE_JAM_RED, 0, 0, this);
            g.drawImage(Const.IMAGE_WIN, 0, 0, this);
            g.drawImage(Const.IMAGE_BACKGROUND, 0, 0, this);
            g.drawImage(Const.IMAGE_BLINDER, 0, 0, this);
        }
        Graphics2D g = (Graphics2D) this.image.getGraphics();
        Color backGroundColor;
        g.drawImage(Const.IMAGE_BACKGROUND, 0, 0, this);
        if (this.game1.getRule() == Const.RULE_FROZEN_1P) {
            g.setColor(Color.BLUE.darker());
            g.drawRect(0, 0, Const.SCREEN_WIDTH - 1, Const.SCREEN_HEIGHT - 1);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        // プレイヤ2のグリッドを描画する
        if (Const.SHOW_GRID) {
            for (int row = 0; row < Const.STAGE_ROWS; ++row) {
                for (int col = 0; col < Const.STAGE_COLS - row % 2; ++col) {
                    Point p = Util.toLocation(row, col);
                    g.setColor(Color.GRAY);
                    g.drawRect(p.x + Const.PLAYER2_OFFSET_X, p.y + Const.PLAYER2_OFFSET_Y,
                            Const.GRID_WIDTH, Const.GRID_HEIGHT);
                }
            }
        }
        // プレイヤ2の枠を描画する
        //        g.setColor(Color.GRAY);
        //        g.drawRect(Const.PLAYER2_OFFSET_X, Const.PLAYER2_OFFSET_Y, Const.GRID_WIDTH
        //                * Const.STAGE_COLS, Const.GRID_HEIGHT * (Const.STAGE_ROWS - 1));
        // プレイヤ2の泡を描画する
        for (int row = 0; row < Const.STAGE_ROWS; ++row) {
            for (int col = 0; col < Const.STAGE_COLS - row % 2; ++col) {
                int color = this.game2.getData(row, col);
                if (color != Const.NO_BUBBLE) {
                    Point p = Util.toLocation(row, col);
                    g.drawImage(Const.IMAGE_BUBBLES[color], p.x + Const.PLAYER2_OFFSET_X,
                            p.y + Const.PLAYER2_OFFSET_Y - Const.GRID_WIDTH / 2 + Const.GRID_HEIGHT
                                    / 2, this);
                }
            }
        }
        // プレイヤ2の次の泡を描画する
        if (this.game2.getStatus() == Const.STATUS_PLAYING) {
            g.drawImage(Const.IMAGE_BUBBLES[this.game2.getNextNextColor()],
                    Const.PLAYER2_NEXT_NEXT.x - Const.GRID_WIDTH / 2, Const.PLAYER2_NEXT_NEXT.y
                            - Const.GRID_WIDTH / 2, Const.IMAGE_BUBBLES[0].getWidth(this) * 2 / 3,
                    Const.IMAGE_BUBBLES[0].getHeight(this) * 2 / 3, this);
            g.drawImage(Const.IMAGE_BUBBLES[this.game2.getNextColor()], Const.PLAYER2_NEXT.x
                    - Const.GRID_WIDTH / 2, Const.PLAYER2_NEXT.y - Const.GRID_WIDTH / 2, this);
        }
        // プレイヤ2の動いている泡を描画する
        if (this.game2.getStatus() == Const.STATUS_PLAYING
                && this.game2.getPlayingStatus() == Const.PLAYING_STATUS_MOVING) {
            Point p2 = this.game2.getLocation();
            if (p2 != null) {
                g.drawImage(Const.IMAGE_BUBBLES[this.game2.getColor()], p2.x
                        + Const.PLAYER2_OFFSET_X, p2.y + Const.PLAYER2_OFFSET_Y - Const.GRID_WIDTH
                        / 2 + Const.GRID_HEIGHT / 2, this);
            }
        }
        // プレイヤ2の目かくしを描画する
        g.drawImage(Const.IMAGE_BLINDER, Const.PLAYER2_BLINDER_LOCATION.x,
                Const.PLAYER2_BLINDER_LOCATION.y, this);
        // プレイヤ2の予告おじゃまぷよを描画する
        if (this.game2.getGotJam() > 0) {
            if (this.game2.getGotJam() >= 10) {
                for (int i = 0; i < this.game2.getGotJam(); i += 10) {
                    int x = i * Const.JAM_SIZE.width / 10 + Const.PLAYER2_PRE_JAM_LOCATION.x;
                    int y = Const.PLAYER2_PRE_JAM_LOCATION.y;
                    g.drawImage(Const.IMAGE_JAM_RED, x, y, this);
                }
            } else {
                for (int i = 0; i < this.game2.getGotJam(); ++i) {
                    int x = i * Const.JAM_SIZE.width + Const.PLAYER2_PRE_JAM_LOCATION.x;
                    int y = Const.PLAYER2_PRE_JAM_LOCATION.y;
                    g.drawImage(Const.IMAGE_JAM_YELLOW, x, y, this);
                }
            }
        }
        // プレイヤ2の勝ち数を表示する
        for (int i = 0; i < this.game2.getWinCount(); ++i) {
            int x = i * Const.WIN_COUNT_SIZE.width + Const.PLAYER2_WIN_COUNT_LOCATION.x;
            int y = Const.PLAYER2_WIN_COUNT_LOCATION.y;
            g.drawImage(Const.IMAGE_WIN, x, y, this);
        }
        // プレイヤ2の落ちている泡を描画する
        try {
            for (MovingBubble bubble : this.game2.getFallingBubbles()) {
                g.drawImage(Const.IMAGE_BUBBLES[bubble.getColor()], bubble.getLocation().x
                        + Const.PLAYER2_OFFSET_X, bubble.getLocation().y + Const.PLAYER2_OFFSET_Y
                        - Const.GRID_WIDTH / 2 + Const.GRID_HEIGHT / 2, this);
            }
        } catch (ConcurrentModificationException e) {
            // 無視
        }
        // プレイヤ2の連鎖版の中の泡を描画する
        try {
            for (MovingBubble bubble : this.game2.getChainBubbles()) {
                g.drawImage(Const.IMAGE_BUBBLES[bubble.getColor()], bubble.getLocation().x
                        + Const.PLAYER2_OFFSET_X, bubble.getLocation().y + Const.PLAYER2_OFFSET_Y
                        - Const.GRID_WIDTH / 2 + Const.GRID_HEIGHT / 2, this);
            }
        } catch (ConcurrentModificationException e) {
            // 無視
        }
        // プレイヤ2の移動中のおじゃまぷよを描画する
        try {
            for (MovingBubble bubble : this.game2.getJumBubbles()) {
                g.drawImage(Const.IMAGE_BUBBLES[bubble.getColor()], bubble.getLocation().x
                        + Const.PLAYER2_OFFSET_X, bubble.getLocation().y + Const.PLAYER2_OFFSET_Y
                        - Const.GRID_WIDTH / 2 + Const.GRID_HEIGHT / 2, this);
            }
        } catch (ConcurrentModificationException e) {
            // 無視
        }
        // プレイヤ1のグリッドを描画する
        if (Const.SHOW_GRID) {
            for (int row = 0; row < Const.STAGE_ROWS; ++row) {
                for (int col = 0; col < Const.STAGE_COLS - row % 2; ++col) {
                    Point p = Util.toLocation(row, col);
                    g.setColor(Color.GRAY);
                    g.drawRect(p.x + Const.PLAYER1_OFFSET_X, p.y + Const.PLAYER1_OFFSET_Y,
                            Const.GRID_WIDTH, Const.GRID_HEIGHT);
                }
            }
        }
        // プレイヤ1の枠を描画する
        //        g.setColor(Color.GRAY);
        //        g.drawRect(Const.PLAYER1_OFFSET_X, Const.PLAYER1_OFFSET_Y, Const.GRID_WIDTH
        //                * Const.STAGE_COLS, Const.GRID_HEIGHT * (Const.STAGE_ROWS - 1));
        // プレイヤ1の泡を描画する
        for (int row = 0; row < Const.STAGE_ROWS; ++row) {
            for (int col = 0; col < Const.STAGE_COLS - row % 2; ++col) {
                int color = this.game1.getData(row, col);
                if (color != Const.NO_BUBBLE) {
                    Point p = Util.toLocation(row, col);
                    g.drawImage(Const.IMAGE_BUBBLES[color], p.x + Const.PLAYER1_OFFSET_X,
                            p.y + Const.PLAYER1_OFFSET_Y - Const.GRID_WIDTH / 2 + Const.GRID_HEIGHT
                                    / 2, this);
                }
            }
        }
        // プレイヤ1の次の泡を描画する
        if (this.game1.getStatus() == Const.STATUS_PLAYING) {
            g.drawImage(Const.IMAGE_BUBBLES[this.game1.getNextNextColor()],
                    Const.PLAYER1_NEXT_NEXT.x - Const.GRID_WIDTH / 2
                            + Const.IMAGE_BUBBLES[0].getWidth(this) / 3, Const.PLAYER1_NEXT_NEXT.y
                            - Const.GRID_WIDTH / 2, Const.IMAGE_BUBBLES[0].getWidth(this) * 2 / 3,
                    Const.IMAGE_BUBBLES[0].getHeight(this) * 2 / 3, this);
            g.drawImage(Const.IMAGE_BUBBLES[this.game1.getNextColor()], Const.PLAYER1_NEXT.x
                    - Const.GRID_WIDTH / 2, Const.PLAYER1_NEXT.y - Const.GRID_WIDTH / 2, this);
        }
        // プレイヤ1の動いている泡を描画する
        if (this.game1.getStatus() == Const.STATUS_PLAYING
                && this.game1.getPlayingStatus() == Const.PLAYING_STATUS_MOVING) {
            Point p1 = this.game1.getLocation();
            if (p1 != null) {
                g.drawImage(Const.IMAGE_BUBBLES[this.game1.getColor()], p1.x
                        + Const.PLAYER1_OFFSET_X, p1.y + Const.PLAYER1_OFFSET_Y - Const.GRID_WIDTH
                        / 2 + Const.GRID_HEIGHT / 2, this);
            }
        }
        // プレイヤ1の目かくしを描画する
        g.drawImage(Const.IMAGE_BLINDER, Const.PLAYER1_BLINDER_LOCATION.x,
                Const.PLAYER1_BLINDER_LOCATION.y, this);
        // プレイヤ1の予告おじゃまぷよを描画する
        if (this.game1.getGotJam() > 0) {
            if (this.game1.getGotJam() >= 10) {
                for (int i = 0; i < this.game1.getGotJam(); i += 10) {
                    int x = i * Const.JAM_SIZE.width / 10 + Const.PLAYER1_PRE_JAM_LOCATION.x;
                    int y = Const.PLAYER1_PRE_JAM_LOCATION.y;
                    g.drawImage(Const.IMAGE_JAM_RED, x, y, this);
                }
            } else {
                for (int i = 0; i < this.game1.getGotJam(); ++i) {
                    int x = i * Const.JAM_SIZE.width + Const.PLAYER1_PRE_JAM_LOCATION.x;
                    int y = Const.PLAYER1_PRE_JAM_LOCATION.y;
                    g.drawImage(Const.IMAGE_JAM_YELLOW, x, y, this);
                }
            }
        }
        // プレイヤ1の勝ち数を表示する
        for (int i = 0; i < this.game1.getWinCount(); ++i) {
            int x = i * Const.WIN_COUNT_SIZE.width + Const.PLAYER1_WIN_COUNT_LOCATION.x;
            int y = Const.PLAYER1_WIN_COUNT_LOCATION.y;
            g.drawImage(Const.IMAGE_WIN, x, y, this);
        }
        // プレイヤ1の落ちている泡を描画する
        try {
            for (MovingBubble bubble : this.game1.getFallingBubbles()) {
                g.drawImage(Const.IMAGE_BUBBLES[bubble.getColor()], bubble.getLocation().x
                        + Const.PLAYER1_OFFSET_X, bubble.getLocation().y + Const.PLAYER1_OFFSET_Y
                        - Const.GRID_WIDTH / 2 + Const.GRID_HEIGHT / 2, this);
            }
        } catch (ConcurrentModificationException e) {
            // 無視
        }
        // プレイヤ1の連鎖中の泡を描画する
        try {
            for (MovingBubble bubble : this.game1.getChainBubbles()) {
                g.drawImage(Const.IMAGE_BUBBLES[bubble.getColor()], bubble.getLocation().x
                        + Const.PLAYER1_OFFSET_X, bubble.getLocation().y + Const.PLAYER1_OFFSET_Y
                        - Const.GRID_WIDTH / 2 + Const.GRID_HEIGHT / 2, this);
            }
        } catch (ConcurrentModificationException e) {
            // 無視
        }
        // プレイヤ1の移動中のおじゃまぷよを描画する
        try {
            for (MovingBubble bubble : this.game1.getJumBubbles()) {
                g.drawImage(Const.IMAGE_BUBBLES[bubble.getColor()], bubble.getLocation().x
                        + Const.PLAYER1_OFFSET_X, bubble.getLocation().y + Const.PLAYER1_OFFSET_Y
                        - Const.GRID_WIDTH / 2 + Const.GRID_HEIGHT / 2, this);
            }
        } catch (ConcurrentModificationException e) {
            // 無視
        }
        graphics.drawImage(this.image, 0, 0, this);
    }

    public void update(Graphics g) {
        paint(g);
    }
}