package bubble;
import java.awt.Panel;
import java.awt.Point;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import sound.SE;

/**
 * @author Kumano Tatsuo
 * 作成日：2004/10/14
 */
public class MainLoop implements Runnable {
    /**
     * 描画対象のパネル
     */
    private Panel panel;

    /**
     * ゲームの状態
     */
    private Game game;

    /**
     * 新しいスレッドが初期化されたときに呼び出されます。
     * @param panel 描画対象のパネル
     * @param game ゲームの状態
     */
    public MainLoop(Panel panel, Game game) {
        this.panel = panel;
        this.game = game;
        this.game.setNextNextColor(this.game.getRandomColor());
        this.game.setNextColor(this.game.getRandomColor());
    }

    public void run() {
        try {
            int preVerticalKeyCount = 0;
            for (int count = 0; true; count++) {
                // 落ちている泡を動かす
                {
                    Collection<MovingBubble> toRemoveBubbles = new LinkedList<MovingBubble>();
                    for (MovingBubble bubble : this.game.getFallingBubbles()) {
                        bubble.moveDown();
                        if (bubble.getLocation().y > Const.SCREEN_HEIGHT) {
                            toRemoveBubbles.add(bubble);
                        }
                    }
                    this.game.getFallingBubbles().removeAll(toRemoveBubbles);
                }
                if (this.game.getStatus() == Const.STATUS_PLAYING) {
                    if (this.game.getPlayingStatus() == Const.PLAYING_STATUS_MOVING) {
                        // キー入力
                        if (this.game.isLeft()) {
                            this.game.moveLeft();
                        }
                        if (this.game.isRight()) {
                            this.game.moveRight();
                        }
                        if (this.game.isUp()) {
                            this.game.moveUpFast();
                        }
                        this.game.moveUpSlowly();
                        // 当たり判定
                        Point location = this.game.getLocation();
                        int x = location.x;
                        int y = location.y;
                        Point gridLocation = this.game.getGridLocation();
                        int row = gridLocation.y;
                        int col = gridLocation.x;
                        boolean wasHit = Util.getMinDistannceSq(x, y, this.game) < Util
                                .square(Const.GRID_WIDTH - 1);
                        if (wasHit || y < 0) {
                            if (this.game.getData(row, col) == Const.NO_BUBBLE) {
                                putBubble(this.game.getColor(), row, col);
                            }
                            if (!this.game.getChainBubbles().isEmpty()) {
                                this.game.setPlayingStatus(Const.PLAYING_STATUS_CHAIN_REACTION);
                            } else {
                                if (this.game.getGotJam() > 0) {
                                    Util.jam(this.game);
                                    this.game.setPlayingStatus(Const.PLAYING_STATUS_JAM);
                                } else {
                                    count = waitForLaunch();
                                }
                            }
                        }
                    } else if (this.game.getPlayingStatus() == Const.PLAYING_STATUS_CHAIN_REACTION) {
                        if (this.game.getChainBubbles().isEmpty()) {
                            // 連鎖反応が終わったとき
                            if (this.game.getGotJam() > 0) {
                                Util.jam(this.game);
                                this.game.setPlayingStatus(Const.PLAYING_STATUS_JAM);
                            } else {
                                count = waitForLaunch();
                            }
                        } else {
                            // 連鎖反応中のとき
                            Collection<MovingBubble> toRemoveBubbles = new LinkedList<MovingBubble>();
                            try {
                                for (MovingBubble bubble : this.game.getChainBubbles()) {
                                    bubble.moveToDestination(false);
                                    Point p = Util.toLocation(bubble.getDestination().y, bubble
                                            .getDestination().x);
                                    if (p.distanceSq(bubble.getLocation()) < Const.GRID_HEIGHT) {
                                        toRemoveBubbles.add(bubble);
                                        int row = bubble.getDestination().y;
                                        int col = bubble.getDestination().x;
                                        boolean canJoin = Util.canJoin(row, col, this.game, bubble
                                                .getColor());
                                        if (this.game.getData(row, col) == Const.NO_BUBBLE
                                                && canJoin) {
                                            SE.chain();
                                            putBubble(bubble.getColor(), row, col);
                                            if (this.game.getRule() != Const.RULE_FROZEN_1P) {
                                                this.game.sendJam(Const.CHAIN_JAM_NUMBER
                                                        * this.game.getChainCount());
                                            }
                                        } else {
                                            this.game.getFallingBubbles().add(
                                                    new MovingBubble(bubble.getLocation(), bubble
                                                            .getColor()));
                                        }
                                    }
                                }
                            } catch (ConcurrentModificationException e) {
                                // 無視
                            }
                            if (toRemoveBubbles.size() > 0) {
                                this.game.getChainBubbles().removeAll(toRemoveBubbles);
                            }
                        }
                    } else if (this.game.getPlayingStatus() == Const.PLAYING_STATUS_JAM) {
                        if (this.game.getJumBubbles().isEmpty()) {
                            count = waitForLaunch();
                        } else {
                            // おじゃまぷよが移動中のとき
                            Collection<MovingBubble> toRemoveBubbles = new LinkedList<MovingBubble>();
                            try {
                                for (MovingBubble bubble : this.game.getJumBubbles()) {
                                    bubble.moveToDestination(true);
                                    Point p = Util.toLocation(bubble.getDestination().y, bubble
                                            .getDestination().x);
                                    if (p.distanceSq(bubble.getLocation()) < Const.GRID_HEIGHT) {
                                        toRemoveBubbles.add(bubble);
                                        int row = bubble.getDestination().y;
                                        int col = bubble.getDestination().x;
                                        if (Util.canPutJum(row, col, this.game,
                                                new boolean[Const.STAGE_ROWS][Const.STAGE_COLS])) {
                                            SE.jam();
                                            this.game.setData(bubble.getColor(), row, col);
                                        }
                                    }
                                }
                            } catch (ConcurrentModificationException e) {
                                // 無視
                            }
                            if (toRemoveBubbles.size() > 0) {
                                this.game.getJumBubbles().removeAll(toRemoveBubbles);
                            }
                        }
                    } else {
                        if (count > Const.WAIT_TIME_TO_LAUNCH) {
                            // ゲームオーバー判定
                            int row = Const.STAGE_ROWS - 1;
                            for (int col = 0; col < Const.STAGE_COLS - (row % 2); ++col) {
                                if (this.game.getData(row, col) != Const.NO_BUBBLE) {
                                    if (Const.IS_NO_GAME_OVER) {
                                        this.game.setData(Const.NO_BUBBLE, row, col);
                                    } else {
                                        this.game.setStatus(Const.STATUS_GAME_OVER);
                                    }
                                }
                            }
                            createNewBubble();
                            if (this.game.getElapsedTime() > Const.PUYOPUYO_ACCEL_TIME) {
                                if (this.game.getRule() == Const.RULE_PUYOPUYO) {
                                    this.game.accel();
                                    this.game.resetTimer();
                                }
                            }
                            this.game.getChainBubbles().clear();
                            this.game.getJumBubbles().clear();
                            this.game.setPlayingStatus(Const.PLAYING_STATUS_MOVING);
                            // 動けない間に入力したキーを反映する
                            for (int i = 0; i < preVerticalKeyCount; ++i) {
                                this.game.moveRight();
                            }
                            for (int i = 0; i > preVerticalKeyCount; --i) {
                                this.game.moveLeft();
                            }
                            preVerticalKeyCount = 0;
                            if (this.game.getRule() == Const.RULE_FROZEN_1P) {
                                if (Util.isAllNoBubble(this.game)) {
                                    this.game.setWon(true);
                                    this.game.setStatus(Const.STATUS_WAITING_GAME_OVER);
                                }
                            }
                        } else {
                            // 動けない間
                            if (this.game.isLeft()) {
                                --preVerticalKeyCount;
                            }
                            if (this.game.isRight()) {
                                ++preVerticalKeyCount;
                            }
                        }
                    }
                } else if (this.game.getStatus() == Const.STATUS_WAITING_GAME_OVER) {
                    if (this.game.getFallingBubbles().isEmpty()) {
                        this.game.setStatus(Const.STATUS_GAME_OVER);
                    }
                } else {
                    return;
                }
                Thread.sleep(Const.MAIN_LOOP_WAIT_TIME);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 発射待ち状態に移行します。
     * @return 発射待ちカウンタの値
     */
    private int waitForLaunch() {
        this.game.setPlayingStatus(Const.PLAYING_STATUS_BEFORE_LAUNCH);
        return 0;
    }

    /**
     * 指定した位置に泡を固定します。
     * @param color 色
     * @param row 行
     * @param col 列
     */
    private void putBubble(int color, int row, int col) {
        this.game.setData(color, row, col);
        Util.eraseSameColor(row, col, this.game);
        Collection<MovingBubble> droppedBubbles = Util.dropBubble(this.game);
        if (this.game.getChainBubbles().size() > 0) {
            this.game.incrementChainCount();
        }
        Util.chainReaction(this.game, droppedBubbles);
    }

    /**
     * 新しい泡を準備します。
     */
    private void createNewBubble() {
        this.game.setLocation(Const.NEW_BUBBLE_LOCATION.x, Const.NEW_BUBBLE_LOCATION.y);
        this.game.setColor(this.game.getNextColor());
        this.game.setNextColor(this.game.getNextNextColor());
        this.game.setNextNextColor(this.game.getRandomColor());
        this.game.resetChainCount();
    }
}