package bubble;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

/**
 * メインウィンドウです。
 * @author Kumano Tatsuo
 * 作成日：2004/10/13
 */
public class MainFrame extends Frame {
    /**
     * パネル
     */
    private Panel panel;
    
    /**
     * メインウィンドウが初期化されるときに呼び出されます。 
     * @param game1 ゲームの状態
     * @param game2 ゲームの状態
     */
    public MainFrame(Game game1, Game game2) {
        this.panel = new MainPanel(game1, game2);
        this.panel.setPreferredSize(new Dimension(640, 480));
        this.add(this.panel);
        this.pack();
        this.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.addKeyListener(new KeyAdapter() {
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
                    System.exit(0);
                }
            }
        });
        this.panel.addKeyListener(new KeyAdapter() {
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
                    System.exit(0);
                }
            }
        });
    }
    
    /**
     * パネルを取得します。
     * @return パネル
     */
    public Panel getPanel() {
        return this.panel;
    }
};