package bubble;

import java.awt.Point;
import java.awt.geom.Point2D;

/**
 * 自動操縦の試験的実装です。
 * @author Kumano Tatsuo
 * Created on 2005/01/01 14:31:52
 */
public class KumanoAI4 implements AI {
    /**
     * 走っているかどうか
     */
    private boolean isRunning;

    /**
     * ゲームの情報
     */
    private final ReadOnlyGame game;

    /**
     * 危険と判断する列
     */
    private final int dangerousRow;

    /**
     * コンストラクタです。 
     * @param game ゲームの情報
     * @param dangerousRow 危険と判断する列
     */
    public KumanoAI4(ReadOnlyGame game, int dangerousRow) {
        this.game = game;
        this.isRunning = true;
        this.dangerousRow = dangerousRow;
    }

    public void run() {
        int lastY = Integer.MAX_VALUE;
        Point destination = null;
        while (this.isRunning) {
            try {
                Point2D location = this.game.getLocation();
                if (location != null) {
                    int x = (int) location.getX();
                    int y = (int) location.getY();
                    int speed = lastY - y;
                    int color = this.game.getColor();
                    if (speed > 0) {
                        if (destination == null) {
                            destination = Util.toLocation(0, 1);
                        } else {
                            moveToDestination(destination, x);
                        }
                    } else {
                        this.game.stop();
                        for (int i = 1; i < Const.STAGE_ROWS - 2; ++i) {
                            for (int j = 0; j < Const.STAGE_COLS - i % 2; ++j) {
                                if (canMoveTo(i, j)) {
                                    boolean[][] hasDone = new boolean[Const.STAGE_ROWS][Const.STAGE_COLS];
                                    if (Util.getSameColorNumberRecursively(i, j, color, this.game,
                                            hasDone) == 1) {
                                        destination = Util.toLocation(i, j);
                                        i = Const.STAGE_ROWS;
                                        break;
                                    }
                                }
                            }
                        }
                        for (int i = 1; i < Const.STAGE_ROWS - 2; ++i) {
                            for (int j = 0; j < Const.STAGE_COLS - i % 2; ++j) {
                                if (canMoveTo(i, j)) {
                                    if (getNeighbourColorCount(i, j, color) < 2) {
                                        boolean[][] hasDone = new boolean[Const.STAGE_ROWS][Const.STAGE_COLS];
                                        if (Util.getSameColorNumberRecursively(i, j, color,
                                                this.game, hasDone) == 1) {
                                            destination = Util.toLocation(i, j);
                                            i = Const.STAGE_ROWS;
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                        for (int i = 0; i < Const.STAGE_ROWS - 2; ++i) {
                            for (int j = 0; j < Const.STAGE_COLS - i % 2; ++j) {
                                if (canMoveTo(i, j)) {
                                    if (getNeighbourColorCount(i, j, color) < 2) {
                                        boolean[][] hasDone = new boolean[Const.STAGE_ROWS][Const.STAGE_COLS];
                                        if (Util.getSameColorNumberRecursively(i, j, color,
                                                this.game, hasDone) == 2) {
                                            destination = Util.toLocation(i, j);
                                            i = Const.STAGE_ROWS;
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                        if (canMoveTo(0, 1)) {
                            destination = Util.toLocation(0, 1);
                        } else if (canMoveTo(0, Const.STAGE_COLS - 2)) {
                            if (this.game.getData(0, 1) != color) {
                                destination = Util.toLocation(0, Const.STAGE_COLS - 2);
                            }
                        }
                        boolean isDangerous = false;
                        for (int j = 0; j < Const.STAGE_COLS; ++j) {
                            if (this.game.getData(this.dangerousRow, j) != Const.NO_BUBBLE) {
                                isDangerous = true;
                                break;
                            }
                        }
                        if (isDangerous || this.game.getGotJam() > 0) {
                            for (int i = 0; i < Const.STAGE_ROWS - 2; ++i) {
                                for (int j = 0; j < Const.STAGE_COLS - i % 2; ++j) {
                                    if (canMoveTo(i, j)) {
                                        boolean[][] hasDone = new boolean[Const.STAGE_ROWS][Const.STAGE_COLS];
                                        if (Util.getSameColorNumberRecursively(i, j, color,
                                                this.game, hasDone) == 2) {
                                            destination = Util.toLocation(i, j);
                                            i = Const.STAGE_ROWS;
                                            break;
                                        }
                                    }
                                }
                            }
                            for (int i = 0; i < Const.STAGE_ROWS; ++i) {
                                for (int j = 0; j < Const.STAGE_COLS - i % 2; ++j) {
                                    if (canMoveTo(i, j)) {
                                        boolean[][] hasDone = new boolean[Const.STAGE_ROWS][Const.STAGE_COLS];
                                        if (Util.getSameColorNumberRecursively(i, j, color,
                                                this.game, hasDone) > 2) {
                                            destination = Util.toLocation(i, j);
                                            i = Const.STAGE_ROWS;
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    boolean isVeryDangerous = false;
                    for (int j = 0; j < Const.STAGE_COLS; ++j) {
                        if (this.game.getData(Const.STAGE_ROWS - 3, j) != Const.NO_BUBBLE) {
                            isVeryDangerous = true;
                            break;
                        }
                    }
                    if (!isVeryDangerous || Math.abs(x - destination.x) < Const.GRID_WIDTH / 2) {
                        this.game.moveUp();
                    }
                    lastY = y;
                }
                Thread.sleep(Const.MAIN_LOOP_WAIT_TIME);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 目的地へ移動します。
     * @param destination 目的地
     * @param x x座標
     */
    private void moveToDestination(Point destination, int x) {
        this.game.stop();
        if (destination != null) {
            if (x < destination.x - Const.GRID_WIDTH / 4) {
                this.game.moveRight();
            }
            if (x > destination.x + Const.GRID_WIDTH / 4) {
                this.game.moveLeft();
            }
        } else {
            this.game.moveUp();
        }
    }

    /**
     * 指定された場所へ移動可能かを調べます。
     * @param row 行
     * @param col 列
     * @return 移動可能かどうか
     */
    private boolean canMoveTo(int row, int col) {
        boolean ret = true;
        Point p1 = Util.getAdjacent(0, row, col);
        Point p2 = Util.getAdjacent(1, row, col);
        if (row > 0 && this.game.getData(p1.y, p1.x) == Const.NO_BUBBLE
                && this.game.getData(p2.y, p2.x) == Const.NO_BUBBLE) {
            return false;
        }
        for (int i = row; i < Const.STAGE_ROWS; ++i) {
            if (this.game.getData(i, col) != Const.NO_BUBBLE) {
                return false;
            }
        }
        for (int i = row + 1; i < Const.STAGE_ROWS; i += 2) {
            if (this.game.getData(i, col - 1 + (row % 2) * 2) != Const.NO_BUBBLE) {
                return false;
            }
        }
        return ret;
    }

    /**
     * 隣接している色の数を取得します。
     * @param row 行
     * @param col 列
     * @param color 色
     * @return 色の数
     */
    private int getNeighbourColorCount(int row, int col, int color) {
        int ret = 0;
        boolean[] isUsed = new boolean[Const.COLOR_NUMBER];
        for (int direction = 0; direction < 6; ++direction) {
            Point p = Util.getAdjacent(direction, row, col);
            int c = this.game.getData(p.y, p.x);
            if (c != Const.NO_BUBBLE) {
                isUsed[c] = true;
            }
        }
        for (int c = 0; c < Const.COLOR_NUMBER; ++c) {
            if (c != color) {
                if (isUsed[c]) {
                    ++ret;
                }
            }
        }
        return ret;
    }

    public void stop() {
        this.game.stop();
        this.isRunning = false;
    }
}
