package bubble;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.Random;

/**
 * 自動操縦の試験的実装です。
 * @author Kumano Tatsuo
 * Created on 2005/01/01 14:31:52
 */
public class KumanoAI3 implements AI {
    /**
     * 走っているかどうか
     */
    private boolean isRunning;

    /**
     * ゲームの情報
     */
    private final ReadOnlyGame game;

    /**
     * コンストラクタです。 
     * @param game ゲームの情報
     */
    public KumanoAI3(ReadOnlyGame game) {
        this.game = game;
        this.isRunning = true;
    }

    public void run() {
        int lastY = Integer.MAX_VALUE;
        Point destination = null;
        while (this.isRunning) {
            try {
                Point2D location = this.game.getLocation();
                if (location != null) {
                    int x = (int) location.getX();
                    int y = (int) location.getY();
                    int speed = lastY - y;
                    int color = this.game.getColor();
                    if (speed > 0) {
                        speed *= 2;
                        if (y < Const.GRID_HEIGHT * Const.STAGE_ROWS - Const.GRID_HEIGHT / 2) {
                            if (Util.getMinDistanceSq(x, y - speed, this.game) < (Const.GRID_WIDTH + 4)
                                    * (Const.GRID_WIDTH + 4)) {
                                //                                System.out.println("DEBUG: よけます。");
                                if (Util.getMinDistanceColor(x, y - speed, this.game) != color
                                        || y > (Const.STAGE_ROWS - 2) * Const.GRID_HEIGHT) {
                                    this.game.stop();
                                    if (Util.getMinDistanceSq(x, y - speed, this.game) < (Const.GRID_WIDTH + 3)
                                            * (Const.GRID_WIDTH + 3)) {
                                        if (Util.getMinDistanceSq(x - 4, y - speed, this.game) < Util
                                                .getMinDistanceSq(x + 4, y - speed, this.game)) {
                                            this.game.moveRight();
                                        } else {
                                            this.game.moveLeft();
                                        }
                                    }
                                } else {
                                    //this.game.moveUp();
                                }
                            } else if (Util.getMinDistanceSq(x, y - speed, this.game) < (Const.GRID_WIDTH * 2)
                                    * (Const.GRID_WIDTH * 2)) {
                                //System.out.println("DEBUG: なにもしません。");
                                this.game.stop();
                                //this.game.moveUp();
                            } else {
                                //System.out.println("DEBUG: 目的地へ移動します。");
                                moveToDestination(destination, x);
                            }
                        } else {
                            destination = calcDestination(destination, color);
                            this.game.moveUp();
                        }
                    } else {
                        this.game.stop();
                    }
                    lastY = y;
                }
                Thread.sleep(Const.MAIN_LOOP_WAIT_TIME);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 目的地へ移動します。
     * @param destination 目的地
     * @param x x座標
     */
    private void moveToDestination(Point destination, int x) {
        this.game.stop();
        if (destination != null) {
            if (x < destination.x - Const.GRID_WIDTH / 6) {
                this.game.moveRight();
            }
            if (x > destination.x + Const.GRID_WIDTH / 6) {
                this.game.moveLeft();
            }
            if (destination.y < Const.GRID_HEIGHT * (Const.STAGE_ROWS - 4)) {
                this.game.moveUp();
            }
        } else {
            this.game.moveUp();
        }
    }

    /**
     * 目的地を計算します。
     * @param destination 目的地
     * @param color 色
     * @return 目的地
     */
    private Point calcDestination(Point destination, int color) {
        destination = null;
        for (int i = Const.STAGE_ROWS - 3; i >= 0; --i) {
            for (int j = 0; j < Const.STAGE_ROWS; ++j) {
                if (this.game.getData(i, j) == color) {
                    Point2D destLocation = Util.toLocation(i, j);
                    Point2D destGrid1 = Util.toGridLocation(
                            (int) (destLocation.getX() - Const.GRID_WIDTH / 2.0),
                            (int) destLocation.getY() + Const.GRID_HEIGHT);
                    Point2D destGrid2 = Util.toGridLocation(
                            (int) (destLocation.getX() + Const.GRID_WIDTH / 2.0),
                            (int) destLocation.getY() + Const.GRID_HEIGHT);
                    if (this.game.getData((int) destGrid1.getY(), (int) destGrid1.getX()) == Const.NO_BUBBLE) {
                        Point2D destLocation1 = Util.toLocation((int) destGrid1.getY(),
                                (int) destGrid1.getX());
                        if (destLocation1.getX() >= 0) {
                            destination = new Point((int) destLocation1.getX() - 4,
                                    (int) destLocation1.getY());
                            i = -1;
                            break;
                        }
                    } else if (this.game.getData((int) destGrid2.getY(), (int) destGrid2.getX()) == Const.NO_BUBBLE) {
                        Point2D destLocation2 = Util.toLocation((int) destGrid2.getY(),
                                (int) destGrid2.getX());
                        if (destLocation2.getX() <= (Const.STAGE_COLS - 1) * Const.GRID_WIDTH) {
                            destination = new Point((int) destLocation2.getX() + 4,
                                    (int) destLocation2.getY());
                            i = -1;
                            break;
                        }
                    }
                }
            }
        }
        if (destination == null) {
            int random = new Random().nextInt(3);
            switch (random) {
            case 0:
                destination = new Point(0, 0);
                break;
            case 1:
                destination = new Point(Const.GRID_WIDTH * (Const.STAGE_COLS - 1), 0);
                break;
            }
        }
        return destination;
    }

    public void stop() {
        this.game.stop();
        this.isRunning = false;
    }
}
