package bubble;
import java.awt.geom.Point2D;

/**
 * 自動操縦の試験的実装です。
 * @author Kumano Tatsuo
 * Created on 2005/01/01 14:31:52
 */
public class KumanoAI1 implements AI {
    /**
     * 走っているかどうか
     */
    private boolean isRunning;

    /**
     * ゲームの情報
     */
    private final ReadOnlyGame game;

    /**
     * コンストラクタです。 
     * @param game ゲームの情報
     */
    public KumanoAI1(ReadOnlyGame game) {
        this.game = game;
        this.isRunning = true;
    }

    public void run() {
        double lastY = Double.NaN;
        while (this.isRunning) {
            try {
                Point2D location = this.game.getLocation();
                if (location != null) {
                    double x = location.getX();
                    double y = location.getY();
                    // 一番下にある同じ色の泡にくっつける
                    int color = this.game.getColor();
                    if (color != Const.NO_BUBBLE) {
                        boolean wasDestinationFound = false;
                        double destX = Double.NaN;
                        double destY = Double.NaN;
                        for (int i = Const.STAGE_ROWS - 3; i >= 0; --i) {
                            for (int j = 0; j < Const.STAGE_ROWS; ++j) {
                                if (this.game.getData(i, j) == color) {
                                    Point2D destLocation = Util.toLocation(i, j);
                                    Point2D destGrid1 = Util.toGridLocation((int) (destLocation
                                            .getX() - Const.GRID_WIDTH / 2.0), (int) destLocation
                                            .getY()
                                            + Const.GRID_HEIGHT);
                                    Point2D destGrid2 = Util.toGridLocation((int) (destLocation
                                            .getX() + Const.GRID_WIDTH / 2.0), (int) destLocation
                                            .getY()
                                            + Const.GRID_HEIGHT);
                                    if (this.game.getData((int) destGrid1.getY(), (int) destGrid1
                                            .getX()) == Const.NO_BUBBLE) {
                                        Point2D destLocation1 = Util.toLocation((int) destGrid1
                                                .getY(), (int) destGrid1.getX());
                                        destX = destLocation1.getX() - Const.GRID_WIDTH / 20;
                                        destY = destLocation1.getY();
                                        wasDestinationFound = true;
                                        i = -1;
                                        break;
                                    } else if (this.game.getData((int) destGrid2.getY(),
                                            (int) destGrid2.getX()) == Const.NO_BUBBLE) {
                                        Point2D destLocation2 = Util.toLocation((int) destGrid2
                                                .getY(), (int) destGrid2.getX());
                                        destX = destLocation2.getX() + Const.GRID_WIDTH / 20;
                                        destY = destLocation2.getY();
                                        wasDestinationFound = true;
                                        i = -1;
                                        break;
                                    }
                                }
                            }
                        }
                        if (wasDestinationFound) {
                            if (lastY - y > 0) {
                                if (x < destX - Const.GRID_WIDTH / 6) {
                                    this.game.moveRight();
                                }
                                if (x > destX + Const.GRID_WIDTH / 6) {
                                    this.game.moveLeft();
                                }
                            }
                            if (y > destY + Const.GRID_HEIGHT / 2) {
                                this.game.moveUp();
                            }
                        } else {
                            this.game.moveUp();
                        }
                        lastY = y;
                        Thread.sleep(Const.MAIN_LOOP_WAIT_TIME);
                        this.game.stop();
                    }
                }
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void stop() {
        this.isRunning = false;
    }
}
