package bubble;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;

/**
 * 定数を集めたクラスです。
 * @author Kumano Tatsuo
 * 作成日：2004/10/13
 */
public class Const {
    /**
     * 無敵にするかどうか（デバグ用）
     */
    public static boolean IS_NO_GAME_OVER = false;

    /**
     * グリッドを表示するかどうか（デバグ用）
     */
    public static boolean SHOW_GRID = false;

    /**
     * 水平方向の速度
     */
    public static final int HORIZONTAL_SPEED = Const.GRID_WIDTH / 2;

    /**
     * 自動的に上に動く速度
     */
    public static final int VERTICAL_SLOW_SPEED = 1;

    /**
     * 泡の画像
     */
    public static final Image[] IMAGE_BUBBLES = {
            Toolkit.getDefaultToolkit().createImage(Const.class.getResource("bubble_black.png")),
            Toolkit.getDefaultToolkit().createImage(Const.class.getResource("bubble_gray.png")),
            Toolkit.getDefaultToolkit().createImage(Const.class.getResource("bubble_blue.png")),
            Toolkit.getDefaultToolkit().createImage(Const.class.getResource("bubble_green.png")),
            Toolkit.getDefaultToolkit().createImage(Const.class.getResource("bubble_yellow.png")),
            Toolkit.getDefaultToolkit().createImage(Const.class.getResource("bubble_purple.png")),
            Toolkit.getDefaultToolkit().createImage(Const.class.getResource("bubble_red.png")),
            Toolkit.getDefaultToolkit().createImage(Const.class.getResource("bubble_orange.png")) };

    /**
     * 色の数
     */
    public static final int COLOR_NUMBER = 8;

    /**
     * 泡がないことを表す定数
     */
    public static final int NO_BUBBLE = -1;

    /**
     * ゲーム開始前の状態
     */
    public static final int STATUS_BEFORE_START = 0;

    /**
     * ゲーム中の状態
     */
    public static final int STATUS_PLAYING = 1;

    /**
     * ゲームが終わるのを待っている状態
     */
    public static final int STATUS_WAITING_GAME_OVER = 2;

    /**
     * ゲームが終わった状態
     */
    public static final int STATUS_GAME_OVER = 3;

    /**
     * ゲーム中で、発射前の状態
     */
    public static final int PLAYING_STATUS_BEFORE_LAUNCH = 0;

    /**
     * ゲーム中で、操作中の状態
     */
    public static final int PLAYING_STATUS_MOVING = 1;

    /**
     * ゲーム中で、連鎖反応中の状態
     */
    public static final int PLAYING_STATUS_CHAIN_REACTION = 2;

    /**
     * ゲーム中で、おじゃまぷよを食らっている状態
     */
    public static final int PLAYING_STATUS_JAM = 3;

    /**
     * ルールの種類
     */
    public static final int RULE_COUNT = 2;

    /**
     * ぷよぷよルール
     */
    public static final int RULE_PUYOPUYO = 0;

    /**
     * Frozen Bubble の1人ルール
     */
    public static final int RULE_FROZEN_1P = 1;

    /**
     * ぷよぷよルールで、加速するまでの時間[ms]
     */
    public static final int PUYOPUYO_ACCEL_TIME = 90000;

    /**
     * 上移動キーを押したときの速度
     */
    public static final int VERTICAL_FAST_SPEED = Const.GRID_HEIGHT / 3;

    /**
     * 落ちる泡の初期速度
     */
    public static final int VERTICAL_DROP_INITIAL_SPEED = -1000;

    /**
     * 落ちる泡の加速度
     */
    public static final int VERTICAL_DROP_ACCEL = 40;

    /**
     * 連鎖反応の初速
     */
    public static final int CHAIN_REACTION_INITIAL_SPEED = 2000;

    /**
     * 連鎖反応の加速
     */
    public static final int CHAIN_REACTION_ACCEL = 20;

    /**
     * 連鎖反応の減速
     */
    public static final int CHAIN_REACTION_DECEL = 15;
    
    /**
     * 連鎖反応を速くする割合
     */
    public static final int CHAIN_REACTION_RATE = 4;
    
    /**
     * おじゃまぷよの加速
     */
    public static final int JAM_REACTION_ACCEL = 1000;

    /**
     * おじゃまぷよの減速
     */
    public static final int JAM_REACTION_DECEL = 600;

    /**
     * 何個以上同じ色の泡がつながったら消すか
     */
    public static final int MIN_ERASE_NUMBER = 3;

    /**
     * 連鎖が起きたときにいくつおじゃまぷよを送るか
     */
    public static final int CHAIN_JAM_NUMBER = 1;

    /**
     * 一度に降るおじゃまぷよの量
     */
    public static final int ONE_TIME_JAM_NUMBER = 7;

    /**
     * 横方向の当たり判定の余裕
     */
    public static final int CRASH_MARGIN = Const.GRID_WIDTH / 3;
    
    /**
     * 1つのグリッドの幅[px]
     */
    public static final int GRID_WIDTH = 30;

    /**
     * 1つのグリッドの高さ[px]
     */
    public static final int GRID_HEIGHT = 26;

    /**
     * ステージの列数
     */
    public static final int STAGE_COLS = 8;

    /**
     * ステージの行数
     */
    public static final int STAGE_ROWS = 13;

    /**
     * 描画領域の幅[px]
     */
    public static final int SCREEN_WIDTH = 640;

    /**
     * 描画領域の高さ[px]
     */
    public static final int SCREEN_HEIGHT = 480;

    /**
     * 新しい泡の相対座標
     */
    public static final Point NEW_BUBBLE_LOCATION = new Point(Const.GRID_WIDTH
            * (Const.STAGE_COLS - 1) / 2, Const.GRID_HEIGHT * Const.STAGE_ROWS);

    /**
     * 予告おじゃまぷよの大きさ
     */
    public static final Dimension JAM_SIZE = new Dimension(20, 16);

    /**
     * 黄色い予告おじゃまぷよ
     */
    public static final Image IMAGE_JAM_YELLOW = Toolkit.getDefaultToolkit().createImage(
            Const.class.getResource("jama_yellow2.png"));

    /**
     * 赤い予告おじゃまぷよ
     */
    public static final Image IMAGE_JAM_RED = Toolkit.getDefaultToolkit().createImage(
            Const.class.getResource("jama_red2.png"));

    /**
     * 勝ち数の大きさ
     */
    public static final Dimension WIN_COUNT_SIZE = new Dimension(24, 16);

    /**
     * 勝ち数の画像
     */
    public static final Image IMAGE_WIN = Toolkit.getDefaultToolkit().createImage(Const.class.getResource("win2.png"));

    /**
     * プログラムを終了する勝ち数
     */
    public static final int EXIT_WIN_COUNT = 10;

    /**
     * プレイヤ1のステージの左上のx座標[px]
     */
    public static final int PLAYER1_OFFSET_X = 20;

    /**
     * プレイヤ1のステージの左上のy座標[px]
     */
    public static final int PLAYER1_OFFSET_Y = 46;

    /**
     * プレイヤ1の次の泡の絶対座標
     */
    public static final Point PLAYER1_NEXT = new Point(295, 341);

    /**
     * プレイヤ1の次の次の泡の絶対座標
     */
    public static final Point PLAYER1_NEXT_NEXT = new Point(295, 331);

    /**
     * プレイヤ1の目隠しの左上の絶対座標
     */
    public static final Point PLAYER1_BLINDER_LOCATION = new Point(Const.PLAYER1_OFFSET_X,
            Const.GRID_HEIGHT * Const.STAGE_ROWS + Const.PLAYER1_OFFSET_Y - Const.GRID_WIDTH / 2
                    + Const.GRID_HEIGHT / 2 + 2);

    /**
     * プレイヤ1の予告おじゃまぷよの左上の絶対位置
     */
    public static final Point PLAYER1_PRE_JAM_LOCATION = new Point(Const.PLAYER1_OFFSET_X,
            Const.GRID_HEIGHT * Const.STAGE_ROWS + Const.PLAYER1_OFFSET_Y + 6);

    /**
     * プレイヤ1の勝ち数の左上の絶対座標
     */
    public static final Point PLAYER1_WIN_COUNT_LOCATION = new Point(Const.PLAYER1_OFFSET_X,
            Const.GRID_HEIGHT * Const.STAGE_ROWS + Const.PLAYER1_OFFSET_Y + Const.GRID_HEIGHT * 2);

    /**
     * プレイヤ2のステージの左上のx座標[px]
     */
    public static final int PLAYER2_OFFSET_X = Const.SCREEN_WIDTH - Const.GRID_WIDTH
            * Const.STAGE_COLS - 20;

    /**
     * プレイヤ2のステージの左上のy座標[px]
     */
    public static final int PLAYER2_OFFSET_Y = 46;

    /**
     * プレイヤ2の次の泡の絶対座標
     */
    public static final Point PLAYER2_NEXT = new Point(344, 341);

    /**
     * プレイヤ2の次の次の泡の絶対座標
     */
    public static final Point PLAYER2_NEXT_NEXT = new Point(344, 331);

    /**
     * プレイヤ2の目隠しの左上の絶対座標
     */
    public static final Point PLAYER2_BLINDER_LOCATION = new Point(Const.PLAYER2_OFFSET_X,
            Const.GRID_HEIGHT * Const.STAGE_ROWS + Const.PLAYER2_OFFSET_Y - Const.GRID_WIDTH / 2
                    + Const.GRID_HEIGHT / 2 + 2);

    /**
     * プレイヤ2の予告おじゃまぷよの左上の絶対位置
     */
    public static final Point PLAYER2_PRE_JAM_LOCATION = new Point(Const.PLAYER2_OFFSET_X,
            Const.GRID_HEIGHT * Const.STAGE_ROWS + Const.PLAYER1_OFFSET_Y + 6);

    /**
     * プレイヤ2の勝ち数の左上の絶対座標
     */
    public static final Point PLAYER2_WIN_COUNT_LOCATION = new Point(Const.PLAYER2_OFFSET_X,
            Const.GRID_HEIGHT * Const.STAGE_ROWS + Const.PLAYER2_OFFSET_Y + Const.GRID_HEIGHT * 2);

    /**
     * 背景画像
     */
    public static final Image IMAGE_BACKGROUND = Toolkit.getDefaultToolkit().createImage(
            Const.class.getResource("haikei.png"));

    /**
     * 目かくしの画像
     */
    public static final Image IMAGE_BLINDER = Toolkit.getDefaultToolkit().createImage(Const.class.getResource("blind.png"));

    /**
     * おじゃまぷよを受け取る間隔（n回目の再描画で受け取る）
     */
    public static final int JAM_INTERVAL = 10;

    /**
     * 発射待ちの時間
     */
    public static final int WAIT_TIME_TO_LAUNCH = 5;

    /**
     * パネルを再描画する待ち時間[ms]
     */
    public static final int REPAINT_WAIT_TIME = 50;

    /**
     * ゲームオーバーの待ち時間[ms]
     */
    public static final int GAME_OVER_WAIT_TIME = 600;

    /**
     * メインループの待ち時間[ms]
     */
    public static final int MAIN_LOOP_WAIT_TIME = 50;
}
