
import java.awt.Panel;
import java.io.IOException;
import java.util.Random;
import sound.SE;
import bubble.Const;
import bubble.Game;
import bubble.KeyHandler;
import bubble.MainFrame;
import bubble.MainLoop;
import bubble.Util;

/**
 * メインクラスです。
 * @author Kumano Tatsuo
 * 作成日：2004/10/13
 * 2004/10/13	0.1	初版です。
 * 2004/10/14	0.2	固定した泡を表示できるようになりました。
 * 2004/10/14	0.3	泡のアニメーションを表示してみました。
 * 2004/10/15	0.4	移動中の泡を表示できるようになりました。
 * 2004/10/15	0.5	2人用の画面が表示できるようになりました。
 * 2004/10/15	0.6	固定した泡に接触すると、固定するようにしました。
 * 2004/10/15	0.7	ステージ外に移動できないようにしました。
 * 2004/10/15	0.8	初期配置をランダムにしました。
 * 2004/10/15	0.9	一番下の行に泡が固定したときに、ゲームオーバーにするようにしました。
 * 2004/10/15	1.0	ステージ外移動チェックを厳しくしました。
 * 2004/10/15	1.1	動いている泡が固定したときに、同じ色が消えるようにしました。
 * 2004/10/15	1.2	隣接した泡を求める処理を共通化しました。
 * 2004/10/15	1.3	ぶら下がることのできなくなった泡を落とすようにしました。	
 * 2004/10/16	1.4	落ちている泡をアニメーション表示するようにしました。	
 * 2004/10/16	1.5	消した泡をアニメーション表示するようにしました。	
 * 2004/10/16	1.6	泡が少しずつ出て来るようにしました。	
 * 2004/10/16	1.6	次に出る泡の色を表示するようにしました。	
 * 2004/10/16	1.7	連鎖反応が起きるようになりました。	
 * 2004/10/16	1.8	連鎖反応が正しく起きないことがある不具合を修正しました。	
 * 2004/10/16	1.9	連鎖反応のときの動きを派手にしました。	
 * 2004/10/16	2.0	重複コードを減らしました。	
 * 2004/10/16	2.1	予告おじゃまぷよが表示されるようになりました。
 * 2004/10/17	2.2	おじゃまぷよが降るようになりました。
 * 2004/10/17	2.3	マジックナンバーを減らしました。
 * 2004/10/17	2.3	おじゃまぷよの降らせ方を派手にしました。
 * 2004/10/17	2.4	キーを押してからゲームを始めるようにしました。
 * 2004/10/17	2.5	勝ち数を表示するようにしました。
 * 2004/10/17	2.6	時間が経つと、泡が速くなるようにしました。
 * 2004/10/18	2.7	速くなった泡の速度が元にもどらない不具合を修正しました。
 * 2004/10/18	2.8	動いている泡が固定した泡を上書きする不具合を修正しました。
 * 2004/10/18	2.9	連鎖の終了判定を厳密にしました。
 * 2004/10/19	3.0	同時に速くなるようにしました。
 * 2004/10/19	3.1	おじゃまぷよで泡が消えないようにしました。
 * 2004/10/19	3.2	相殺が正しく起こるようになりました。
 * 2004/10/19	3.3	おじゃまぷよが速く収束するようにしました。
 * 2004/10/19	3.4	連鎖中に泡が消える不具合を一部修正しました。
 * 2004/10/19	3.5	固定した泡と予告おじゃまぷよ、勝ち数に画像を貼りつけるようにしました。
 * 2004/10/19	3.6	おじゃまぷよが消える不具合を修正しました。
 * 2004/10/19	3.7	連鎖数によっておじゃまぷよの数が変わるようにしました。
 * 2004/10/20	3.8	連鎖中に行き先がなくなった泡を消さずに、落とすようにしました。
 * 2004/10/20	3.9	発射前に押したキーが反映されるようにしました。
 * 2004/10/20	4.0	一方が一定数勝てば、プログラムを終了するようにしました。
 * 2004/10/20	4.1	動かしている泡が固定した泡に上書きされる不具合を修正しました。
 * 2004/10/21	4.2	ルールを選べるようにしました。
 * 2004/10/22	4.3	ファイルからステージを読み込めるようになりました。
 * 2004/10/22	4.4	ランダムなファイルをから読み込むようにしました。
 * 2004/10/23	4.5	1Pモードで、全消しで勝ちにするようにしました。
 * 2004/10/23	4.6	同じ色の泡を複数落としたときに、1つしか連鎖しない不具合を修正しました。
 * 2004/10/23	4.7	ルールによって背景色を変えるようにしました。
 * 2004/10/24	4.8	連鎖中に泡が横方向に大きく移動する不具合を修正しました。
 * 2004/10/24	4.9	1Pモードで、最初からステージにある色の泡しか出て来ないようにしました。
 * 2004/10/25	5.0	片方がゲームオーバーになってもゲームが終了しない不具合を修正しました。
 * 2004/10/25	5.1	1Pモードで、全ての色のおじゃまぷよが降る不具合を修正しました。
 * 2004/10/26	5.2	背景画像を貼りつけました。
 * 2004/10/27	5.3	次の次の泡の色が見えるようにしました。
 * 2004/11/19	5.4	おじゃまぷよが全て降り終ってから次の泡がでてくるようにしました。
 * 2004/11/25	5.5	一度に降るおじゃまぷよの数を制限しました。
 * 2004/11/27	5.6	jarファイルにまとめました。
 * 2004/11/27	5.7	1Pモードで、default-levelsetからだけ読みこむようにしました。
 * 2004/11/27	5.8	1Pモードではおじゃまぷよが降らないようにしました。
 * 2004/11/27	5.9	当たり判定を甘くしました。
 * 2004/11/27	6.0	連鎖中に、目的地が下にある泡程早く収束するようにしました。
 * 2005/01/01	6.1	当たり判定を厳しくしました。
 * 2005/01/01	6.2	連鎖の収束を遅くしました。
 * 2005/01/01	6.3	自動操縦のための準備をしました。
 * 2005/01/01	6.4	自動操縦を実装しました。
 * 2005/01/02	6.5	別の自動操縦を実装しました。
 * 2005/01/02	6.6	自動操縦を賢くしました。
 * 2005/01/05	6.7	収束の速度を速くしました。
 * 2005/01/05	6.8	横方向に移動する速度を速くしました。
 * 2005/01/06	6.9	ハンデをつけることができるようになりました。
 * 2005/01/07	7.0	消しつづける自動操縦を作ってみました。
 * 2005/01/08	7.1	消しつづける自動操縦を強くしました。
 * 2005/01/08	7.2	自動操縦にパラメータを与えるようにしました。
 * 2005/01/09	7.3	パッケージ管理をしました。
 * 2005/01/09	7.4	音を鳴らすようにしました。
 * 2005/01/10	7.5	ハンデをやめました。
 */
public class Main {
    /**
     * メインメソッドです。
     * @param args コマンドライン引数
     * @throws Exception 例外
     */
    public static void main(String[] args) throws Exception {
        Game game1 = new Game();
        Game game2 = new Game();
        MainFrame frame = new MainFrame(game1, game2);
        frame.setTitle("Bubble");
        Panel panel = frame.getPanel();
        KeyHandler keyHandler = new KeyHandler(panel, game1, game2);
        panel.addKeyListener(keyHandler);
        frame.addKeyListener(keyHandler);
        SE.preLoad();
        frame.setVisible(true);
        while (true) {
            waitForKey(game1, game2, panel);
            // 開始待ち
            game1.setStatus(Const.STATUS_BEFORE_START);
            game2.setStatus(Const.STATUS_BEFORE_START);
            // ゲーム開始
            game1.clearData();
            game2.clearData();
            game1.initializeSpeed();
            game2.initializeSpeed();
            game1.setGotJam(0);
            game2.setGotJam(0);
            game1.setPutJam(0);
            game2.setPutJam(0);
            game1.getFallingBubbles().clear();
            game2.getFallingBubbles().clear();
            game1.setWon(false);
            game2.setWon(false);
            int seed = new Random().nextInt();
            game1.setRandom(new Random(seed));
            game2.setRandom(new Random(seed));
            readFromFile(game1, game2);
            game1.setStatus(Const.STATUS_PLAYING);
            game1.setPlayingStatus(Const.PLAYING_STATUS_BEFORE_LAUNCH);
            game2.setStatus(Const.STATUS_PLAYING);
            game2.setPlayingStatus(Const.PLAYING_STATUS_BEFORE_LAUNCH);
            MainLoop mainLoop1 = new MainLoop(panel, game1);
            MainLoop mainLoop2 = new MainLoop(panel, game2);
            Thread thread1 = new Thread(mainLoop1);
            thread1.start();
            Thread thread2 = new Thread(mainLoop2);
            thread2.start();
            int count = 0;
            while (game1.getStatus() != Const.STATUS_GAME_OVER
                    && game2.getStatus() != Const.STATUS_GAME_OVER
                    && game1.getStatus() != Const.STATUS_WAITING_GAME_OVER
                    && game2.getStatus() != Const.STATUS_WAITING_GAME_OVER) {
                panel.repaint();
                if (count % Const.JAM_INTERVAL == 0) {
                    int jum1 = game1.getPutJam();
                    int jum2 = game2.getPutJam();
                    game1.setPutJam(0);
                    game2.setPutJam(0);
                    if (jum1 > jum2) {
                        jum1 -= jum2;
                        jum2 = 0;
                    } else {
                        jum2 -= jum1;
                        jum1 = 0;
                    }
                    if (jum1 > 0) {
                        game2.setGotJam(game2.getGotJam() + jum1);
                    }
                    if (jum2 > 0) {
                        game1.setGotJam(game1.getGotJam() + jum2);
                    }
                }
                Thread.sleep(Const.REPAINT_WAIT_TIME);
                ++count;
            }
            if (game1.getStatus() == Const.STATUS_WAITING_GAME_OVER) {
                game1.incrementWinCount();
                game2.setStatus(Const.STATUS_GAME_OVER);
            } else if (game2.getStatus() == Const.STATUS_WAITING_GAME_OVER) {
                game2.incrementWinCount();
                game1.setStatus(Const.STATUS_GAME_OVER);
            } else if (game1.getStatus() == Const.STATUS_GAME_OVER) {
                game2.incrementWinCount();
                game1.setStatus(Const.STATUS_GAME_OVER);
                game2.setStatus(Const.STATUS_GAME_OVER);
            } else if (game2.getStatus() == Const.STATUS_GAME_OVER) {
                game1.incrementWinCount();
                game1.setStatus(Const.STATUS_GAME_OVER);
                game2.setStatus(Const.STATUS_GAME_OVER);
            }
            while (game1.getStatus() != Const.STATUS_GAME_OVER
                    || game2.getStatus() != Const.STATUS_GAME_OVER) {
                panel.repaint();
                Thread.sleep(Const.REPAINT_WAIT_TIME);
            }
            game1.setStatus(Const.STATUS_GAME_OVER);
            game2.setStatus(Const.STATUS_GAME_OVER);
            Thread.sleep(Const.GAME_OVER_WAIT_TIME);
            if (game1.getWinCount() >= Const.EXIT_WIN_COUNT
                    || game2.getWinCount() >= Const.EXIT_WIN_COUNT) {
                waitForKey(game1, game2, panel);
                System.exit(0);
            }
        }
    }

    /**
     * @param game1 ゲーム1
     * @param game2 ゲーム2
     * @throws IOException 例外
     */
    private static void readFromFile(Game game1, Game game2) throws IOException {
        if (game1.getRule() == Const.RULE_FROZEN_1P) {
            Util.readFromFile(game1, game2, "default-levelset");
            Util.setBadColors(game1);
            Util.setBadColors(game2);
        } else {
            game1.clearData();
            game2.clearData();
            game1.clearBadColors();
            game2.clearBadColors();
            Util.setRandomData(game1, game1.getOdds());
            Util.setRandomData(game2, game2.getOdds());
        }
    }

    /**
     * キー入力を待ちます。
     * @param game1 ゲーム1
     * @param game2 ゲーム2
     * @param panel パネル
     * @throws InterruptedException 例外
     * @throws IOException 例外
     */
    private static void waitForKey(Game game1, Game game2, Panel panel)
            throws InterruptedException, IOException {
        int rule = game1.getRule();
        game1.isLeftKeyPressed();
        game2.isLeftKeyPressed();
        game1.isRightKeyPressed();
        game2.isRightKeyPressed();
        game1.isUpKeyPressed();
        game2.isUpKeyPressed();
        while (!(game1.isUpKeyPressed() || game2.isUpKeyPressed())) {
            if (game1.isLeftKeyPressed() || game2.isLeftKeyPressed()) {
                rule = (rule - 1 + Const.RULE_COUNT) % Const.RULE_COUNT;
                game1.setRule(rule);
                game2.setRule(rule);
            }
            if (game1.isRightKeyPressed() || game2.isRightKeyPressed()) {
                rule = (rule + 1) % Const.RULE_COUNT;
                game1.setRule(rule);
                game2.setRule(rule);
            }
            panel.repaint();
            Thread.sleep(Const.REPAINT_WAIT_TIME);
        }
    }
}
