package server;

/**
 * サーバの定数を集めたクラスです。
 * @author Kumano Tatsuo
 * Created on 2005/02/19 14:00:27
 */
public class ServerConstants {
    /**
     * プレイヤの初期速度
     */
    public static final int SERVER_PLAYER_DEFAULT_SPEED = 250;

    /**
     * 持っている爆弾の数の初期値
     */
    public static final int SERVER_PLAYER_DEFAULT_BOMB_NUMBER = 100;

    /**
     * 火力の初期値
     */
    public static final byte SERVER_PLAYER_DEFAULT_POWER = 4;
    
    /**
     * 爆弾の速度
     */
    public static final int SERVER_BOMB_SPEED = 150;

    /**
     * 爆弾を蹴ってから動けるようになるまでの時間
     */
    public static final int SERVER_PLAYER_KICK_TIME = 200;
    
    /**
     * サーバのスレッドでの待ち時間[ms]
     */
    public static final int SERVER_THREAD_WAIT_TIME = 50;

    /**
     * 壊せないブロックの密度
     */
    public static final double SERVER_HARD_BLOCK_DENSITY = 0.2;

    /**
     * 壊せるブロックの密度
     */
    public static final double SERVER_SOFT_BLOCK_DENSITY = 0.2;

    /**
     * 壊れたブロックを修復するまでの待ち時間[ms]
     */
    public static final int SERVER_SOFT_BLOCK_FIX_WAIT_TIME = 10000;

    /**
     * 壊れないブロックと壊れるブロックを入れ換えるまでの待ち時間[ms]
     */
    public static final int SERVER_EXCHANGE_SOFT_BLOCK_AND_HARD_BLOCK_WAIT_TIME = 10000;

    /**
     * レートを記録するファイル名
     */
    public static final String SERVER_RATE_FILE = "rate.txt";

    /**
     * レートの初期値
     */
    public static final String SERVER_RATE_DEFAULT = "1200";
    
    /**
     * 爆弾が爆発するまでの時間
     */
    public static final int SERVER_BOMB_BLOW_TIME = 3000;
}
