package client;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.WindowConstants;
import common.CommonConstants;
import common.Replace;
import common.Sha;

/**
 * @author Kumano Tatsuo
 * Created on 2005/01/21 14:10:35
 */
public class LoginDialog extends JDialog {
    /**
     * エラーメッセージ
     */
    JLabel message;

    /**
     * 1Pの名前
     */
    JTextField name1;

    /**
     * 1Pのパスワード
     */
    JPasswordField pass1;

    /**
     * 2Pの名前
     */
    JTextField name2;

    /**
     * 2Pのパスワード
     */
    JPasswordField pass2;

    /**
     * @return 入力が完了したかどうか
     */
    public boolean isOK() {
        return this.isOK;
    }

    /**
     * 入力が完了したかどうか
     */
    boolean isOK = false;

    /**
     * ダイアログボックスを初期化します。
     * @param owner 所有者
     * @param title タイトル
     * @param modal モーダルかどうか
     * @param out1 1Pの出力ストリーム
     * @param out2 2Pの出力ストリーム
     */
    public LoginDialog(Frame owner, String title, boolean modal, final DataOutputStream out1,
            final DataOutputStream out2) {
        super(owner, title, modal);
        this.setDefaultCloseOperation(WindowConstants.HIDE_ON_CLOSE);
        ActionListener listener = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                try {
                    if (LoginDialog.this.name1.getText().length() > 0) {
                        out1.writeByte(CommonConstants.COMMAND_MY_NAME);
                        out1.writeUTF(LoginDialog.this.name1.getText());
                        out1.writeByte(CommonConstants.COMMAND_MY_PASS);
                        out1.writeUTF(Sha.digest(LoginDialog.this.pass1.getPassword()));
                        LoginDialog.this.isOK = true;
                    }
                    if (LoginDialog.this.name2.getText().length() > 0) {
                        out2.writeByte(CommonConstants.COMMAND_MY_NAME);
                        out2.writeUTF(LoginDialog.this.name2.getText());
                        out2.writeByte(CommonConstants.COMMAND_MY_PASS);
                        out2.writeUTF(Sha.digest(LoginDialog.this.pass2.getPassword()));
                        LoginDialog.this.isOK = true;
                    }
                } catch (IOException e1) {
                    e1.printStackTrace();
                }
                dispose();
            }
        };
        KeyListener previewListener = new KeyListener() {
            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                String string = Replace.replace(((JTextField) (e.getSource())).getText(),
                        CommonConstants.TABOO_EXPRESSION, "");
                string = string.substring(0, Math.min(string.length(), CommonConstants.NAME_LENGTH));
                if (string.length() > 0) {
                    LoginDialog.this.message.setText(string);
                } else {
                    LoginDialog.this.message.setText(" ");
                }
            }
        };
        this.message = new JLabel(" ");
        this.add(this.message, BorderLayout.NORTH);
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(4, 2));
        panel.add(new JLabel("1Pの名前"));
        this.name1 = new JTextField();
        this.name1.setPreferredSize(new Dimension(100, 20));
        this.name1.addActionListener(listener);
        this.name1.addKeyListener(previewListener);
        panel.add(this.name1);
        panel.add(new JLabel("1Pのパスワード"));
        this.pass1 = new JPasswordField();
        this.pass1.setPreferredSize(new Dimension(100, 20));
        this.pass1.setEchoChar('●');
        this.pass1.addActionListener(listener);
        panel.add(this.pass1);
        panel.add(new JLabel("2Pの名前"));
        this.name2 = new JTextField();
        this.name2.setPreferredSize(new Dimension(100, 20));
        this.name2.addActionListener(listener);
        this.name2.addKeyListener(previewListener);
        panel.add(this.name2);
        panel.add(new JLabel("2Pのパスワード"));
        this.pass2 = new JPasswordField();
        this.pass2.setPreferredSize(new Dimension(100, 20));
        this.pass2.setEchoChar('●');
        this.pass2.addActionListener(listener);
        panel.add(this.pass2);
        JButton button = new JButton("ログイン");
        button.addActionListener(listener);
        this.add(panel, BorderLayout.CENTER);
        this.add(button, BorderLayout.SOUTH);
        this.pack();
        this.setLocation(owner.getX() + owner.getWidth() / 2 - this.getWidth() / 2, owner.getY()
                + owner.getHeight() / 2 - this.getHeight() / 2);
    }
}
