package map;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;

/**
 * 定数を集めたクラスです。
 * @author Kumano Tatsuo
 * Created on 2005/05/03 9:07:02
 */
public class Const {
	/**
	 * 国土数値情報関係の定数を集めたクラスです。
	 * @author Kumano Tatsuo
	 * 2005/11/14
	 */
	public static class Ksj {
		/**
		 * 国土数値情報の配布URL
		 */
		public static final String BASE_URL = "http://nlftp.mlit.go.jp/ksj/dls/data/";

		/**
		 * キャッシュディレクトリの相対パス
		 */
		public static final String CACHE_DIR = ".map" + File.separator + "ksj";

		/**
		 * 国土数値情報の行政界・海岸線の展開済みファイルの接頭語
		 */
		public static final String TXT_PREFIX = "N03-11A-2K_";
		
		/**
		 * 国土数値情報の行政界・海岸線の展開済みファイルの接尾語
		 */
		public static final String TXT_SUFFIX = ".txt";
		
		/**
		 * 国土数値情報の行政界・海岸線の圧縮ファイルの接頭語
		 */
		public static final String ZIP_PREFIX = "N03-11A-";
		
		/**
		 * 国土数値情報の行政界・海岸線の圧縮ファイルの接尾語
		 */
		public static final String ZIP_SUFFIX = "-01.0a.zip";
	}

	/**
	 * 数値地図2500関係の定数を集めたクラスです。
	 * @author Kumano Tatsuo
	 * 2005/11/14
	 */
	public static class Sdf2500 {
		/**
		 * 数値地図2500（空間データ基盤）の配布URL 
		 */
		public static final String BASE_URL = "http://sdf.gsi.go.jp/";

		/**
		 * キャッシュディレクトリの相対パス 
		 */
		public static final String CACHE_DIR = ".map" + File.separator + "cache";

		/**
		 * 展開済みファイルの一覧を記録したファイル
		 */
		public static final String EXTRACTED_LOG_FILE = CACHE_DIR + File.separator
				+ "extractedfiles.txt";
	}

	/**
	 * ファイルの一覧が記載されているファイル
	 */
	public static final URL FILE_LIST = Const.class.getResource("files.csv");

	/**
	 * ゴシック体のフォント
	 */
	public static final String FONT_FAMILY_GOTHIC = Arrays.asList(
			GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames())
			.contains("MS UI Gothic") ? "MS UI Gothic" : Arrays.asList(
			GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames())
			.contains("Kochi Gothic") ? "Kochi Gothic" : "SansSerif";

	/**
	 * 明朝体のフォント
	 */
	public static final String FONT_FAMILY_MINCHO = Arrays.asList(
			GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames())
			.contains("ＭＳ Ｐ明朝") ? "ＭＳ Ｐ明朝" : Arrays.asList(
			GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames())
			.contains("Kochi Mincho") ? "Kochi Mincho" : "Serif";

	/**
	 * コンポーネント間の隙間[px]
	 */
	public static final int GAP = 4;

	/**
	 * 一度読み込んだ地図を捨てずに置いておく範囲
	 */
	public static final double KEEP_COFFICIENT = 1;

	/**
	 * 地図を先読みする範囲
	 */
	public static final double PRE_LOAD_COEFFICIENT = 0;

	/**
	 * 高精度の都道府県の情報が記載されているファイルの接頭語
	 */
	public static final String PREFECTURE_PREFIX = "prefecture_";

	/**
	 * 高精度の都道府県の情報が記載されているファイルの拡張子
	 */
	public static final String PREFECTURE_SUFFIX = ".csv";

	/**
	 * 全ての都道府県の情報が記載されているファイル
	 */
	public static final InputStream PREFECTURES = Const.class
			.getResourceAsStream("prefectures.csv");

	/**
	 * 数値地図2500（空間データ基盤）を読み込む表示倍率
	 */
	public static final double ZOOM_LOAD_2500 = 0.06;

	/**
	 * 全てのデータを読み込む表示倍率 
	 */
	public static final double ZOOM_LOAD_ALL = 0.3;

	/**
	 * 国土数値情報の市区町村データを読み込む倍率
	 */
	public static final double ZOOM_LOAD_CITIES = 0.003;

	/**
	 * 高精度の国土数値情報の市区町村データを読み込む倍率
	 */
	public static final double ZOOM_LOAD_FINE_CITIES = 0.006;

	/**
	 * 丁目のポリゴンデータを読み込む表示倍率
	 */
	public static final double ZOOM_LOAD_GYOUSEI = 0.15;
	
	/**
	 * 表示倍率の最大値
	 */
	public static final double ZOOM_MAX = 1;
	
	/**
	 * 表示倍率の変化率
	 */
	public static final double ZOOM_RATE = 1.1;
}
