package map;

import java.awt.geom.Rectangle2D;
import java.util.Map;

/**
 * 地図を読み込むクラスです。
 * @author Kumano Tatsuo
 * 作成日: 2004/01/09
 */
class LoadMap {
	/**
	 * 変更されたかどうか
	 */
	private boolean isChanged;

	/** 地図を読み込む必要があれば読み込み、開放する必要があれば開放します。
	 * このメソッドを呼び出した直後に isChanged() を呼び出すと、
	 * このメソッドによって地図の状態が変化したかどうかが取得できます。
	 * @param maps 地図
	 * @param panel パネル
	 * @throws Exception
	 */
	void loadMap(Map<String, MapData> maps, MapPanel panel) throws Exception {
		double zoom = panel.getZoom();
		this.isChanged = false;
		for (MapData mapData : maps.values()) {
			if (panel.isIdle()) {
				Rectangle2D visibleRectangle = panel.getVisibleRectangle();
				Rectangle2D preLoadRectangle = new Rectangle2D.Double(visibleRectangle.getX()
						- (visibleRectangle.getWidth() * Const.PRE_LOAD_COEFFICIENT),
						visibleRectangle.getY()
								- (visibleRectangle.getHeight() * Const.PRE_LOAD_COEFFICIENT),
						visibleRectangle.getWidth()
								+ (visibleRectangle.getWidth() * Const.PRE_LOAD_COEFFICIENT * 2),
						visibleRectangle.getHeight()
								+ (visibleRectangle.getHeight() * Const.PRE_LOAD_COEFFICIENT * 2));
				Rectangle2D keepRectangle = new Rectangle2D.Double(visibleRectangle.getX()
						- (visibleRectangle.getWidth() * Const.KEEP_COFFICIENT), visibleRectangle
						.getY()
						- (visibleRectangle.getHeight() * Const.KEEP_COFFICIENT), visibleRectangle
						.getWidth()
						+ (visibleRectangle.getWidth() * Const.KEEP_COFFICIENT * 2),
						visibleRectangle.getHeight()
								+ (visibleRectangle.getHeight() * Const.KEEP_COFFICIENT * 2));
				// データを開放する
				if (zoom < Const.ZOOM_LOAD_GYOUSEI) {
					if (mapData.hasGyousei()) {
						mapData.freeSi_tyo();
						mapData.freeTyome();
						mapData.freeGyousei();
						this.isChanged = true;
					}
				}
				if (zoom < Const.ZOOM_LOAD_ALL) {
					if (mapData.hasRoadArc()) {
						mapData.freeRoadArc();
						this.isChanged = true;
					}
					if (mapData.hasMizuArc()) {
						mapData.freeMizu();
						mapData.freeMizuArc();
						this.isChanged = true;
					}
					if (mapData.hasTatemonoArc()) {
						mapData.freeTatemono();
						mapData.freeTatemonoArc();
						this.isChanged = true;
					}
					if (mapData.hasZyouti()) {
						mapData.freeZyouti();
						this.isChanged = true;
					}
				}
				if (mapData.getBounds().intersects(preLoadRectangle)) {
					// データを読み込む
					if (zoom >= Const.ZOOM_LOAD_GYOUSEI) {
						if (!mapData.hasGyousei()) {
							mapData.loadGyousei();
							//mapData.loadSi_tyo();
							mapData.loadTyome();
							this.isChanged = true;
						}
						if (!mapData.hasOthers()) {
							mapData.loadOthers();
							this.isChanged = true;
						}
					}
					if (zoom >= Const.ZOOM_LOAD_ALL) {
						if (!mapData.hasRoadArc()) {
							mapData.loadRoadArc();
							this.isChanged = true;
						}
						if (!mapData.hasMizuArc()) {
							mapData.loadMizuArc();
							mapData.loadMizu();
							this.isChanged = true;
						}
						if (!mapData.hasTatemonoArc()) {
							mapData.loadTatemonoArc();
							mapData.loadTatemono();
							this.isChanged = true;
						}
						if (!mapData.hasZyouti()) {
							mapData.loadZyouti();
							this.isChanged = true;
						}
					}
					// 駅のデータを読み込む
					if (!mapData.hasEki()) {
						mapData.loadEki();
						this.isChanged = true;
					}
					// 高速道路、国道、主要地報道のデータを読み込む
					if (!mapData.hasLargeRoadArc()) {
						mapData.loadLargeRoadArc();
						this.isChanged = true;
					}
				} else if (!mapData.getBounds().intersects(keepRectangle)) {
					// データを開放する
					if (mapData.hasGyousei()) {
						mapData.freeSi_tyo();
						mapData.freeTyome();
						mapData.freeGyousei();
					}
					if (mapData.hasMizuArc()) {
						mapData.freeMizu();
						mapData.freeMizuArc();
					}
					if (mapData.hasOthers()) {
						mapData.freeZyouti();
					}
					if (mapData.hasTatemonoArc()) {
						mapData.freeTatemono();
						mapData.freeTatemonoArc();
					}
					if (mapData.hasRoadArc()) {
						mapData.freeRoadArc();
					}
					if (mapData.hasEki()) {
						mapData.freeEki();
					}
					if (mapData.hasLargeRoadArc()) {
						mapData.freeLargeRoadArc();
					}
				}
			}
		}
	}

	/**
	 * 直前の読み込みで、地図の状態が変化したかどうかを取得します。
	 * @return 地図の状態が変化したかどうか
	 */
	boolean isChanged() {
		return this.isChanged;
	}
}
