package map;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.net.URL;

/**
 * 国土数値情報の行政界・海岸線（面）から作成された1つの市区町村を管理するクラスです。
 * @author Kumano Tatsuo
 * 2005/11/11
 */
public class City {
	/**
	 * 領域
	 */
	private final Shape shape;

	/**
	 * 外接長方形
	 */
	private final Rectangle2D bounds;

	/**
	 * 市区町村名
	 */
	private final String label;

	/**
	 * 市区町村コード
	 */
	private final String id;

	/**
	 * 数値地図2500（空間データ基盤）のURL
	 */
	private final URL url;
	
	/**
	 * @return 市区町村コード
	 */
	public String getId() {
		return this.id;
	}

	/**
	 * @return 市区町村名
	 */
	public String getLabel() {
		return this.label;
	}

	/**
	 * @return 領域
	 */
	public Shape getShape() {
		return this.shape;
	}

	/**
	 * @return 外接長方形
	 */
	public Rectangle2D getBounds() {
		return this.bounds;
	}

	/**
	 * @return 数値地図2500（空間データ基盤）のURL
	 */
	public URL getURL() {
		return this.url;
	}
	
	/**
	 * 市区町村を初期化します。
	 * @param shape 領域
	 * @param label 市区町村名
	 * @param id 市区町村コード
	 * @param url 数値地図2500（空間データ基盤）のURL
	 */
	public City(final Shape shape, final String label, final String id, final URL url) {
		this.shape = shape;
		this.bounds = shape.getBounds2D();
		this.label = label;
		this.id = id;
		this.url = url;
	}
}
