/*
 * $Id: DMSconv.java,v 1.2 2002/03/17 10:52:42 nie Exp $
 */

package jp.jasminesoft.gcat.scalc;

/**
 * 10進表記の緯度経度を DDD.MMSS 形式に変換します。
 *
 * @version     $Revision: 1.2 $ $Date: 2002/03/17 10:52:42 $
 * @author	Yoshinori Nie
 */

public class DMSconv {
    public static float deg2dms(float f) {
	//
	// 33.09014 (10進数表記) である緯度を考える。
	// まず、deg = 33, min = 0.09014 と分ける。
	// 次に、min0 を 9 とし、60 進表記した min1 = 0.054 を求める。
	// ここで、min1 の有効値となる mm = 5 を取り除いた、秒の部分となる
	// 少数部分を再度求めると、sec = 0.0068079 となる。
	// この sec を秒として算出すると、0.02452 が出てくる。
	// すなわち、最終的な表記として、
	// 33 + 0.05 + 0.02452 = 33.052452 が求まる。
	//
	int deg = (int)f;
	double min = f - deg;
	int min0 = (int)(min * 100.0);
//System.out.println("min0:"+min0);
	double min1 = (min0 * 60.0) / 10000.0;
//System.out.println("min1:"+min1);
        int mm = (int)(min1 * 100.0);
//System.out.println("mm:"+mm);
        double sec = min - (mm / 60.0);
//System.out.println("sec:"+sec);
	min = mm / 100.0;
	sec = (sec * 3600.0) / 10000.0;

	float ret = (float)(deg + min + sec);

	return ret;
    }

    /*
     * テスト
     */
    public static void main(String[] argv) {
	System.out.println(DMSconv.deg2dms(129.5f));
    }
}


