import java.io.File;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

/**
 * SWTが実行できるかどうかを調べるためのプログラムです。
 * @author Kumano Tatsuo
 * Created on 2005/05/28 20:00:01
 */
public class SWTTest {
    /**
     * メインメソッドです。
     * @param args コマンドライン引数
     */
    public static void main(String[] args) {
        System.out.println("DEBUG: カレントディレクトリは" + new File("").getAbsolutePath());
        final Display display = new Display();
        final Shell shell = new Shell(display);
        shell.setText("SWTのテスト");
        final GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        shell.setLayout(layout);
        // メニューバー
        final Menu menubar = new Menu(shell, SWT.BAR);
        shell.setMenuBar(menubar);
        final MenuItem fileItem = new MenuItem(menubar, SWT.CASCADE);
        fileItem.setText("メニュー(&M)");
        final Menu fileMenu = new Menu(fileItem);
        fileItem.setMenu(fileMenu);
        final MenuItem exitItem = new MenuItem(fileMenu, SWT.PUSH);
        exitItem.setText("メニューアイテム(&I)");
        // ツールバー
        final ToolBar toolBar = new ToolBar(shell, SWT.PUSH);
        final ToolItem handToolItem = new ToolItem(toolBar, SWT.RADIO);
        handToolItem.setImage(new Image(display, SWTTest.class.getResourceAsStream("hand.gif")));
        handToolItem.setText("選択肢&1");
        handToolItem.setSelection(true);
        final ToolItem zoomToolItem = new ToolItem(toolBar, SWT.RADIO);
        zoomToolItem.setText("選択肢&2");
        zoomToolItem.setImage(new Image(display, SWTTest.class.getResourceAsStream("zoom.gif")));
        final GridData toolBarGridData = new GridData(GridData.FILL_HORIZONTAL);
        toolBar.setLayoutData(toolBarGridData);
        // サッシ
        final SashForm sash = new SashForm(shell, SWT.NULL);
        final GridData sashGridData = new GridData(GridData.FILL_BOTH);
        sash.setLayoutData(sashGridData);
        // タブ
        final Composite sideComposite = new Composite(sash, SWT.NULL);
        sideComposite.setLayout(new FillLayout(SWT.VERTICAL));
        final TabFolder tabFolder = new TabFolder(sideComposite, SWT.NULL);
        final TabItem tabItem = new TabItem(tabFolder, SWT.NULL);
        tabItem.setText("タブ");
        // サイドパネル
        final Composite loadComposite = new Composite(tabFolder, SWT.NULL);
        final GridLayout loadLayout = new GridLayout(1, true);
        loadComposite.setLayout(loadLayout);
        tabItem.setControl(loadComposite);
        final Label searchLabel = new Label(loadComposite, SWT.NULL);
        searchLabel.setText("ラベル(&L)");
        final Text searchText = new Text(loadComposite, SWT.BORDER);
        searchText.setFocus();
        final List resultList = new List(loadComposite, SWT.BORDER | SWT.MULTI
                | SWT.V_SCROLL | SWT.H_SCROLL);
        resultList.add("リスト1行目");
        resultList.add("リスト2行目");
        final Button loadButton = new Button(loadComposite, SWT.BORDER);
        loadButton.setText("ボタン(&B)");
        final GridData searchTextGridData = new GridData(
                GridData.FILL_HORIZONTAL);
        searchText.setLayoutData(searchTextGridData);
        final GridData resultListGridData = new GridData(GridData.FILL_BOTH);
        resultList.setLayoutData(resultListGridData);
        final GridData loadGridData = new GridData(GridData.FILL_HORIZONTAL);
        loadButton.setLayoutData(loadGridData);
        // キャンバス
        final Canvas canvas = new Canvas(sash, SWT.BORDER);
        canvas.setBackground(new Color(display, 255, 255, 255));
        // 表示する
        final int width = 640;
        final int sideWidth = 200;
        final int height = 480;
        sash.setWeights(new int[] { sideWidth, width - sideWidth });
        shell.setSize(width, height);
        shell.open();
        while (!shell.isDisposed()) {
            if (!display.readAndDispatch()) {
                display.sleep();
            }
        }
    }
}
