import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import map.BackgroundThread;
import map.Const;
import map.MapData;
import map.MapPanel;
import search.Search;
import swt.SWTMainFrame;
import cell.CellSearch;

/**
 * SWTを用いるアプリケーション版のMapです。
 * @author Kumano Tatsuo
 * Created on 2005/05/14 16:33:43
 */
public class SWTMain {

    /**
     * メインメソッドです。
     * @param args コマンドライン引数
     * @throws Exception 例外 
     */
    public static void main(String[] args) throws Exception {
        final Map<String, MapData> maps = new TreeMap<String, MapData>();
        final MapPanel panel = new MapPanel(maps);
        final SWTMainFrame frame = new SWTMainFrame(maps, panel);
        frame.start();
        final Search search = new CellSearch(2000, 1500);
        System.out.println("DEBUG: カレントディレクトリは" + new File("").getAbsolutePath());
        String baseDir = null;
        final List<String> list = new ArrayList<String>();
        if (Const.IS_OFFLINE) {
            baseDir = (args.length > 0) ? args[0] : "data";
            if (new File(baseDir).isDirectory()) {
                final String[] files = new File(baseDir).list();
                final Pattern pattern = Pattern
                        .compile("[0-9][0-9][a-zA-Z][a-zA-Z][0-9][0-9][0-9]");
                for (int i = 0; i < files.length; i++) {
                    if (pattern.matcher(files[i]).matches()) {
                        list.add(files[i].toLowerCase());
                    }
                }
            }
        } else {
            baseDir = (args.length > 0) ? Const.SERVER + args[0] : Const.SERVER
                    + "kobe";
            final URL url = new URL(baseDir);
            final Scanner scanner = new Scanner(new InputStreamReader(url
                    .openStream(), "SJIS"));
            while (scanner.hasNextLine()) {
                final String line = scanner.nextLine();
                final Pattern pattern = Pattern
                        .compile("[0-9][0-9][a-zA-Z][a-zA-Z][0-9][0-9][0-9]");
                final Matcher matcher = pattern.matcher(line);
                if (matcher.find()) {
                    list.add(matcher.group().toLowerCase());
                }
            }
            scanner.close();
        }
        for (final String mapName : list) {
            MapData map = new MapData(baseDir, mapName);
            maps.put(mapName, map);
            search.insert(map.getBounds(), mapName);
        }
        panel.setSearch(search);
        while (!frame.isReady()) {
            Thread.sleep(100);
        }
        panel.setSWTSize(frame.getCancasSize());
        panel.calcMinMaxXY();
        panel.zoomAutomaticaly();
        panel.moveToCenter();
        new BackgroundThread(maps, panel, frame).start();
    }

}
