package map;

import java.io.File;
import java.net.URL;

/**
 * 定数を集めたクラスです。
 * @author Kumano Tatsuo
 * Created on 2005/05/03 9:07:02
 */
public class Const {
    /**
     * 地図データのURL
     */
    public static final String SERVER = "http://zenjiro.dyndns.org/sdf.gsi.go.jp/data2500/";

    /**
     * オフラインモードかどうか
     */
    public static boolean IS_OFFLINE = true;

    /**
     * ファイルシステムのセパレータ
     */
    public static String SEPARATOR = File.separator;

    /**
     * 地図を先読みする範囲
     */
    public static final double preLoadCoefficient = 0;

    /**
     * 一度読み込んだ地図を捨てずに置いておく範囲
     */
    public static final double keepCoefficient = 1;

    /**
     * 丁目のポリゴンデータを読み込む表示倍率
     */
    public static final double loadGyouseiZoom = 0.15;

    /**
     * 全てのデータを読み込む表示倍率 
     */
    public static final double loadOtherZoom = 0.3;

    /**
     * 地図データの配布URL 
     */
    public static final String BASE_URL = "http://sdf.gsi.go.jp/";

    /**
     * キャッシュディレクトリの相対パス 
     */
    public static final String CACHE_DIR = ".map" + File.separator + "cache";

    /**
     * ファイルの一覧が記載されているファイル
     */
    public static final URL FILE_LIST = Const.class.getResource("files.csv");

    /**
     * コンポーネント間の隙間[px]
     */
    public static final int GAP = 10;

}
