package psout;

import java.awt.print.Printable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.print.DocFlavor;
import javax.print.PrintException;
import javax.print.SimpleDoc;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;

/**
 * PSファイルを出力するためのクラスの、DocPrintJobを用いた実装です。
 * @author Masahiko Kusaki
 * modified by Kumano Tatsuo on 2005/01/31
 * 2005年2月10日   staticメソッドに変更しました。
 */
public class DocPrintJobPSOut {
    /**
     * PSファイルを出力します。
     * @param file 出力するファイル
     * @param painter 印刷のためのオブジェクト
     * @throws PrintException 印刷例外 
     * @throws IOException 入出力例外
     */
    public static void print(final File file, final Printable painter) throws PrintException,
            IOException {
        final DocFlavor flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        final StreamPrintServiceFactory[] factories = StreamPrintServiceFactory
                .lookupStreamPrintServiceFactories(flavor, DocFlavor.BYTE_ARRAY.POSTSCRIPT
                        .getMimeType());
        if (factories.length > 0) {
            final OutputStream out = new FileOutputStream(file);
            factories[0].getPrintService(out).createPrintJob().print(
                    new SimpleDoc(painter, flavor, new HashDocAttributeSet()),
                    new HashPrintRequestAttributeSet());
            out.close();
        } else {
            System.err.println("ERROR: No suitable factories.");
        }
    }
}
