package map;

import java.io.File;

/**
 * 定数を集めたクラスです。
 * @author Kumano Tatsuo
 * Created on 2005/05/03 9:07:02
 */
public class Const {
    /**
     * 地図データのURL
     */
    public static final String SERVER = "http://zenjiro.dyndns.org/sdf.gsi.go.jp/data2500/";

    /**
     * オフラインモードかどうか
     */
    public static boolean IS_OFFLINE = true;
    
    /**
     * ファイルシステムのセパレータ
     */
    public static String SEPARATOR = File.separator;

    /**
     * 地図を先読みする範囲
     */
    public static final double preLoadCoefficient = 0;

    /**
     * 一度読み込んだ地図を捨てずに置いておく範囲
     */
    public static final double keepCoefficient = 1;

    /**
     * 丁目のポリゴンデータを読み込む表示倍率
     */
    public static final double loadGyouseiZoom = 0.15;

    /**
     * 全てのデータを読み込む表示倍率 
     */
    public static final double loadOtherZoom = 0.3;
}
