
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

/**
 * 複数の図郭にまたがったポリゴンを見かけ上結合し、
 * 丁目の属性を結合されたポリゴンの中央に配置するクラスです。
 * @author Kumano Tatsuo
 * 作成日: 2004/01/09
 */
class JoinPolygon {
    /**
     * 変更されたかどうか
     */
    private boolean isChanged;

    /** 複数の図郭にまたがったポリゴンを見かけ上結合します。
     * このメソッドを呼び出した直後に isChanged() を呼び出すと、
     * このメソッドによって地図の状態が変化したかどうかが取得できます。
     * @param maps 地図
     * @throws Exception 例外 
     */
    void joinPolygon(Map maps) throws Exception  {
        this.isChanged = false;
        Map<PolygonData, Set<PolygonData>> joiningPolygons = new HashMap<PolygonData, Set<PolygonData>>(); // Map<Polygon = Set<Polygon>>
        for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
            MapData mapData = (MapData) ((Entry) iter.next()).getValue();
            Map edgePolygons = mapData.getEdgePolygons();
            if (edgePolygons != null) {
                for (Iterator iter2 = maps.entrySet().iterator(); iter2.hasNext();) {
                    MapData mapData2 = (MapData) ((Entry) iter2.next()).getValue();
                    Map edgePolygons2 = mapData2.getEdgePolygons();
                    if (edgePolygons2 != null) {
                        if (mapData.hashCode() != mapData2.hashCode()) {
                            //System.out.println("1 = " + mapData.getMapName() + ", 2 = " + mapData2.getMapName());
                            //System.out.println("edgePolygons = " + edgePolygons);
                            //System.out.println("edgePolygons2 = " + edgePolygons2);
                            for (Iterator iter3 = edgePolygons.entrySet().iterator(); iter3
                                    .hasNext();) {
                                Entry entry3 = (Entry) iter3.next();
                                String key = (String) entry3.getKey();
                                String polygonName = (String) entry3.getValue();
                                if (mapData.hasTyome()) {
                                    if (mapData.getTyome().containsKey(polygonName)) {
                                        PolygonData polygon = (PolygonData) mapData.getTyome().get(
                                                polygonName);
                                        if (edgePolygons2.containsKey(key)) {
                                            String polygonName2 = (String) edgePolygons2.get(key);
                                            if (mapData2.hasTyome()) {
                                                Map polygons2 = mapData2.getTyome();
                                                if (polygons2.containsKey(polygonName2)) {
                                                    if ((polygon.getAttribute() != null)
                                                            && (((PolygonData) polygons2
                                                                    .get(polygonName2))
                                                                    .getAttribute() != null)) {
                                                        if (polygon.getAttribute().equals(
                                                                ((PolygonData) polygons2
                                                                        .get(polygonName2))
                                                                        .getAttribute())) {
                                                            //System.out.println(polygonName + " is joining to " + polygonName2);
                                                            if (!joiningPolygons
                                                                    .containsKey(polygon)) {
                                                                joiningPolygons.put(polygon,
                                                                        new HashSet<PolygonData>());
                                                            }
                                                            joiningPolygons.get(polygon).add(
                                                                    (PolygonData) polygons2
                                                                            .get(polygonName2));
                                                        } else {
                                                            //System.out.println(polygon + "と" + polygon2 + "は属性が一致しません。");
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                if (mapData.hasZyouti()) {
                                    if (mapData.getZyouti().containsKey(polygonName)) {
                                        PolygonData polygon = (PolygonData) mapData.getZyouti()
                                                .get(polygonName);
                                        if (edgePolygons2.containsKey(key)) {
                                            String polygonName2 = (String) edgePolygons2.get(key);
                                            if (mapData2.hasZyouti()) {
                                                Map polygons2 = mapData2.getZyouti();
                                                if (polygons2.containsKey(polygonName2)) {
                                                    if ((polygon.getAttribute() != null)
                                                            && (((PolygonData) polygons2
                                                                    .get(polygonName2))
                                                                    .getAttribute() != null)) {
                                                        if (polygon.getAttribute().equals(
                                                                ((PolygonData) polygons2
                                                                        .get(polygonName2))
                                                                        .getAttribute())) {
                                                            //System.out.println(polygonName + " is joining to " + polygonName2);
                                                            if (!joiningPolygons
                                                                    .containsKey(polygon)) {
                                                                joiningPolygons.put(polygon,
                                                                        new HashSet<PolygonData>());
                                                            }
                                                            joiningPolygons.get(polygon).add(
                                                                    (PolygonData) polygons2
                                                                            .get(polygonName2));
                                                        } else {
                                                            //System.out.println(polygon + "と" + polygon2 + "は属性が一致しません。");
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                if (mapData.hasMizu()) {
                                    if (mapData.getMizu().containsKey(polygonName)) {
                                        PolygonData polygon = (PolygonData) mapData.getMizu().get(
                                                polygonName);
                                        if (edgePolygons2.containsKey(key)) {
                                            String polygonName2 = (String) edgePolygons2.get(key);
                                            if (mapData2.hasMizu()) {
                                                Map polygons2 = mapData2.getMizu();
                                                if (polygons2.containsKey(polygonName2)) {
                                                    if ((polygon.getAttribute() != null)
                                                            && (((PolygonData) polygons2
                                                                    .get(polygonName2))
                                                                    .getAttribute() != null)) {
                                                        if (polygon.getAttribute().equals(
                                                                ((PolygonData) polygons2
                                                                        .get(polygonName2))
                                                                        .getAttribute())) {
                                                            //System.out.println(polygonName + " is joining to " + polygonName2);
                                                            if (!joiningPolygons
                                                                    .containsKey(polygon)) {
                                                                joiningPolygons.put(polygon,
                                                                        new HashSet<PolygonData>());
                                                            }
                                                            joiningPolygons.get(polygon).add(
                                                                    (PolygonData) polygons2
                                                                            .get(polygonName2));
                                                        } else {
                                                            //System.out.println(polygon + "と" + polygon2 + "は属性が一致しません。");
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        //System.out.println("joining polygons: " + joiningPolygons);
        ArrayList<Set<PolygonData>> finalPolygons = new ArrayList<Set<PolygonData>>(); // ArrayList<Set>
        for (Entry<PolygonData, Set<PolygonData>> entry : joiningPolygons.entrySet()) {
            PolygonData key = (PolygonData) entry.getKey();
            Set<PolygonData> values = entry.getValue();
            boolean isKeyFound = false;
            for (Set<PolygonData> set : finalPolygons) {
                if (set.contains(key)) {
                    set.addAll(values);
                    isKeyFound = true;
                }
            }
            for (PolygonData value : values) {
                for (Set<PolygonData> set : finalPolygons) {
                    if (set.contains(value)) {
                        set.add(key);
                        set.addAll(values);
                        isKeyFound = true;
                    }
                }
            }
            if (!isKeyFound) {
                Set<PolygonData> set = new LinkedHashSet<PolygonData>();
                set.add(key);
                set.addAll(values);
                finalPolygons.add(set);
            }
        }
        for (Set<PolygonData> polygons : finalPolygons) {
            Area area = new Area();
            for (PolygonData polygon : polygons) {
                if (polygon != null) {
                    area.add(polygon.getArea());
                }
            }
            for (PolygonData polygon : polygons) {
                if (polygon != null) {
                    double x = area.getBounds().getCenterX();
                    double y = area.getBounds().getCenterY();
                    if ((polygon.getX() != x) || (polygon.getY() != y)) {
                        polygon.setX(x);
                        polygon.setY(y);
                        this.isChanged = true;
                    }
                    polygon.setArea(area);
                }
            }
        }
    }

    /**
     * 直前の結合で、地図の状態が変化したかどうかを取得します。
     * @return 地図の状態が変化したかどうか
     */
    boolean isChanged() {
        return this.isChanged;
    }
}
