import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;

import java.util.Stack;


/*
 * 2003/12/11
 */

/**
 * ̤ɽ饹Ǥ
 * @author Kumano Tatsuo
 */
class ArcData {
    /**
     * PathIterator  currentSegment ͤ礭
     */
    private static final int COORDS_NUMBER = 6;

    /**
     * JR ʳŴƻɽǤ
     */
    public static final int RAILWAY_OTHER = 0;

    /**
     * JR ɽǤ
     */
    public static final int RAILWAY_JR = 1;

    /**
     * JR ɽǤ
     */
    public static final int RAILWAY_JR_SHINKANSEN = 2;

    /**
     * ̾Τ̤ƻϩɽǤ
     */
    public static final int ROAD_MAJOR = 1;

    /**
     * ®ƻϩɽǤ
     */
    public static final int ROAD_HIGHWAY = 5;

    /**
     * ƻɽǤ
     */
    public static final int ROAD_CHIHODO = 3;

    /**
     * ƻɽǤ
     */
    public static final int ROAD_KENDO = 2;

    /**
     * ƻɽǤ
     */
    public static final int ROAD_KOKUDO = 4;

    /**
     * ̾ƻϩɽǤ
     */
    public static final int ROAD_NORMAL = 0;

    /**
     * ¿ϢΥݥꥴɽ뤿˳δ֤ĤʤɽǤ
     */
    public static final int TAG_DETACHED = COORDS_NUMBER;

    /**
     * ޳ԤˤݥꥴĤ뤿ο޳ΰǤ륢ɽǤ
     */
    public static final int TAG_EDGE_OF_MAP = 5;

    /**
     * ɸϤζˤݥꥴĤ뤿κɸ϶ΰǤ륢ɽǤ
     */
    public static final int TAG_EDGE_OF_WORLD = 15;

    /**
     * ºݤ褵̾ΥɽǤ
     */
    public static final int TAG_NORMAL = 0;

    /**
     * ͤɽǤ
     */
    public static final int TAG_OVERPASS = 1;

    /**
     * ϲȥͥɽǤ
     */
    public static final int TAG_TUNNEL = 2;

    /**
     * ̤ϸγݥꥴ뤿˰Գμ¤ʳɽǤ
     */
    public static final int TAG_UNCERTAIN = 4;

    /**
     * βο島ɽǤ
     */
    public static final int TAG_UNDER_BRIDGE = 3;

    /**
     * ĮܳɽǤ
     */
    public static final int TYPE_GYOUSEI_CHOME = 4;

    /**
     * ԻԡԤζ賦ɽǤ
     */
    public static final int TYPE_GYOUSEI_CITY = 2;

    /**
     * ƻܸɽǤ
     */
    public static final int TYPE_GYOUSEI_PREFECTURE = 1;

    /**
     * Į¼ԻԤζ賦ɽǤ
     */
    public static final int TYPE_GYOUSEI_VILLAGE = 3;

    /**
     * ̳ɽǤ
     */
    public static final int TYPE_MIZU_INSIDE = 13;

    /**
     * ɽǤ
     */
    public static final int TYPE_MIZU_SEASHORE = 14;

    /**
     * ŴƻɽǤ
     */
    public static final int TYPE_RAILWAY = 5;

    /**
     * ƻϩɽǤ
     */
    public static final int TYPE_ROAD = COORDS_NUMBER;

    /**
     * ʿ޼ʬॳɤɽǤ
     */
    public static final int TYPE_UNKNOWN = 0;

    /**
     * ϳɽǤ
     */
    public static final int TYPE_ZYOTI_GRAVEYARD = 11;

    /**
     * ¾ξϳɽǤ
     */
    public static final int TYPE_ZYOTI_OTHER = 12;

    /**
     * ԻԸ೦ɽǤ
     */
    public static final int TYPE_ZYOTI_PARK = 8;

    /**
     * Ŵƻ߳ɽǤ
     */
    public static final int TYPE_ZYOTI_RAILROAD = 7;

    /**
     * عϳɽǤ
     */
    public static final int TYPE_ZYOTI_SCHOOL = 9;

    /**
     * ҡ⳦ɽǤ
     */
    public static final int TYPE_ZYOTI_TEMPLE = 10;

    /**
     * ֹ
     */
    private String arcName; // ֹ

    /**
     * °
     */
    private String attribute; // °

    /**
     * ޼ʬॳ
     */
    private int classification; // ޼ʬॳ

    /**
     * ѥ
     */
    private GeneralPath path; // ѥ

    /**
     * ƻϩμ
     */
    private int roadType; // ƻϩμ

    /**
     * Ŵƻμ
     */
    private int railwayType; // Ŵƻμ

    /**
     * 勵
     */
    private int tag; // 勵

    /**
     * °ɽ x ɸ
     */
    private double attributeX; // °ɽ x ɸ

    /**
     * °ɽ y ɸ
     */
    private double attributeY; // °ɽ y ɸ

    /**
     * ̤ޤ
     * @param string ̤θֹ
     * @param generalPath ̤ѥ
     * @param type ̤ο޼ʬॳ
     * @param lineTag ̤勵
     */
    ArcData(String string, GeneralPath generalPath, int type, int lineTag) {
        this.arcName = string;
        this.path = generalPath;
        this.classification = type;
        this.tag = lineTag;
    }

    /**
     * ֹޤ
     * @return ֹ
     */
    String getArcName() {
        return arcName;
    }

    /**
     * ޼ʬॳɤޤ
     * @return ޼ʬॳ
     */
    int getClassification() {
        return classification;
    }

    /**
     * ̤ѥޤ
     * @return ѥ
     */
    GeneralPath getPath() {
        return path;
    }

    /**
     * ̤ѥոˤѥޤ
     * @return ѥ
     */
    GeneralPath getReversalPath() {
        GeneralPath ret = new GeneralPath();
        Stack stack = new Stack();

        for (PathIterator iter = path.getPathIterator(new AffineTransform());
                !iter.isDone(); iter.next()) {
            double[] coords = new double[COORDS_NUMBER];
            iter.currentSegment(coords);

            double x = coords[0];
            double y = coords[1];
            stack.push(new Point2D.Double(x, y));
        }

        Point2D firstPoint = (Point2D) stack.pop();
        ret.moveTo((float) firstPoint.getX(), (float) firstPoint.getY());

        while (!stack.isEmpty()) {
            Point2D point = (Point2D) stack.pop();

            if ((tag == ArcData.TAG_DETACHED)
                    || (tag == ArcData.TAG_EDGE_OF_MAP)
                    || (tag == ArcData.TAG_EDGE_OF_WORLD)) {
                ret.lineTo((float) point.getX(), (float) point.getY());
            } else {
                ret.lineTo((float) point.getX(), (float) point.getY());
            }
        }

        return ret;
    }

    /**
     * ƻϩμޤ
     * @return ƻϩμ
     */
    int getRoadType() {
        return roadType;
    }

    /**
     * Ŵƻμޤ
     * @return Ŵƻμ
     */
    int getRailwayType() {
        return railwayType;
    }

    /**
     * 勵ޤ
     * @return 勵
     */
    int getTag() {
        return tag;
    }

    /**
     * °ꤷޤ
     * @param string °
     */
    void setAttribute(String string) {
        this.attribute = string;
    }

    /**
     * °ޤ
     * @return °
     */
    String getAttribute() {
        return attribute;
    }

    /**
     * Ŵƻμꤷޤ
     * @param type Ŵƻμ
     */
    void setRailwayType(int type) {
        railwayType = type;
    }

    /**
     * ƻϩμꤷޤ
     * @param type ƻϩμ
     */
    void setRoadType(int type) {
        roadType = type;
    }

    /**
     * ̤ʸɽޤ
     * @return ʸɽ
     */
    public String toString() {
        return "[Arc " + arcName + "(" + attribute + ")]";
    }

    /**
     * °褹 x ɸޤ
     * @return x ɸ
     */
    public double getAttributeX() {
        return attributeX;
    }

    /**
     * °褹 y ɸޤ
     * @return x ɸ
     */
    public double getAttributeY() {
        return attributeY;
    }

    /**
     * °褹ɸꤷޤ
     * @param x x ɸ
     * @param y y ɸ
     */
    public void setAttributeLocation(double x, double y) {
        attributeX = x;
        attributeY = y;
    }
}
