import java.awt.geom.*;
import java.util.*;

/*
 * : 2004/01/09
 */

/**
 * Ͽޤɤ߹९饹Ǥ
 * @author Kumano Tatsuo
 */
class LoadMap {

	private boolean isChanged;

	/** Ͽޤɤ߹ɬפɤ߹ߡɬפгޤ
         * Υ᥽åɤƤӽФľ isChanged() ƤӽФȡ
         * Υ᥽åɤˤäϿޤξ֤ѲɤǤޤ
         * @param maps Ͽ
         * @param panel ѥͥ
         * @throws Exception
         */
	void loadMap(Map maps, MapPanel panel) throws Exception {
		double preLoadCoefficient = 0;
		double keepCoefficient = 1;
		double loadGyouseiZoom = 0.15;
		double loadOtherZoom = 0.3;
		double zoom = panel.getZoom();
		isChanged = false;
		for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
			Map.Entry entry = (Map.Entry) iter.next();
			MapData mapData = ((MapData) entry.getValue());
			if (panel.isIdle()) {
				Rectangle2D visibleRectangle = ((MapPanel) panel).getVisibleRectangle();
				Rectangle2D preLoadRectangle =
					new Rectangle2D.Double(
						visibleRectangle.getX() - visibleRectangle.getWidth() * preLoadCoefficient,
						visibleRectangle.getY() - visibleRectangle.getHeight() * preLoadCoefficient,
						visibleRectangle.getWidth() + visibleRectangle.getWidth() * preLoadCoefficient * 2,
						visibleRectangle.getHeight() + visibleRectangle.getHeight() * preLoadCoefficient * 2);
				Rectangle2D keepRectangle =
					new Rectangle2D.Double(
						visibleRectangle.getX() - visibleRectangle.getWidth() * keepCoefficient,
						visibleRectangle.getY() - visibleRectangle.getHeight() * keepCoefficient,
						visibleRectangle.getWidth() + visibleRectangle.getWidth() * keepCoefficient * 2,
						visibleRectangle.getHeight() + visibleRectangle.getHeight() * keepCoefficient * 2);
				// ǡ
				if (zoom < loadGyouseiZoom) {
					if (mapData.hasGyousei()) {
						mapData.freeSi_tyo();
						mapData.freeTyome();
						mapData.freeGyousei();
						isChanged = true;
					}
					if(mapData.hasOthers()){
						mapData.freeOthers();
						isChanged = true;
					}
					if (mapData.hasEki()) {
						mapData.freeEki();
						isChanged = true;
					}
				}
				if (zoom < loadOtherZoom) {
					if (mapData.hasRoadArc()) {
						mapData.freeRoadArc();
						isChanged = true;
					}
					if (mapData.hasMizuArc()) {
						mapData.freeMizu();
						mapData.freeMizuArc();
						isChanged = true;
					}
					if (mapData.hasTatemonoArc()) {
						mapData.freeTatemono();
						mapData.freeTatemonoArc();
						isChanged = true;
					}
					if (mapData.hasZyouti()) {
						mapData.freeZyouti();
						isChanged = true;
					}
				}
				if (preLoadRectangle.intersects(mapData.getBounds())) {
					// ǡɤ߹
					if (zoom > loadGyouseiZoom) {
						if (!mapData.hasGyousei()) {
							mapData.loadGyousei();
							//mapData.loadSi_tyo();
							mapData.loadTyome();
							isChanged = true;
						}
						if (!mapData.hasEki()) {
							mapData.loadEki();
							isChanged = true;
						}
						if (!mapData.hasOthers()) {
							mapData.loadOthers();
							isChanged = true;
						}
					}
					if (zoom > loadOtherZoom) {
						if (!mapData.hasRoadArc()) {
							mapData.loadRoadArc();
							isChanged = true;
						}
						if (!mapData.hasMizuArc()) {
							mapData.loadMizuArc();
							mapData.loadMizu();
							isChanged = true;
						}
						if (!mapData.hasTatemonoArc()) {
							mapData.loadTatemonoArc();
							mapData.loadTatemono();
							isChanged = true;
						}
						if (!mapData.hasZyouti()) {
							mapData.loadZyouti();
							isChanged = true;
						}
					}
				} else if (!keepRectangle.intersects(mapData.getBounds())) {
					// ǡ
					if (mapData.hasGyousei()) {
						mapData.freeSi_tyo();
						mapData.freeTyome();
						mapData.freeGyousei();
					}
					if (mapData.hasMizuArc()) {
						mapData.freeMizu();
						mapData.freeMizuArc();
					}
					if (mapData.hasOthers()) {
						mapData.freeZyouti();
						mapData.freeOthers();
					}
					if (mapData.hasTatemonoArc()) {
						mapData.freeTatemono();
						mapData.freeTatemonoArc();
					}
					if (mapData.hasRoadArc()) {
						mapData.freeRoadArc();
					}
					if (mapData.hasEki()) {
						mapData.freeEki();
						isChanged = true;
					}
				}
			}
		}
	}

	/**
	 * ľɤ߹ߤǡϿޤξ֤Ѳɤޤ
	 * @return Ͽޤξ֤Ѳɤ
	 */
	boolean isChanged() {
		return isChanged;
	}

}
