import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.util.*;

import javax.swing.*;

/**
 * Ͽޤѥͥ褹륯饹Ǥ
 * @author Kumano Tatsuo
 */
class MapPanel extends JPanel {

	private Map maps;
	private boolean isZoomChanged; // Ψѹ줿ɤ
	private double lastHeight; // ľι⤵
	private double lastMouseX; // ľΥޥɸ
	private double lastMouseY; // ľΥޥɸ
	private double lastWidth; // ľ
	private double maxX;
	private double maxY;
	private double minX;
	private double minY;
	private double offsetX; // եå(ºɸ)
	private double offsetY; // եå(ºɸ)
	private double zoom; // ɽΨ
	private boolean isIdle; // 桼ʤ֤ɤ
	private boolean needsRepaint; // 褬ɬפɤ
	private double lastMousePressedX;
	private double lastMousePressedY;
	private double mouseMotionWidth;
	private double mouseMotionHeight;
	private Image image;

	void setNeedsRepaint(boolean b) {
		needsRepaint = b;
	}

	/**
	 * 󥹥ȥ饯Ǥ
	 * ե졼Υꤷޤ
	 */
	MapPanel() {
		setBackground(Color.white);
		offsetX = 0;
		offsetY = 0;
		zoom = 1;
		isZoomChanged = true;
		lastMouseX = offsetX;
		lastMouseY = offsetY;
		lastWidth = getWidth();
		lastHeight = getHeight();
		setIdle(true);
		setNeedsRepaint(true);
		addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				lastMouseX = e.getX();
				lastMouseY = e.getY();
				lastMousePressedX = e.getX();
				lastMousePressedY = e.getY();
				setIdle(false);
			}
			public void mouseReleased(MouseEvent e) {
				mouseMotionWidth = 0;
				mouseMotionHeight = 0;
				setNeedsRepaint(true);
				setIdle(true);
			}
		});
		addMouseMotionListener(new MouseMotionAdapter() {
			public void mouseDragged(MouseEvent e) {
				offsetX -= e.getX() - lastMouseX;
				offsetY -= e.getY() - lastMouseY;
				lastMouseX = e.getX();
				lastMouseY = e.getY();
				mouseMotionWidth = e.getX() - lastMousePressedX;
				mouseMotionHeight = e.getY() - lastMousePressedY;
				repaint();
			}
		});
		addMouseWheelListener(new MouseWheelListener() {
			public void mouseWheelMoved(MouseWheelEvent e) {
				double newZoom = zoom * (1 + (double) e.getWheelRotation() / 50);
				double newX = (offsetX + e.getX()) / zoom * newZoom - e.getX();
				double newY = (offsetY + e.getY()) / zoom * newZoom - e.getY();
				offsetX = newX;
				offsetY = newY;
				zoom = newZoom;
				isZoomChanged = true;
				setNeedsRepaint(true);
			}
		});
	}

	/**
	 * @param maps maps (String -> MapData)
	 */
	void setMapData(Map maps) {
		this.maps = maps;
	}

	/**
	 * @return
	 */
	double getMaxX() {
		return maxX;
	}

	/**
	 * @return
	 */
	double getMaxY() {
		return maxY;
	}

	/**
	 * @return
	 */
	double getMinX() {
		return minX;
	}

	/**
	 * @return
	 */
	double getMinY() {
		return minY;
	}

	/**
	 * ֥Ȥ¸ߤϰϤޤ
	 * @return ֥Ȥ¸ߤϰϡʲۺɸ
	 */
	Rectangle2D getObjectArea() {
		return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
	}

	/**
	 * ɽƤϰϤޤ
	 * @return ɽƤϰϡʲۺɸ
	 */
	Rectangle2D getVisibleRectangle() {
		return new Rectangle2D.Double(offsetX / zoom, offsetY / zoom, getWidth() / zoom, getHeight() / zoom);
	}

	/**
	 * Ψޤ
	 * @return Ψ
	 */
	double getZoom() {
		return zoom;
	}

	/**
	 * ꤷ֥Ȥɽꥢˤ뤫ɤޤ
	 * @param shape ֥
	 * @return ꤷ֥Ȥɽꥢˤ뤫ɤ
	 */
	boolean isVisible(Shape shape) {
		return shape.intersects(getVisibleRectangle());
	}

	/**
	 * Ψѹ줿ɤޤ
	 * @return Ψѹ줿ɤ
	 */
	boolean isZoomChanged() {
		if (isZoomChanged) {
			isZoomChanged = false;
			return true;
		} else {
			return false;
		}
	}

	void moveToCenter() {
		calcMinMaxXY();
		offsetX = (minX + maxX) / 2 * zoom - getWidth() / 2;
		offsetY = (minY + maxY) / 2 * zoom - getHeight() / 2;
		setNeedsRepaint(true);
	}

	private void calcMinMaxXY() {
		minX = Double.POSITIVE_INFINITY;
		minY = Double.POSITIVE_INFINITY;
		maxX = Double.NEGATIVE_INFINITY;
		maxY = Double.NEGATIVE_INFINITY;
		if (maps != null) {
			for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
				MapData mapData = (MapData) ((Map.Entry) iter.next()).getValue();
				Rectangle2D bounds = mapData.getBounds();
				if (bounds.getMinX() < minX) {
					minX = bounds.getMinX();
				}
				if (bounds.getMinY() < minY) {
					minY = bounds.getMinY();
				}
				if (maxX < bounds.getMaxX()) {
					maxX = bounds.getMaxX();
				}
				if (maxY < bounds.getMaxY()) {
					maxY = bounds.getMaxY();
				}
			}
		}
	}

	/**
	 * ѥͥ뤬褵˸ƤӽФޤ
	 * @param g о
	 */
	public void paint(Graphics g) {
		long startTime = System.currentTimeMillis();
		if (!isIdle || !needsRepaint) {
			if (image != null) {
				g.setColor(Color.WHITE);
				g.fillRect(0, 0, getWidth(), getHeight());
				g.drawImage(image, (int) mouseMotionWidth, (int) mouseMotionHeight, this);
			}
			return;
		}
		setNeedsRepaint(false);
		image = createImage(getWidth(), getHeight());
		Graphics2D g2 = (Graphics2D) image.getGraphics();
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		g2.setColor(Color.WHITE);
		g2.fillRect(0, 0, getWidth(), getHeight());
		AffineTransform transform = new AffineTransform();
		transform.translate(-offsetX, -offsetY);
		transform.scale(zoom, zoom);
		g2.setTransform(transform);
		double x = offsetX / zoom;
		double y = offsetY / zoom;
		double w = getWidth() / zoom;
		double h = getHeight() / zoom;
		Font tatemonoFont = new Font("MS UI Gothic", Font.PLAIN, 12);
		Font zyoutiFont = new Font("MS UI Gothic", Font.PLAIN, 15);
		Font mizuFont = new Font("ͣ ī", Font.PLAIN, 14);
		Color waterColor = new Color(200, 210, 250);
		Color zyotiColor = new Color(220, 220, 220);
		Color tatemonoColor = new Color(180, 180, 180);
		Color tyomeAttributeColor = new Color(0, 0, 160);
		Area usedArea = new Area(); // °ˤäƻѺѤߤΰ
		Collection usedPoints = new HashSet(); // ѺѤߤΥݥꥴ濴
		int loopCount = 4;
		try {
			if (maps != null) {
				g2.setStroke(new BasicStroke(1.0f));
				for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
					MapData mapData = (MapData) ((Map.Entry) iter.next()).getValue();
					if (mapData.getBounds().intersects(x, y, w, h)) {
						// 褹
						if (mapData.hasGyousei()) {
							g2.setColor(waterColor);
							g2.fill(mapData.getBounds());
							g2.draw(mapData.getBounds());
						}
						// ܤ褹
						if (mapData.hasTyome()) {
							for (Iterator iter2 = mapData.getTyome().values().iterator(); iter2.hasNext();) {
								Polygon polygon = (Polygon) iter2.next();
								if (polygon.getPath() != null) {
									if (polygon.getClassificationCode() == Polygon.CLASSIFICATION_TYOME) {
										if (polygon.getFillColor() != null) {
											g2.setColor(polygon.getFillColor());
										} else {
											g2.setColor(Color.WHITE);
										}
										if (polygon.getArea() == null) {
											g2.fill(polygon.getPath());
										} else {
											g2.fill(polygon.getArea());
										}
									}
								}
							}
						}
					}
				}
				for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
					MapData mapData = (MapData) ((Map.Entry) iter.next()).getValue();
					if (mapData.getBounds().intersects(x, y, w, h)) {
						// Ϥ褹
						if (mapData.hasZyouti()) {
							for (Iterator iter2 = mapData.getZyouti().entrySet().iterator(); iter2.hasNext();) {
								Polygon polygon = ((Polygon) ((Map.Entry) iter2.next()).getValue());
								if (polygon.getClassificationCode() == Polygon.CLASSIFICATION_RAILROAD) {
									g2.setColor(zyotiColor);
									g2.fill(polygon.getPath());
									g2.draw(polygon.getPath());
								} else if (polygon.getClassificationCode() == Polygon.CLASSIFICATION_PARK) {
									g2.setColor(new Color(200, 250, 160));
									g2.fill(polygon.getPath());
									g2.draw(polygon.getPath());
								} else if (polygon.getClassificationCode() == Polygon.CLASSIFICATION_SCHOOL) {
									g2.setColor(zyotiColor);
									g2.fill(polygon.getPath());
									g2.draw(polygon.getPath());
								} else if (polygon.getClassificationCode() == Polygon.CLASSIFICATION_TEMPLE) {
									g2.setColor(zyotiColor);
									g2.fill(polygon.getPath());
									g2.draw(polygon.getPath());
								} else if (polygon.getClassificationCode() == Polygon.CLASSIFICATION_GRAVEYARD) {
									g2.setColor(zyotiColor);
									g2.fill(polygon.getPath());
									g2.draw(polygon.getPath());
								} else if (polygon.getClassificationCode() == Polygon.CLASSIFICATION_OTHER) {
									g2.setColor(zyotiColor);
									g2.fill(polygon.getPath());
									g2.draw(polygon.getPath());
								}
							}
						}
						// ̤褹
						if (mapData.hasMizu()) {
							for (Iterator iter2 = mapData.getMizu().entrySet().iterator(); iter2.hasNext();) {
								g2.setColor(waterColor);
								Polygon polygon = (Polygon) ((Map.Entry) iter2.next()).getValue();
								if (polygon.getPath() != null) {
									g2.fill(polygon.getPath());
									g2.draw(polygon.getPath());
								}
							}
						}
						// ʪ褹
						if (mapData.hasTatemono()) {
							for (Iterator iter2 = mapData.getTatemono().entrySet().iterator(); iter2.hasNext();) {
								g2.setColor(tatemonoColor);
								Polygon polygon = (Polygon) ((Map.Entry) iter2.next()).getValue();
								if (polygon.getPath() != null) {
									g2.fill(polygon.getPath());
								}
							}
						}
					}
				}
				g2.setStroke(new BasicStroke(1.0f));
				for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
					MapData mapData = (MapData) ((Map.Entry) iter.next()).getValue();
					if (mapData.getBounds().intersects(x, y, w, h)) {
						// ϳ褹
						if (mapData.hasZyouti()) {
							for (Iterator iter2 = mapData.getOthers().entrySet().iterator(); iter2.hasNext();) {
								Arc arc = ((Arc) ((Map.Entry) iter2.next()).getValue());
								if (arc.getType() != Arc.TYPE_RAILWAY) {
									if (arc.getTag() == Arc.TAG_NORMAL) {
										g2.setColor(Color.GRAY);
										g2.draw(arc.getPath());
									}
								}
							}
						}
						// ̳褹
						if (mapData.hasMizuArc()) {
							for (Iterator iter2 = mapData.getMizuArc().entrySet().iterator(); iter2.hasNext();) {
								Arc arc = ((Arc) ((Map.Entry) iter2.next()).getValue());
								if (arc.getTag() == Arc.TAG_NORMAL) {
									if (arc.getType() == Arc.TYPE_MIZU_INSIDE) {
										g2.setColor(waterColor.darker());
										g2.draw(arc.getPath());
									}
								}
							}
						}
						// ʪ褹
						if (mapData.hasTatemonoArc()) {
							for (Iterator iter2 = mapData.getTatemonoArc().entrySet().iterator(); iter2.hasNext();) {
								Arc arc = ((Arc) ((Map.Entry) iter2.next()).getValue());
								if (arc.getTag() == Arc.TAG_NORMAL) {
									g2.setColor(tatemonoColor.darker());
									g2.draw(arc.getPath());
								}
							}
						}
					}
				}
				g2.setStroke(new BasicStroke(9.0f));
				g2.setColor(Color.GRAY);
				for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
					MapData mapData = (MapData) ((Map.Entry) iter.next()).getValue();
					if (mapData.getBounds().intersects(x, y, w, h)) {
						// ƻϩسԤ褹
						if (mapData.hasRoadArc()) {
							for (Iterator iter2 = mapData.getRoadArc().entrySet().iterator(); iter2.hasNext();) {
								Arc arc = ((Arc) ((Map.Entry) iter2.next()).getValue());
								g2.draw(arc.getPath());
							}
						}
					}
				}
				g2.setStroke(new BasicStroke(7.0f));
				g2.setColor(Color.WHITE);
				for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
					MapData mapData = (MapData) ((Map.Entry) iter.next()).getValue();
					if (mapData.getBounds().intersects(x, y, w, h)) {
						// ƻϩɤĤ֤褹
						if (mapData.hasRoadArc()) {
							for (Iterator iter2 = mapData.getRoadArc().entrySet().iterator(); iter2.hasNext();) {
								Arc arc = ((Arc) ((Map.Entry) iter2.next()).getValue());
								g2.draw(arc.getPath());
							}
						}
					}
				}
				for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
					MapData mapData = (MapData) ((Map.Entry) iter.next()).getValue();
					if (mapData.getBounds().intersects(x, y, w, h)) {
						// 褹
						if (mapData.hasGyousei()) {
							for (Iterator iter2 = mapData.getGyousei().keySet().iterator(); iter2.hasNext();) {
								Arc arc = ((Arc) mapData.getGyousei().get(iter2.next()));
								if (arc.getTag() == Arc.TAG_NORMAL) {
									if (arc.getType() == Arc.TYPE_GYOUSEI_PREFECTURE || arc.getType() == Arc.TYPE_GYOUSEI_CITY) {
										g2.setColor(Color.BLACK);
										g2.setStroke(new BasicStroke(4.0f));
									} else {
										g2.setColor(Color.BLACK);
										g2.setStroke(new BasicStroke(1.0f));
									}
									g2.draw(arc.getPath());
								}
							}
						}
					}
				}
				g2.setStroke(new BasicStroke(4.0f));
				for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
					MapData mapData = (MapData) ((Map.Entry) iter.next()).getValue();
					if (mapData.getBounds().intersects(x, y, w, h)) {
						// Ŵƻ褹
						if (mapData.hasZyouti()) {
							for (Iterator iter2 = mapData.getOthers().entrySet().iterator(); iter2.hasNext();) {
								Arc arc = ((Arc) ((Map.Entry) iter2.next()).getValue());
								if (arc.getType() == Arc.TYPE_RAILWAY) {
									g2.setColor(Color.BLACK);
									g2.draw(arc.getPath());
								}
							}
						}
					}
				}
				g2.setStroke(new BasicStroke(1.0f));
				g2.setColor(Color.BLACK);
				g2.setFont(new Font("default", Font.PLAIN, 300));
				for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
					MapData mapData = (MapData) ((Map.Entry) iter.next()).getValue();
					if (mapData.getBounds().intersects(x, y, w, h)) {
						// 󤬤ʤȤĹ褹
						if (!mapData.hasGyousei()) {
							g2.draw(mapData.getBounds());
							g2.drawString(mapData.getMapName(), (float) mapData.getBounds().getX(), (float) mapData.getBounds().getMaxY());
						}
					}
				}
				g2.setTransform(new AffineTransform()); // ɸѴ򤷤ʤ
				g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
				for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
					MapData mapData = (MapData) ((Map.Entry) iter.next()).getValue();
					// ʪΥ٥褹
					if (mapData.hasTatemono()) {
						g2.setColor(Color.BLACK);
						g2.setFont(tatemonoFont);
						FontMetrics metrics = this.getFontMetrics(tatemonoFont);
						int descent = metrics.getDescent();
						double size = 4;
						for (Iterator iter2 = mapData.getTatemono().values().iterator(); iter2.hasNext();) {
							Polygon polygon = (Polygon) iter2.next();
							if (polygon.getAttribute() != null) {
								if (getVisibleRectangle().contains(polygon.getAttributeX(), polygon.getAttributeY())) {
									g2.fill(new Ellipse2D.Double(polygon.getX() * zoom - offsetX - size / 2, polygon.getY() * zoom - offsetY - size / 2, size, size));
									g2.drawString(polygon.getAttribute(), (float) (polygon.getAttributeX() * zoom - offsetX), (float) (polygon.getAttributeY() * zoom - offsetY - descent));
								}
							}
						}
					}
					// ϤΥ٥褹
					if (mapData.hasZyouti()) {
						g2.setColor(Color.BLACK);
						g2.setFont(tatemonoFont);
						FontMetrics metrics = this.getFontMetrics(zyoutiFont);
						int descent = metrics.getDescent();
						double size = 4;
						for (Iterator iter2 = mapData.getZyouti().values().iterator(); iter2.hasNext();) {
							Polygon polygon = (Polygon) iter2.next();
							if (polygon.getAttribute() != null) {
								if (getVisibleRectangle().contains(polygon.getAttributeX(), polygon.getAttributeY())) {
									g2.drawString(polygon.getAttribute(), (float) (polygon.getAttributeX() * zoom - offsetX), (float) (polygon.getAttributeY() * zoom - offsetY - descent));
								}
							}
						}
					}
					// ̤Υ٥褹
					if (mapData.hasMizu()) {
						g2.setColor(Color.BLACK);
						g2.setFont(mizuFont);
						FontMetrics metrics = this.getFontMetrics(mizuFont);
						int descent = metrics.getDescent();
						double size = 4;
						for (Iterator iter2 = mapData.getMizu().values().iterator(); iter2.hasNext();) {
							Polygon polygon = (Polygon) iter2.next();
							if (polygon.getAttribute() != null) {
								if (getVisibleRectangle().contains(polygon.getAttributeX(), polygon.getAttributeY())) {
									g2.drawString(polygon.getAttribute(), (float) (polygon.getAttributeX() * zoom - offsetX), (float) (polygon.getAttributeY() * zoom - offsetY - descent));
								}
							}
						}
					}
					// ܤΥ٥褹 
					if (mapData.hasTyome()) {
						g2.setColor(tyomeAttributeColor);
						double size = 4;
						for (Iterator iter2 = mapData.getTyome().keySet().iterator(); iter2.hasNext();) {
							Polygon polygon = ((Polygon) mapData.getTyome().get(iter2.next()));
							if (polygon.getTyomeFont() != null) {
								g2.setFont(polygon.getTyomeFont());
								FontMetrics metrics = this.getFontMetrics(polygon.getTyomeFont());
								int descent = metrics.getDescent();
								if (polygon.getClassificationCode() == Polygon.CLASSIFICATION_TYOME) {
									if (polygon.getAttribute() != null) {
										if (getVisibleRectangle().contains(polygon.getAttributeX(), polygon.getAttributeY())) {
											g2.drawString(polygon.getAttribute(), (float) (polygon.getAttributeX() * zoom - offsetX), (float) (polygon.getAttributeY() * zoom - offsetY - descent));
										}
									}
								}
							}
						}
					}
				}
			}
		} catch (Exception e) {
			System.err.println("Failed to draw map.");
			e.printStackTrace(System.err);
		}
		g.drawImage(image, 0, 0, this);
		if (System.currentTimeMillis() - startTime > 200) {
			System.out.println("衧" + (System.currentTimeMillis() - startTime + " ms"));
		}
	}

	/**
	 * ºɸޤ
	 * @param location ۺɸ
	 * @return ºɸ
	 */
	Point2D toRealLocation(Point2D location) {
		return new Point2D.Double(location.getX() * zoom - offsetX, location.getY() * zoom - offsetY);
	}

	/**
	 * ۺɸޤ
	 * @param location ºɸ
	 * @return ۺɸ
	 */
	Point2D toVirtualLocation(Point2D location) {
		return new Point2D.Double((offsetX + location.getX()) / zoom, (offsetY + location.getY()) / zoom);
	}

	void zoom(double zoom) {
		this.zoom = zoom;
		isZoomChanged = true;
		setNeedsRepaint(true);
	}

	/**
	 * ưΨꤷޤ 
	 */
	void zoomAutomaticaly() {
		calcMinMaxXY();
		double zoomX = getWidth() / (maxX - minX);
		double zoomY = getHeight() / (maxY - minY);
		if (zoomY < zoomX) {
			zoom = zoomY;
		} else {
			zoom = zoomX;
		}
		isZoomChanged = true;
		setNeedsRepaint(true);
	}

	/**
	 * @param b
	 */
	void setIdle(boolean b) {
		isIdle = b;
	}

	/**
	 * @return
	 */
	boolean isIdle() {
		return isIdle;
	}

}
