import java.awt.*;
import java.awt.geom.*;
import java.util.*;

/*
 * : 2004/01/16
 */

/**
 * °褹ɸ׻륯饹Ǥ
 * @author Kumano Tatsuo
 */
class FixAttributeLocation {

	private boolean isChanged; // ľη׻°褹ɸѲɤ

	/**
	 * °褹ɸꤷޤ
	 * @param maps Ͽ
	 * @param panel ѥͥ
	 */
	void fixAttributeLocation(Map maps, MapPanel panel) throws Exception {
		isChanged = false;
		Font tatemonoFont = new Font("MS UI Gothic", Font.PLAIN, 12);
		Font zyoutiFont = new Font("MS UI Gothic", Font.PLAIN, 15);
		Font mizuFont = new Font("ͣ ī", Font.PLAIN, 14);
		Font tyomeFont = new Font("MS UI Gothic", Font.PLAIN, 18);
		Font tyomeFont2 = new Font("MS UI Gothic", Font.PLAIN, 16);
		Font tyomeFont3 = new Font("MS UI Gothic", Font.PLAIN, 14);
		Area usedArea = new Area(); // °ˤäƻѺѤߤΰ
		Rectangle2D visibleRectangle = panel.getVisibleRectangle(); // ߲̤ɽƤϰϡʲۺɸ
		int loopCount = 4;
		double size = 4; // ʪɽľ
		double zoom = panel.getZoom();
		double x = panel.getVisibleRectangle().getX();
		double y = panel.getVisibleRectangle().getY();
		double w = panel.getVisibleRectangle().getWidth();
		double h = panel.getVisibleRectangle().getHeight();
		// ʪ°ɽ֤׻
		for (Iterator iter = maps.values().iterator(); iter.hasNext();) {
			MapData mapData = (MapData) iter.next();
			if (mapData.hasTatemono()) {
				if (panel.isVisible(mapData.getBounds())) {
					FontMetrics metrics = panel.getFontMetrics(tatemonoFont);
					double attributeHeight = metrics.getHeight() / zoom;
					for (Iterator iter2 = mapData.getTatemono().values().iterator(); iter2.hasNext();) {
						Polygon polygon = (Polygon) iter2.next();
						fixTatemonoAttributeLocation(polygon, usedArea, visibleRectangle, zoom, attributeHeight, metrics, size);
					}
				}
			}
		}
		// Ϥ°ɽ֤׻
		for (Iterator iter = maps.values().iterator(); iter.hasNext();) {
			MapData mapData = (MapData) iter.next();
			if (mapData.hasZyouti()) {
				if (panel.isVisible(mapData.getBounds())) {
					FontMetrics metrics = panel.getFontMetrics(zyoutiFont);
					double attributeHeight = metrics.getHeight() / zoom;
					for (Iterator iter2 = mapData.getZyouti().values().iterator(); iter2.hasNext();) {
						Polygon polygon = (Polygon) iter2.next();
						fixPolygonAttributeLocation(polygon, usedArea, visibleRectangle, zoom, attributeHeight, metrics, size);
					}
				}
			}
		}
		// ̤°ɽ֤׻
		for (Iterator iter = maps.values().iterator(); iter.hasNext();) {
			MapData mapData = (MapData) iter.next();
			if (mapData.hasMizu()) {
				if (panel.isVisible(mapData.getBounds())) {
					FontMetrics metrics = panel.getFontMetrics(mizuFont);
					double attributeHeight = metrics.getHeight() / zoom;
					for (Iterator iter2 = mapData.getMizu().values().iterator(); iter2.hasNext();) {
						Polygon polygon = (Polygon) iter2.next();
						fixPolygonAttributeLocation(polygon, usedArea, visibleRectangle, zoom, attributeHeight, metrics, size);
					}
				}
			}
		}
		// ܤ°ɽ֤׻
		for (Iterator iter = maps.values().iterator(); iter.hasNext();) {
			MapData mapData = (MapData) iter.next();
			if (mapData.hasTyome()) {
				if (panel.isVisible(mapData.getBounds())) {
					for (Iterator iter2 = mapData.getTyome().values().iterator(); iter2.hasNext();) {
						Polygon polygon = (Polygon) iter2.next();
						polygon.setAttributeLocation(0, 0);
						fixTyomeAttributeLocation(polygon, tyomeFont, visibleRectangle, usedArea, panel, true);
						fixTyomeAttributeLocation(polygon, tyomeFont2, visibleRectangle, usedArea, panel, true);
						fixTyomeAttributeLocation(polygon, tyomeFont3, visibleRectangle, usedArea, panel, false);
					}
				}
			}
		}
		isChanged = true;
	}

	private void fixTyomeAttributeLocation(Polygon polygon, Font font, Rectangle2D visibleRectangle, Area usedArea, MapPanel panel, boolean contains) {
		if (polygon.getAttribute() != null) {
			double zoom = panel.getZoom();
			FontMetrics metrics = panel.getFontMetrics(font);
			double attributeHeight = metrics.getHeight() / zoom;
			double size = 4;
			double attributeWidth = metrics.stringWidth(polygon.getAttribute()) / zoom;
			if (contains) {
				if (polygon.getArea() == null) {
					if (polygon.getPath().getBounds().getWidth() < attributeWidth) {
						return;
					}
				} else {
					if (polygon.getArea().getBounds().getWidth() < attributeWidth) {
						return;
					}
				}
			}
			Rectangle2D pointRectangle = new Rectangle2D.Double(-polygon.getX() - size / zoom, -polygon.getY() - size / zoom, size * 2 / zoom, size * 2 / zoom);
			Rectangle2D attributeRectangle;
			// ݥꥴ濴
			attributeRectangle = new Rectangle2D.Double(polygon.getX() - attributeWidth / 2, polygon.getY() - attributeHeight / 2, attributeWidth, attributeHeight);
			if (isTyomePutable(polygon, pointRectangle, attributeRectangle, usedArea, visibleRectangle, contains)) {
				polygon.setAttributeLocation(attributeRectangle.getX(), attributeRectangle.getMaxY());
				polygon.setTyomeFont(font);
				usedArea.add(new Area(pointRectangle));
				usedArea.add(new Area(attributeRectangle));
			}
			int div = 4; // ʬ
			double dx; // ư
			double dy; // ư⤵
			if (polygon.getArea() == null) {
				dx = (polygon.getPath().getBounds().getWidth() - attributeWidth) / 2 / div;
				dy = (polygon.getPath().getBounds().getHeight() - attributeHeight) / 2 / div;
			} else {
				dx = (polygon.getArea().getBounds().getWidth() - attributeWidth) / 2 / div;
				dy = (polygon.getArea().getBounds().getHeight() - attributeHeight) / 2 / div;
			}
			for (int i = 1; i <= div; i++) {
				// ݥꥴ濴
				attributeRectangle = new Rectangle2D.Double(polygon.getX() - attributeWidth / 2, polygon.getY() - attributeHeight / 2 - dy * i, attributeWidth, attributeHeight);
				if (isTyomePutable(polygon, pointRectangle, attributeRectangle, usedArea, visibleRectangle, contains)) {
					polygon.setAttributeLocation(attributeRectangle.getX(), attributeRectangle.getMaxY());
					polygon.setTyomeFont(font);
					usedArea.add(new Area(pointRectangle));
					usedArea.add(new Area(attributeRectangle));
				}
				// ݥꥴ濴鲼
				attributeRectangle = new Rectangle2D.Double(polygon.getX() - attributeWidth / 2, polygon.getY() - attributeHeight / 2 + dy * i, attributeWidth, attributeHeight);
				if (isTyomePutable(polygon, pointRectangle, attributeRectangle, usedArea, visibleRectangle, contains)) {
					polygon.setAttributeLocation(attributeRectangle.getX(), attributeRectangle.getMaxY());
					polygon.setTyomeFont(font);
					usedArea.add(new Area(pointRectangle));
					usedArea.add(new Area(attributeRectangle));
				}
				// ݥꥴ濴鱦
				attributeRectangle = new Rectangle2D.Double(polygon.getX() - attributeWidth / 2 + dx * i, polygon.getY() - attributeHeight / 2, attributeWidth, attributeHeight);
				if (isTyomePutable(polygon, pointRectangle, attributeRectangle, usedArea, visibleRectangle, contains)) {
					polygon.setAttributeLocation(attributeRectangle.getX(), attributeRectangle.getMaxY());
					polygon.setTyomeFont(font);
					usedArea.add(new Area(pointRectangle));
					usedArea.add(new Area(attributeRectangle));
				}
				// ݥꥴ濴麸
				attributeRectangle = new Rectangle2D.Double(polygon.getX() - attributeWidth / 2 - dx * i, polygon.getY() - attributeHeight / 2, attributeWidth, attributeHeight);
				if (isTyomePutable(polygon, pointRectangle, attributeRectangle, usedArea, visibleRectangle, contains)) {
					polygon.setAttributeLocation(attributeRectangle.getX(), attributeRectangle.getMaxY());
					polygon.setTyomeFont(font);
					usedArea.add(new Area(pointRectangle));
					usedArea.add(new Area(attributeRectangle));
				}
			}
		}
	}

	private void fixTatemonoAttributeLocation(Polygon polygon, Area usedArea, Rectangle2D visibleRectangle, double zoom, double attributeHeight, FontMetrics metrics, double size) {
		if (polygon.getAttribute() != null) {
			polygon.setAttributeLocation(0, 0);
			double attributeWidth = metrics.stringWidth(polygon.getAttribute()) / zoom;
			Rectangle2D pointRectangle = new Rectangle2D.Double(polygon.getX() - size / zoom, polygon.getY() - size / zoom, size * 2 / zoom, size * 2 / zoom);
			Rectangle2D attributeRectangle;
			// α
			attributeRectangle = new Rectangle2D.Double(polygon.getX() + size / zoom, polygon.getY() - attributeHeight / 2, attributeWidth, attributeHeight);
			if (isPutable(pointRectangle, attributeRectangle, usedArea, visibleRectangle)) {
				polygon.setAttributeLocation(attributeRectangle.getX(), attributeRectangle.getMaxY());
				usedArea.add(new Area(pointRectangle));
				usedArea.add(new Area(attributeRectangle));
			}
			// α
			attributeRectangle = new Rectangle2D.Double(polygon.getX() + size / 2 / zoom, polygon.getY() - attributeHeight, attributeWidth, attributeHeight);
			if (isPutable(pointRectangle, attributeRectangle, usedArea, visibleRectangle)) {
				polygon.setAttributeLocation(attributeRectangle.getX(), attributeRectangle.getMaxY());
				usedArea.add(new Area(pointRectangle));
				usedArea.add(new Area(attributeRectangle));
			}
			// α
			attributeRectangle = new Rectangle2D.Double(polygon.getX() + size / 2 / zoom, polygon.getY(), attributeWidth, attributeHeight);
			if (isPutable(pointRectangle, attributeRectangle, usedArea, visibleRectangle)) {
				polygon.setAttributeLocation(attributeRectangle.getX(), attributeRectangle.getMaxY());
				usedArea.add(new Area(pointRectangle));
				usedArea.add(new Area(attributeRectangle));
			}
			// κ
			attributeRectangle = new Rectangle2D.Double(polygon.getX() - attributeWidth - size / zoom, polygon.getY() - attributeHeight / 2, attributeWidth, attributeHeight);
			if (isPutable(pointRectangle, attributeRectangle, usedArea, visibleRectangle)) {
				polygon.setAttributeLocation(attributeRectangle.getX(), attributeRectangle.getMaxY());
				usedArea.add(new Area(pointRectangle));
				usedArea.add(new Area(attributeRectangle));
			}
			// κ
			attributeRectangle = new Rectangle2D.Double(polygon.getX() - attributeWidth - size / 2 / zoom, polygon.getY() - attributeHeight, attributeWidth, attributeHeight);
			if (isPutable(pointRectangle, attributeRectangle, usedArea, visibleRectangle)) {
				polygon.setAttributeLocation(attributeRectangle.getX(), attributeRectangle.getMaxY());
				usedArea.add(new Area(pointRectangle));
				usedArea.add(new Area(attributeRectangle));
			}
			// κ
			attributeRectangle = new Rectangle2D.Double(polygon.getX() - attributeWidth - size / 2 / zoom, polygon.getY(), attributeWidth, attributeHeight);
			if (isPutable(pointRectangle, attributeRectangle, usedArea, visibleRectangle)) {
				polygon.setAttributeLocation(attributeRectangle.getX(), attributeRectangle.getMaxY());
				usedArea.add(new Area(pointRectangle));
				usedArea.add(new Area(attributeRectangle));
			}
		}
	}

	private void fixPolygonAttributeLocation(Polygon polygon, Area usedArea, Rectangle2D visibleRectangle, double zoom, double attributeHeight, FontMetrics metrics, double size) {
		if (polygon.getAttribute() != null) {
			polygon.setAttributeLocation(0, 0);
			double attributeWidth = metrics.stringWidth(polygon.getAttribute()) / zoom;
			Rectangle2D pointRectangle = new Rectangle2D.Double(polygon.getX() - size / zoom, polygon.getY() - size / zoom, size * 2 / zoom, size * 2 / zoom);
			Rectangle2D attributeRectangle;
			// ݥꥴ濴
			attributeRectangle = new Rectangle2D.Double(polygon.getX() - attributeWidth / 2, polygon.getY() - attributeHeight / 2, attributeWidth, attributeHeight);
			if (isPutable(pointRectangle, attributeRectangle, usedArea, visibleRectangle)) {
				polygon.setAttributeLocation(attributeRectangle.getX(), attributeRectangle.getMaxY());
				usedArea.add(new Area(pointRectangle));
				usedArea.add(new Area(attributeRectangle));
			}
		}
	}

	private boolean isPutable(Rectangle2D pointRectangle, Rectangle2D attributeRectangle, Area usedArea, Rectangle2D visibleRectangle) {
		return visibleRectangle.contains(pointRectangle) && visibleRectangle.contains(attributeRectangle) && !usedArea.intersects(pointRectangle) && !usedArea.intersects(attributeRectangle);
	}

	private boolean isTyomePutable(Polygon polygon, Rectangle2D pointRectangle, Rectangle2D attributeRectangle, Area usedArea, Rectangle2D visibleRectangle, boolean contains) {
		if (contains) {
			if (polygon.getArea() == null) {
				return polygon.getPath().contains(attributeRectangle)
					&& visibleRectangle.contains(attributeRectangle)
					&& !usedArea.intersects(pointRectangle)
					&& !usedArea.intersects(attributeRectangle);
			} else {
				return polygon.getArea().contains(attributeRectangle)
					&& visibleRectangle.contains(attributeRectangle)
					&& !usedArea.intersects(pointRectangle)
					&& !usedArea.intersects(attributeRectangle);
			}
		} else {
			if (polygon.getArea() == null) {
				return polygon.getPath().intersects(attributeRectangle)
					&& visibleRectangle.contains(attributeRectangle)
					&& !usedArea.intersects(pointRectangle)
					&& !usedArea.intersects(attributeRectangle);
			} else {
				return polygon.getArea().intersects(attributeRectangle)
					&& visibleRectangle.contains(attributeRectangle)
					&& !usedArea.intersects(pointRectangle)
					&& !usedArea.intersects(attributeRectangle);
			}
		}
	}

	/**
	 * ľη׻°褹ɸѲɤޤ
	 * @return ɸѲɤ
	 */
	boolean isChanged() {
		return isChanged;
	}

}
