import java.awt.geom.*;
import java.util.*;

/*
 * 2003/12/11
 */

/**
 * ̤ɽ饹Ǥ
 * @author Kumano Tatsuo
 */
class Arc {
	public static int TAG_DETACHED = 6;
	public static int TAG_EDGE_OF_MAP = 5;
	public static int TAG_EDGE_OF_WORLD = 15;
	public static int TAG_NORMAL = 0;
	public static int TAG_NUMBER = 16;
	public static int TAG_OVERPASS = 1;
	public static int TAG_TUNNEL = 2;
	public static int TAG_UNCERTAIN = 4;
	public static int TAG_UNDER_BRIDGE = 3;
	public static int TYPE_GYOUSEI_CHOME = 4;
	public static int TYPE_GYOUSEI_CITY = 2;
	public static int TYPE_GYOUSEI_PREFECTURE = 1;
	public static int TYPE_GYOUSEI_VILLAGE = 3;
	public static int TYPE_MIZU_INSIDE = 13;
	public static int TYPE_MIZU_SEASHORE = 14;
	public static int TYPE_NUMBER = 15;
	public static int TYPE_RAILWAY = 5;
	public static int TYPE_ROAD = 6;
	public static int TYPE_UNKNOWN = 0;
	public static int TYPE_ZYOTI_GRAVEYARD = 11;
	public static int TYPE_ZYOTI_OTHER = 12;
	public static int TYPE_ZYOTI_PARK = 8;
	public static int TYPE_ZYOTI_RAILROAD = 7;
	public static int TYPE_ZYOTI_SCHOOL = 9;
	public static int TYPE_ZYOTI_TEMPLE = 10;

	public static void main(String[] args) {
	}

	private String arcName; // ֹ
	private String attribute; // °
	private GeneralPath path; // ѥ
	private int tag; // 勵
	private int type; // ޼ʬॳ

	/**
	 * ̤ޤ
	 * @param arcName ̤θֹ
	 * @param path ̤ѥ
	 * @param type ̤ο޼ʬॳ
	 * @param tag ̤勵
	 */
	public Arc(String arcName, GeneralPath path, int type, int tag) {
		this.arcName = arcName;
		this.path = path;
		this.type = type;
		this.tag = tag;
	}

	/**
	 * @return
	 */
	public String getArcName() {
		return arcName;
	}

	/**
	 * @return
	 */
	public GeneralPath getPath() {
		return path;
	}

	GeneralPath getReversalPath() {
		GeneralPath ret = new GeneralPath();
		Stack stack = new Stack();
		for (PathIterator iter = path.getPathIterator(new AffineTransform()); !iter.isDone(); iter.next()) {
			double[] coords = new double[6];
			iter.currentSegment(coords);
			double x = coords[0];
			double y = coords[1];
			stack.push(new Point2D.Double(x, y));
		}
		Point2D firstPoint = (Point2D) stack.pop();
		ret.moveTo((float) firstPoint.getX(), (float) firstPoint.getY());
		while (!stack.isEmpty()) {
			Point2D point = (Point2D) stack.pop();
			if (tag == Arc.TAG_DETACHED || tag == Arc.TAG_EDGE_OF_MAP || tag == Arc.TAG_EDGE_OF_WORLD) {
				ret.lineTo((float) point.getX(), (float) point.getY());
			} else {
				ret.lineTo((float) point.getX(), (float) point.getY());
			}
		}
		return ret;
	}
	/**
	 * @return
	 */
	public int getTag() {
		return tag;
	}

	/**
	 * @return
	 */
	public int getType() {
		return type;
	}

	public String toString() {
		return "[Arc " + arcName + "(" + attribute + ")]";
	}

}
