import java.awt.geom.*;
import java.util.*;

/*
 * : 2003/12/13
 */

/**
 * ϿޤХå饦ɤɤ߹ॹåɤǤ
 * @author Kumano Tatsuo
 */
class LoadMapThread extends Thread {

	public static void main(String[] args) {
	}

	private double keepCoefficient; // ̲ʬΥǡ¸Ƥ
	private Map maps;
	private MapPanel panel;
	private double preLoadCoefficient; // ̲ʬΥǡɤߤ뤫

	LoadMapThread(Map maps, MapPanel panel) {
		this.maps = maps;
		this.panel = panel;
		preLoadCoefficient = 0;
		keepCoefficient = 2;
	}

	public void run() {
		while (true) {
			try {
				double zoom = ((MapPanel) panel).getZoom();
				for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
					Map.Entry entry = (Map.Entry) iter.next();
					MapData mapData = ((MapData) entry.getValue());
					if (panel.isIdle()) {
						Rectangle2D visibleRectangle = ((MapPanel) panel).getVisibleArea();
						Rectangle2D preLoadRectangle =
							new Rectangle2D.Double(
								visibleRectangle.getX()
									- visibleRectangle.getWidth() * preLoadCoefficient,
								visibleRectangle.getY()
									- visibleRectangle.getHeight() * preLoadCoefficient,
								visibleRectangle.getWidth()
									+ visibleRectangle.getWidth() * preLoadCoefficient * 2,
								visibleRectangle.getHeight()
									+ visibleRectangle.getHeight() * preLoadCoefficient * 2);
						Rectangle2D keepRectangle =
							new Rectangle2D.Double(
								visibleRectangle.getX()
									- visibleRectangle.getWidth() * keepCoefficient,
								visibleRectangle.getY()
									- visibleRectangle.getHeight() * keepCoefficient,
								visibleRectangle.getWidth()
									+ visibleRectangle.getWidth() * keepCoefficient * 2,
								visibleRectangle.getHeight()
									+ visibleRectangle.getHeight() * keepCoefficient * 2);
						if(visibleRectangle.intersects(mapData.getBounds())){
							// ǡ
							boolean isChanged = false;
							if (zoom < 0.2) {
								if (mapData.hasGyousei()) {
									mapData.freeSi_tyo();
									mapData.freeTyome();
									mapData.freeGyousei();
									isChanged = true;
								}
								if (mapData.hasMizuArc()) {
									mapData.freeMizu();
									mapData.freeMizuArc();
									isChanged = true;
								}
								if (mapData.hasOthers()) {
									mapData.freeZyouti();
									mapData.freeOthers();
									isChanged = true;
								}
								if (mapData.hasTatemonoArc()) {
									mapData.freeTatemono();
									mapData.freeTatemonoArc();
									isChanged = true;
								}
							}
							if (zoom < 0.3) {
								if (mapData.hasRoadArc()) {
									mapData.freeRoadArc();
									isChanged = true;
								}
							}
							if (visibleRectangle.intersects(mapData.getBounds())
								&& isChanged) {
								panel.repaint();
							}
						}
						if (preLoadRectangle.intersects(mapData.getBounds())) {
							// ǡɤ߹
							if (zoom > 0.2) {
								boolean isChanged = false;
								if (!mapData.hasGyousei()) {
									mapData.loadGyousei();
									mapData.loadSi_tyo();
									mapData.loadTyome();
									isChanged = true;
								}
								if (!mapData.hasMizuArc()) {
									mapData.loadMizuArc();
									mapData.loadMizu();
									isChanged = true;
								}
								if (!mapData.hasOthers()) {
									mapData.loadOthers();
									mapData.loadZyouti();
									isChanged = true;
								}
								if (!mapData.hasTatemonoArc()) {
									mapData.loadTatemonoArc();
									mapData.loadTatemono();
									isChanged = true;
								}
								if (visibleRectangle.intersects(mapData.getBounds())
									&& isChanged) {
									panel.repaint();
								}
							}
							if (zoom > 0.3) {
								boolean isChanged = false;
								if (!mapData.hasRoadArc()) {
									mapData.loadRoadArc();
									isChanged = true;
								}
								if (visibleRectangle.intersects(mapData.getBounds())
									&& isChanged) {
									panel.repaint();
								}
							}
						} else if (!keepRectangle.intersects(mapData.getBounds())) {
							// ǡ
							if (mapData.hasGyousei()) {
								mapData.freeSi_tyo();
								mapData.freeTyome();
								mapData.freeGyousei();
							}
							if (mapData.hasMizuArc()) {
								mapData.freeMizu();
								mapData.freeMizuArc();
							}
							if (mapData.hasOthers()) {
								mapData.freeZyouti();
								mapData.freeOthers();
							}
							if (mapData.hasTatemonoArc()) {
								mapData.freeTatemono();
								mapData.freeTatemonoArc();
							}
							if (mapData.hasRoadArc()) {
								mapData.freeRoadArc();
							}
						}
					}
				}
				Thread.sleep(1000);
			} catch (Exception exception) {
				System.err.println("Failed to load map.");
				exception.printStackTrace(System.err);
			}
			((MapPanel) panel).setMapData(maps);
		}
	}

}
