import java.io.*;
import java.util.*;

/*
 * Main.java
 *
 * Created on 2003/11/13, 18:18
 */

/**
 *
 * @author  kumano
 */
public class Main {

	private static MapFrame frame;
	private static Map maps;

	/**
	 * @param args the command line arguments
	 */
	public static void main(String[] args) throws Exception {
		maps = new HashMap();

		frame = new MapFrame();
		frame.show();
		MapPanel panel = (MapPanel)frame.shapePanel;

		System.out.println("Loading map infomation...");
		String baseDir = "data";
		String files[] = new File(baseDir).list();
		for (int i = 0; i < files.length; i++) {
			String mapName = files[i].toLowerCase();
			maps.put(mapName, new MapData(baseDir, mapName));
		}
		System.out.println("Map information loading finished.");

		panel.setMapData(maps);
		panel.zoom(0.005);
		panel.moveToCenter();
		panel.repaint();
		
		Thread loadMapThread = new LoadMapThread(maps, panel);
		loadMapThread.start();
	}
}
