import java.awt.geom.*;
import java.io.*;
import java.util.*;

/*
 * : 2003/12/11
 */

/**
 * Ͽޥǡ򰷤饹Ǥ
 * @author Kumano Tatsuo
 */
class MapData {

	public static void main(String[] args) throws Exception {
		MapData mapData = new MapData("./data", "05OF833");
		System.out.println(mapData.getBounds());
		mapData.getGyousei();
		System.out.println(mapData);
	}

	private String baseDir;
	private Map eki;
	private Map gyousei; // String  -> Arc  Map
	private String mapName;
	private Map mizu;
	private Rectangle2D rectangle;
	private Map road;
	private Map sankaku;
	private Map si_tyo;
	private Map tatemono;
	private Map tetudou;
	private Map tyome;
	private Map zyouti;

	/**
	 * Ͽޤޤ
	 * @param baseDir ϿޥǡΤǥ쥯ȥ
	 * @param mapName Ͽޤ̾
	 */
	MapData(String baseDir, String mapName) throws Exception {
		setBaseDir(baseDir);
		setMapName(mapName);
		loadRectangle();
	}

	/**
	 * @return
	 */
	public String getBaseDir() {
		return baseDir;
	}

	/**
	 * @return
	 */
	public String getMapName() {
		return mapName;
	}

	/**
	 * @return
	 */
	public Rectangle2D getBounds() {
		return rectangle;
	}

	public String toString() {
		return "[MapData name=" + mapName + ", gyousei=" + gyousei + "]";
	}

	/**
	 * 峦θ̥եɤ߹ߤޤ
	 * @throws Exception
	 */
	public void loadMizu() throws Exception {
		mizu = new HashMap();
		BufferedReader in =
			new BufferedReader(
				new InputStreamReader(
					new FileInputStream(
						baseDir
							+ File.separator
							+ mapName.toUpperCase()
							+ File.separator
							+ "mizu"
							+ File.separator
							+ "mizu.arc")));
		loadArc(mizu, in);
	}

	/**
	 * θ̥եɤ߹ߤޤ
	 * @throws Exception
	 */
	public void loadGyousei() throws Exception {
		gyousei = new HashMap();
		BufferedReader in =
			new BufferedReader(
				new InputStreamReader(
					new FileInputStream(
						baseDir
							+ File.separator
							+ mapName.toUpperCase()
							+ File.separator
							+ "gyousei"
							+ File.separator
							+ "gyousei.arc")));
		loadArc(gyousei, in);
	}

	private void loadArc(Map arcs, BufferedReader in) throws IOException {
		String line;
		String arcName = null;
		int type = 0;
		int tag = 0;
		GeneralPath path = null;
		while ((line = in.readLine()) != null) {
			StringTokenizer tokenizer = new StringTokenizer(line, ",");
			if (tokenizer.countTokens() == 4) {
				// ̤ϤޤȤ
				if (path != null) {
					arcs.put(arcName, new Arc(arcName, path, type, tag));
				}
				String code = tokenizer.nextToken();
				if (code.equals("L1101")) {
					type = Arc.TYPE_GYOUSEI_PREFECTURE;
				} else if (code.equals("L1103")) {
					type = Arc.TYPE_GYOUSEI_CITY;
				} else if (code.equals("L1104")) {
					type = Arc.TYPE_GYOUSEI_VILLAGE;
				} else if (code.equals("L1106")) {
					type = Arc.TYPE_GYOUSEI_CHOME;
				} else if (code.equals("L5101")) {
					type = Arc.TYPE_MIZU_INSIDE;
				} else if (code.equals("L5106")) {
					type = Arc.TYPE_MIZU_SEASHORE;
				} else {
					type = Arc.TYPE_UNKNOWN;
				}
				tag = Integer.parseInt(tokenizer.nextToken());
				arcName = tokenizer.nextToken();
				path = null;
			} else if (tokenizer.countTokens() == 2) {
				// ̤ɸΤȤ
				float x = Float.parseFloat(tokenizer.nextToken());
				float y = Float.parseFloat(tokenizer.nextToken());
				if (path != null) {
					if (tag == Arc.TAG_DETACHED || tag == Arc.TAG_EDGE_OF_MAP || tag == Arc.TAG_EDGE_OF_WORLD) {
						path.moveTo(x + (float) getBounds().getX(), y + (float) getBounds().getY());
					} else {
						path.lineTo(x + (float) getBounds().getX(), y + (float) getBounds().getY());
					}
				} else {
					path = new GeneralPath();
					path.moveTo(x + (float) getBounds().getX(), y + (float) getBounds().getY());
				}
			}
		}
		if (path != null) {
			arcs.put(arcName, new Arc(arcName, path, type, tag));
		}
	}

	/**
	 * Ͽޤΰե뤫ɤ߹ߤޤ
	 */
	private void loadRectangle() throws Exception {
		BufferedReader in =
			new BufferedReader(
				new InputStreamReader(
					new FileInputStream(
						baseDir
							+ File.separator
							+ mapName.toUpperCase()
							+ File.separator
							+ mapName.toLowerCase()
							+ ".txt"),
					"SJIS"));
		String line;
		while ((line = in.readLine()) != null) {
			StringTokenizer tokenizer = new StringTokenizer(line, ",");
			if (tokenizer.countTokens() == 10) {
				String dummy = tokenizer.nextToken();
				double x1 = Double.parseDouble(tokenizer.nextToken());
				double y1 = Double.parseDouble(tokenizer.nextToken());
				double x2 = Double.parseDouble(tokenizer.nextToken());
				double y2 = Double.parseDouble(tokenizer.nextToken());
				setRectangle(new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1));
				break;
			}
		}
		in.close();
	}

	/**
	 * @param string
	 */
	public void setBaseDir(String string) {
		baseDir = string;
	}

	/**
	 * @param string
	 */
	public void setMapName(String string) {
		mapName = string;
	}

	/**
	 * @param rectangle2D
	 */
	private void setRectangle(Rectangle2D rectangle2D) {
		rectangle = rectangle2D;
	}

	public void freeGyousei() {
		gyousei = null;
	}

	public void freeMizu() {
		mizu = null;
	}

	/**
	 * @return
	 */
	public Map getGyousei() throws Exception {
		if (gyousei == null) {
			loadGyousei();
		}
		return gyousei;
	}
	
	public boolean hasGyousei() {
		return gyousei != null;
	}
	
	public boolean hasMizu(){
		return mizu != null;
	}
	
	/**
	 * @return
	 */
	public Map getMizu() throws Exception {
		if (mizu == null) {
			loadMizu();
		}
		return mizu;
	}

}
