import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.util.*;
/*
 * : 2003/10/30
 */
/**
 * ϿΥǥǤ
 * @author Kumano Tatsuo
 */
public class LabelingDemo {
	static MapFrame frame;
	static LoadMap loadMap;
	/**
	 * ƥѤΥ᥽åɤǤ
	 * @param arg ޥɥ饤
	 */
	public static void main(String[] args) {
		// ǡɤ߹
		loadMap = new LoadMap();
		String baseDir = "data";
		String files[] = loadMap.getDirList(baseDir);
		for (int i = 0; i < files.length; i++) {
			System.out.println("loading " + files[i] + " ...");
			loadMap.loadArc(baseDir + files[i] + "/gyousei/gyousei.arc");
			loadMap.loadPolygon(baseDir + files[i] + "/gyousei/tyome.pgn", 0, null, null, null, 0);
			loadMap.loadAttribute(baseDir + files[i] + "/gyousei/tyome.atr");
		}
		for (int i = 0; i < files.length; i++) {
			loadMap.loadArc(baseDir + files[i] + "/tatemono/tatemono.arc");
			loadMap.loadPolygon(
				baseDir + files[i] + "/tatemono/tatemono.pgn",
				1,
				Color.GRAY,
				null,
				Color.BLACK,
				10);
			loadMap.loadAttribute(baseDir + files[i] + "/tatemono/tatemono.atr");
		}
		loadMap.joinPolygons();
		loadMap.arrangeLabels();
		// ɤ߹ǡɽ
		frame = new MapFrame();
		frame.show();
		ShapePanel panel = (ShapePanel)frame.shapePanel;
		panel.addMapListener(new MapListener() {
			public void mapMoved(MapEvent e) {
				ShapePanel panel = (ShapePanel)frame.shapePanel;
				double zoom = panel.getZoom();
				Font font = new Font("Sans", Font.PLAIN, (int) (12 / zoom));
				FontMetrics metrics = frame.getFontMetrics(font);
			}
			public void mapZoomChanged(MapEvent e) {
				ShapePanel panel = (ShapePanel)frame.shapePanel;
				double zoom = panel.getZoom();
				Font font = new Font("Sans", Font.PLAIN, (int) (12 / zoom));
				Map polygons = loadMap.getPolygons();
				Set keys = polygons.keySet();
				Iterator iterator = keys.iterator();
				while (iterator.hasNext()) {
					Object key = iterator.next();
					DrawablePolygon polygon = (DrawablePolygon)polygons.get(key);
					polygon.setFont(font);
				}
				frame.repaint();
			}
		});
		frame.button1.setText("(I)");
		frame.button2.setText("ʣ(D)");
		frame.button1.setMnemonic('I');
		frame.button2.setMnemonic('D');
		frame.button1.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				// ٥֤᤹
				ShapePanel panel = (ShapePanel)frame.shapePanel;
				double zoom = panel.getZoom();
				long startTime = System.currentTimeMillis();
				Font font = new Font("Sans", Font.PLAIN, (int) (12 / zoom));
				for (Iterator iterator = loadMap.getPolygons().entrySet().iterator(); iterator.hasNext();) {
					DrawablePolygon polygon = (DrawablePolygon) ((Map.Entry)iterator.next()).getValue();
					if (panel.isVisible((Shape)polygon)) {
						polygon.setFont(font);
					}
				}
				frame.shapePanel.repaint();
				frame.outText.setText(
					frame.outText.getText()
						+ "֡\n"
						+ (System.currentTimeMillis() - startTime)
						+ " ms μ¹Ի\n");
			}
		});
		frame.button2.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				// ŤʤäƤ٥
				ShapePanel panel = (ShapePanel)frame.shapePanel;
				double zoom = panel.getZoom();
				long startTime = System.currentTimeMillis();
				int visibleLabelCount = 0;
				int invisibleLabelCount = 0;
				Font font = new Font("Sans", Font.PLAIN, (int) (12 / zoom));
				FontMetrics metrics = frame.shapePanel.getFontMetrics(font);
				Set fixedPolygons = new HashSet();
				for (Iterator iterator = loadMap.getPolygons().entrySet().iterator(); iterator.hasNext();) {
					Map.Entry entry = (Map.Entry)iterator.next();
					DrawablePolygon polygon = (DrawablePolygon)entry.getValue();
					double x = polygon.getLabelLocation().getX(); // ɽ x ɸ
					double y = polygon.getLabelLocation().getY(); // ɽ y ɸ
					double w = metrics.stringWidth(polygon.getLabel()); // ٥
					double h = metrics.getAscent(); // ٥ι⤵
					Rectangle2D label = new Rectangle2D.Double(x, y, w, h);
					if (panel.isVisible((Shape)polygon) || panel.isVisible(label)) {
						boolean isConflicting = false;
						for (Iterator iterator2 = fixedPolygons.iterator(); iterator2.hasNext();) {
							DrawablePolygon polygon2 =
								(DrawablePolygon)loadMap.getPolygons().get(iterator2.next());
							double x2 = polygon2.getLabelLocation().getX(); // ɽ x ɸ
							double y2 = polygon2.getLabelLocation().getY(); // ɽ y ɸ
							int w2 = metrics.stringWidth(polygon2.getLabel()); // ٥
							Rectangle2D label2 = new Rectangle2D.Double(x2, y2, w2, h);
							if (label.intersects(label2)) {
								isConflicting = true;
								break;
							}
						}
						if (!isConflicting) {
							polygon.setFont(font); // ٥ɽ
							polygon.setLabelLocation(new Point2D.Double(x, y)); // ٥κɸꤹ
							fixedPolygons.add(entry.getKey());
							visibleLabelCount++;
						} else {
							polygon.setFont(null); // ٥ɽʤ
							invisibleLabelCount++;
						}
					}
				}
				frame.shapePanel.repaint();
				frame.outText.setText(
					frame.outText.getText()
						+ "ʣ\n"
						+ (System.currentTimeMillis() - startTime)
						+ " ms μ¹Ի\n"
						+ ((double)visibleLabelCount / (visibleLabelCount + invisibleLabelCount))
						+ " Ψ\n");
			}
		});
		frame.button3.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				// button3 줿
				frame.outText.setText(frame.outText.getText() + "button3 줿\n");
			}
		});
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e1) {
			e1.printStackTrace();
		}
		panel.setData(loadMap.getData());
		panel.repaint();
	}
}
