import java.awt.Color;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;

/**
 * ǽǤ
 * @author kumano
 */
class DrawableArrow extends Line2D.Double implements Drawable {

	public static void main(String[] args) {
	}

	private double alpha;
	private double arrowLength; // Ĺ
	private double arrowWidth; // Ⱦʬ
	private Color borderColor;
	private double circleRadius; // ߤȾ
	private Color fillColor;
	private Font font;
	private String label;
	private Point2D labelLocation;
	private GeneralPath path;
	private int zOrder;
	
	DrawableArrow(){
		this(2, 4, 2);
	}
	
	DrawableArrow(double circleRadius, double arrowLength, double arrowWidth){
		super();
		this.circleRadius = circleRadius;
		this.arrowLength = arrowLength;
		this.arrowWidth = arrowWidth;
		setAlpha(1);
		setBorderColor(Color.BLACK);
		setFillColor(Color.BLACK);
		setFont(new Font("Default", 10, Font.PLAIN));
	}

	/* ( Javadoc)
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(Object o) {
		if (zOrder == ((Drawable) o).getZOrder()) {
			return hashCode() - o.hashCode();
		} else {
			return zOrder - ((Drawable) o).getZOrder();
		}
	}
	/* ( Javadoc)
	 * @see Drawable#getAlpha()
	 */
	public double getAlpha() {
		return alpha;
	}

	/* ( Javadoc)
	 * @see Drawable#getBorderColor()
	 */
	public Color getBorderColor() {
		return borderColor;
	}

	/* ( Javadoc)
	 * @see Drawable#getFillColor()
	 */
	public Color getFillColor() {
		return fillColor;
	}

	/* ( Javadoc)
	 * @see Drawable#getFont()
	 */
	public Font getFont() {
		return font;
	}

	/* ( Javadoc)
	 * @see Drawable#getLabel()
	 */
	public String getLabel() {
		return label;
	}

	/* ( Javadoc)
	 * @see Drawable#getLabelLocation()
	 */
	public Point2D getLabelLocation() {
		return labelLocation;
	}

	public PathIterator getPathIterator(AffineTransform at) {
		return path.getPathIterator(at);
	}

	public PathIterator getPathIterator(AffineTransform at, double flatness) {
		return path.getPathIterator(at, flatness);
	}

	/* ( Javadoc)
	 * @see Drawable#getZOrder()
	 */
	public int getZOrder() {
		return zOrder;
	}

	/* ( Javadoc)
	 * @see Drawable#setAlpha(double)
	 */
	public void setAlpha(double alpha) {
		this.alpha = alpha;
	}

	/* ( Javadoc)
	 * @see Drawable#setBorderColor(java.awt.Color)
	 */
	public void setBorderColor(Color color) {
		borderColor = color;
	}

	/* ( Javadoc)
	 * @see Drawable#setFillColor(java.awt.Color)
	 */
	public void setFillColor(Color color) {
		fillColor = color;
	}

	/* ( Javadoc)
	 * @see Drawable#setFont(java.awt.Font)
	 */
	public void setFont(Font font) {
		this.font = font;
	}

	/* ( Javadoc)
	 * @see Drawable#setLabel(java.lang.String)
	 */
	public void setLabel(String label) {
		this.label = label;
	}

	/* ( Javadoc)
	 * @see Drawable#setLabelLocation(double, double)
	 */
	public void setLabelLocation(double x, double y) {
		setLabelLocation(new Point2D.Double(x, y));
	}

	/* ( Javadoc)
	 * @see Drawable#setLabelLocation(java.awt.geom.Point2D)
	 */
	public void setLabelLocation(Point2D location) {
		labelLocation = location;
	}

	/* ( Javadoc)
	 * @see java.awt.geom.Line2D#setLine(double, double, double, double)
	 */
	public void setLine(double x1, double y1, double x2, double y2) {
		super.setLine(x1, y1, x2, y2);
		double r = circleRadius;
		double l = arrowLength;
		double w = arrowWidth;
		double dx = x2 - x1;
		double dy = y2 - y1;
		double d = Math.sqrt(dx * dx + dy * dy);
		double rx1 = (r + 0.5) * dx / d;
		double ry1 = (r + 0.5) * dy / d;
		double rx2 = (r + 2) * dx / d;
		double ry2 = (r + 2) * dy / d;
		double lx = l * dx / d;
		double ly = l * dy / d;
		double wx = w * dy / d;
		double wy = -w * dx / d;
		path = new GeneralPath();
		// arrow bar
		path.moveTo((float) (x1 + rx1), (float) (y1 + ry1));
		path.lineTo((float) (x2 - rx2 - lx), (float) (y2 - ry2 - ly));
		// arrow head
		path.moveTo((float) (x2 - rx2), (float) (y2 - ry2));
		path.lineTo((float) (x2 - rx2 - lx - wx), (float) (y2 - ry2 - ly - wy));
		path.lineTo((float) (x2 - rx2 - lx + wx), (float) (y2 - ry2 - ly + wy));
		path.closePath();
	}

	/* ( Javadoc)
	 * @see Drawable#setZOrder(int)
	 */
	public void setZOrder(int zOrder) {
		this.zOrder = zOrder;
	}
}
