using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.Net.Sockets;
using XPTable;
using XPTable.Models;
using XPTable.Renderers;

//{AvP[VXPTablegp܂B
//http://www.codeproject.com/KB/list/XPTable.aspx
//Qƒǉ
//XPTable, System.Management


namespace xportip
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
            InitialXPTable();
        }
        private bool issearch = false;

        enum ports { Step1st = 43282, Step2nd = 30718, Auto = 0 };
        private bool IsSearching
        {
            set
            {
                if (value == true)
                {
                    // 
                    toolStripButton1.Enabled = false;
                    // Xe[^Xo[XV
                    toolStripStatusLabel1.Text = "...";
                    this.toolStripStatusLabel1.Image = global::xportip.Properties.Resources.search_48;
                    toolStripProgressBar1.Increment(-100);
                    toolStripProgressBar1.Visible = true;
                }
                else
                {
                    //fB
                    toolStripButton1.Enabled = true;
                    // Xe[^Xo[XV
                    toolStripProgressBar1.Visible = false;
                    toolStripStatusLabel1.Text = "fB[";
                    this.toolStripStatusLabel1.Image = global::xportip.Properties.Resources.accepted_48;
                    
                }
                issearch = value;
                Application.DoEvents();
            }

            get
            {
                return issearch;
            }
        }

        public void BroadcastData(byte[] sndData, int srcPort, IPAddress dstIP, int dstPort)
        {
            IPEndPoint remoteIP = new IPEndPoint(dstIP, dstPort);
            UdpClient u;

            if (srcPort != (int)ports.Auto)
            {
                u = new UdpClient(srcPort);
            }
            else
            {
                u = new UdpClient();
            }
            u.Send(sndData, sndData.Length, new IPEndPoint(dstIP, dstPort));

            u.Close();
        }
        public void BroadcastData(byte[] sndData,out IPAddress[] remoteIP, out String[] mac, out String[] ver, int srcPort, IPAddress dstIP, int dstPort)
        {
            byte[] rcvData = new byte[256];
            UdpClient u;
            ArrayList A_remoteIP = new ArrayList();
            ArrayList A_mac = new ArrayList();
            ArrayList A_ver = new ArrayList();
            //A_remoteIP.Clear();
            //A_mac.Clear();
            //A_ver.Clear();
            remoteIP = null;
            mac = null;
            ver = null;

            if (srcPort != (int)ports.Auto)
            {
                u = new UdpClient(srcPort);
            }
            else
            {
                u = new UdpClient();
            }
            u.Send(sndData, sndData.Length, new IPEndPoint(dstIP, dstPort));
            //M
            u.Client.ReceiveTimeout = 100;
            IPEndPoint remotePort;
            String temp_mac,temp_ver;
            do
            {
                remotePort = new IPEndPoint(dstIP, dstPort);
                try
                {
                    rcvData = u.Receive(ref remotePort);
                }
                catch (System.Net.Sockets.SocketException ex)
                {
                    if (ex.SocketErrorCode != System.Net.Sockets.SocketError.TimedOut)
                    {
                        MessageBox.Show(ex.Message, Application.ProductName);
                    }
                    u.Close();
                    return;
                }
                A_remoteIP.Add(remotePort.Address);
                AnalyzePacket(ref rcvData,out temp_mac,out temp_ver);
                A_mac.Add(temp_mac);
                A_ver.Add(temp_ver);
            } while (u.Client.Available > 0);

            u.Close();

            remoteIP = new IPAddress[A_remoteIP.Count];
            mac = new String[A_mac.Count];
            ver = new String[A_ver.Count];
            int Index = 0;
            foreach ( IPAddress ip in A_remoteIP)
            {
                remoteIP[Index] = ip;
                Index++;
            }
            Index = 0;
            foreach (String m in A_mac)
            {
                mac[Index] = m;
                Index++;
            }
            Index = 0;
            foreach (String v in A_ver)
            {
                ver[Index] = v;
                Index++;
            }

            return;
        }

        private void table_CellButtonClick(object sender, XPTable.Events.CellButtonEventArgs e)
        {
            GC.Collect();
            String ip = this.tableModel1.Rows[((XPTable.Models.Table)(sender)).LastMouseDownCell.Row].Cells[0].Text;
            System.Diagnostics.Process.Start("http://" + ip + "/");
        }

        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            searchXP();
        }

        private void searchXP()
        {
            GC.Collect();
            IsSearching = true;
            AvoteAllItem();
            IPinfo[] ipaddr = getipad.GetIP();
            IPAddress[] dstIP = new IPAddress[ipaddr.Length];

            int Index = 0;
            foreach (IPinfo ip in ipaddr)
            {
                string ipstr = ip.IPString;
                string substr = ip.SubnetString; ;
                string bcaddr = CalcLocalBroadcast(new IPAddress(ip.IP), new IPAddress(ip.Subnet)).ToString();
                //AddItem(ipstr, substr, bcaddr);
                dstIP[Index] = IPAddress.Parse(bcaddr);
                Index++;
            }

            foreach (IPAddress bc in dstIP)
            {
                IPAddress[] remoteIP;
                String[] mac;
                String[] ver;

                BroadcastData(new byte[] { 0x01, 0x01, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00 }, (int)ports.Step1st, bc, (int)ports.Step1st);
                toolStripProgressBar1.Increment(10 / dstIP.Length);
                System.Threading.Thread.Sleep(500); //500~b҂
                Application.DoEvents();
                toolStripProgressBar1.Increment(20 / dstIP.Length);
                BroadcastData(new byte[] { 0x01, 0x01, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00 }, (int)ports.Step1st, bc, (int)ports.Step1st);
                toolStripProgressBar1.Increment(10 / dstIP.Length);
                System.Threading.Thread.Sleep(500); //500~b҂
                Application.DoEvents();
                toolStripProgressBar1.Increment(20 / dstIP.Length);
                System.Threading.Thread.Sleep(500); //500~b҂
                Application.DoEvents();
                toolStripProgressBar1.Increment(20 / dstIP.Length);
                BroadcastData(new byte[] { 0x00, 0x01, 0x00, 0xf6 }, (int)ports.Auto, bc, (int)ports.Step2nd);
                toolStripProgressBar1.Increment(10 / dstIP.Length);
                System.Threading.Thread.Sleep(500); //500~b҂
                Application.DoEvents();
                toolStripProgressBar1.Increment(10 / dstIP.Length);
                BroadcastData(new byte[] { 0x00, 0x01, 0x00, 0xf6 }, out remoteIP, out mac, out ver, (int)ports.Auto, bc, (int)ports.Step2nd);
                if (remoteIP != null)
                {
                    for (int Indexip = 0; Indexip < remoteIP.Length; Indexip++)
                    {
                        AddItem(remoteIP[Indexip].ToString(), mac[Indexip], ver[Indexip]);
                    }
                    /*
                    toolStripProgressBar1.Increment(1 / dstIP.Length);
                    System.Threading.Thread.Sleep(500); //500~b҂
                    toolStripProgressBar1.Increment(16 / dstIP.Length);
                    BroadcastData(new byte[] { 0x00, 0x00, 0x00, 0xf4 }, (int)ports.Auto, bc, (int)ports.Step2nd);
                    toolStripProgressBar1.Increment(1 / dstIP.Length);
                    System.Threading.Thread.Sleep(500); //500~b҂
                    toolStripProgressBar1.Increment(16 / dstIP.Length);
                    BroadcastData(new byte[] { 0x00, 0x00, 0x00, 0xe2 }, (int)ports.Auto, bc, (int)ports.Step2nd);
                    toolStripProgressBar1.Increment(1 / dstIP.Length);
                    */
                }

            }
            IsSearching = false;
        }

        private void InitialXPTable()
        {
            columnModel1.Columns.Add(new TextColumn("IP address"));
            columnModel1.Columns.Add(new TextColumn("MAC address"));
            columnModel1.Columns.Add(new TextColumn("Version"));
            columnModel1.Columns.Add(new ButtonColumn("Button"));
            this.table1.CellButtonClicked += new XPTable.Events.CellButtonEventHandler(this.table_CellButtonClick);
            columnModel1.Columns[0].Width = 100;
            columnModel1.Columns[1].Width = 100;
            columnModel1.Columns[2].Width = 50;
            columnModel1.Columns[3].Width = 50;

            /* \eXg */
            //AddItem("192.168.0.11", "00:40:4A:84:16:2F", "1.0");
            //AddItem("192.168.0.12", "00:40:4A:56:C5:0D", "1.0");
            //AvoteAllItem();
        }

        private void AddItem(string ip, string mac, string ver)
        {
            tableModel1.Rows.Add(new Row());
            tableModel1.Rows[tableModel1.Rows.Count - 1].Cells.Add(new Cell(ip));
            tableModel1.Rows[tableModel1.Rows.Count - 1].Cells.Add(new Cell(mac));
            tableModel1.Rows[tableModel1.Rows.Count - 1].Cells.Add(new Cell(ver));
            tableModel1.Rows[tableModel1.Rows.Count - 1].Cells.Add(new Cell("J"));
        }

        private void AvoteAllItem()
        {
            tableModel1.Rows.Clear();
        }

        private IPAddress CalcLocalBroadcast(IPAddress ip, IPAddress subnet)
        {
            byte[] b_ip = ip.GetAddressBytes();
            byte[] b_sn = subnet.GetAddressBytes();
            byte[] b_lb = new byte[4];
            for ( int Index = 0; Index < b_ip.Length ; Index++)
            {
                b_lb[Index] = (byte)((b_ip[Index] & b_sn[Index]) | ~(b_sn[Index]));
            }
            return new IPAddress(b_lb);
        }

        private void AnalyzePacket(ref byte[] rcvData, out String mac, out String ver)
        {
            ver = rcvData[7].ToString() + "." + ((rcvData[6] >>4) & 0x0f).ToString();
            mac = rcvData[0x18].ToString("X2") + ":" +
                  rcvData[0x19].ToString("X2") + ":" +
                  rcvData[0x1A].ToString("X2") + ":" +
                  rcvData[0x1B].ToString("X2") + ":" +
                  rcvData[0x1C].ToString("X2") + ":" +
                  rcvData[0x1D].ToString("X2");
        }

        private void toolStripButton2_Click(object sender, EventArgs e)
        {
            Ver ver = new Ver();
            ver.ShowDialog(this);
            ver.Dispose();
        }

        private void Form1_PreviewKeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.F5)
            {
                searchXP();
            }
            else
            {
                e.Handled = true;
            }
        }

        private void Form1_Shown(object sender, EventArgs e)
        {
            //NɌn߂ꍇ͂̃RgOĂ
            //searchXP();
        }
    }
}