<?php
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

$xoopsOption['pagetype'] = 'user';

// Include files
include 'mainfile.php';
include_once XOOPS_ROOT_PATH . '/modules/system/constants.php';
include_once XOOPS_ROOT_PATH . '/include/notification_constants.php';
include_once XOOPS_ROOT_PATH . '/language/' . $xoopsConfig['language'] . '/timezone.php';
include_once XOOPS_ROOT_PATH . '/language/' . $xoopsConfig['language'] . '/notification.php';

// Initialize variables
$gperm_handler =& xoops_gethandler('groupperm');
$groups = ($xoopsUser) ? $xoopsUser->getGroups() : XOOPS_GROUP_ANONYMOUS;
$config_handler =& xoops_gethandler('config');
$xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);
$myts =& MyTextSanitizer::getInstance();
$uitems_tbl = $xoopsDB->prefix('uitems');
$yesno_options = array(1 => _YES, 0 => _NO);
$timezone_options = array("-12" => _TZ_GMTM12, "-11" => _TZ_GMTM11, "-10" => _TZ_GMTM10, "-9" => _TZ_GMTM9, "-8" => _TZ_GMTM8, "-7" => _TZ_GMTM7, "-6" => _TZ_GMTM6, "-5" => _TZ_GMTM5, "-4" => _TZ_GMTM4, "-3.5" => _TZ_GMTM35, "-3" => _TZ_GMTM3, "-2" => _TZ_GMTM2, "-1" => _TZ_GMTM1, "0" => _TZ_GMT0, "1" => _TZ_GMTP1, "2" => _TZ_GMTP2, "3" => _TZ_GMTP3, "3.5" => _TZ_GMTP35, "4" => _TZ_GMTP4, "4.5" => _TZ_GMTP45, "5" => _TZ_GMTP5, "5.5" => _TZ_GMTP55, "6" => _TZ_GMTP6, "7" => _TZ_GMTP7, "8" => _TZ_GMTP8, "9" => _TZ_GMTP9, "9.5" => _TZ_GMTP95, "10" => _TZ_GMTP10, "11" => _TZ_GMTP11, "12" => _TZ_GMTP12);
$uorder_options = array(0 => _OLDESTFIRST, 1 => _NEWESTFIRST);
$umode_options = array('nest' => _NESTED, 'flat' => _FLAT, 'thread' => _THREADED);
$notify_method_options = array(XOOPS_NOTIFICATION_METHOD_DISABLE => _NOT_METHOD_DISABLE, XOOPS_NOTIFICATION_METHOD_PM => _NOT_METHOD_PM, XOOPS_NOTIFICATION_METHOD_EMAIL => _NOT_METHOD_EMAIL);
$notify_mode_options = array(XOOPS_NOTIFICATION_MODE_SENDALWAYS => _NOT_MODE_SENDALWAYS, XOOPS_NOTIFICATION_MODE_SENDONCETHENDELETE => _NOT_MODE_SENDONCE, XOOPS_NOTIFICATION_MODE_SENDONCETHENWAIT => _NOT_MODE_SENDONCEPERLOGIN);
$titles = array('uname' => _US_USERNAME, 'email' => _US_EMAIL, 'url' => _US_WEBSITE, 'timezone_offset' => _US_TIMEZONE, 'pass' => _US_PASSWORD, 'user_mailok' => _US_MAILOK, 'name' => _US_REALNAME, 'user_icq' => _US_ICQ, 'user_from' => _US_LOCATION, 'user_sig' => _US_SIGNATURE, 'user_aim' => _US_AIM, 'user_yim' => _US_YIM, 'user_msnm' => _US_MSNM, 'uorder' => _US_CSORTORDER, 'notify_method' => _NOT_NOTIFYMETHOD, 'notify_mode' => _NOT_NOTIFYMODE, 'user_occ' => _US_OCCUPATION, 'bio' => _US_EXTRAINFO, 'user_intrest' => _US_INTEREST, 'umode' => _US_CDISPLAYMODE, 'user_avatar' => _US_AVATAR, 'user_regdate' => _US_MEMBERSINCE, 'posts' => _US_POSTS, 'rank' => _US_RANK, 'last_login' => _US_LASTLOGIN, 'pm' => _US_PM, 'usecookie' => _US_USECOOKIE);

// isadmin is true if user has 'edit users' admin rights
$isAdmin = $gperm_handler->checkRight('system_admin', XOOPS_SYSTEM_USER, $groups);

// Get uid for display
$uid = intval($_GET['uid']);
if ($uid <= 0) {
    redirect_header('index.php', 3, _US_SELECTNG);
    exit();
}

// Check and initialize permission
$userinfo_groups = $xoopsConfigUser['userinfo_groups'];
$perm = false;
if ($isAdmin) {
    $perm = true;
} else {
    if (is_object($xoopsUser)) {
        if ($uid == $xoopsUser->getVar('uid')) $perm = true;
        else {
            foreach ($groups as $gid) {
                if (in_array($gid, $userinfo_groups)) {
                    $perm = true;
                    break;
                }
            }
        }
    } else {
        if (in_array(XOOPS_GROUP_ANONYMOUS, $userinfo_groups)) $perm = true;
    }
}
if (!$perm) {
    redirect_header('index.php', 3, _NOPERM);
    exit();
}

// Initialize information
if (is_object($xoopsUser)) {
    if ($uid == $xoopsUser->getVar('uid')) {
        $xoopsOption['template_main'] = 'system_userinfo.html';
        include XOOPS_ROOT_PATH . '/header.php';
        $xoopsTpl->assign('user_ownpage', true);
        if ($xoopsConfigUser['self_delete'] == 1) {
            $xoopsTpl->assign('user_candelete', true);
        } else {
            $xoopsTpl->assign('user_candelete', false);
        }
        $thisUser =& $xoopsUser;
    } else {
        $member_handler =& xoops_gethandler('member');
        $thisUser =& $member_handler->getUser($uid);
        if (!is_object($thisUser) || !$thisUser->isActive()) {
            redirect_header("index.php", 3, _US_SELECTNG);
            exit();
        }
        $xoopsOption['template_main'] = 'system_userinfo.html';
        include XOOPS_ROOT_PATH . '/header.php';
        $xoopsTpl->assign('user_ownpage', false);
    }
} else {
    $member_handler =& xoops_gethandler('member');
    $thisUser =& $member_handler->getUser($uid);
    if (!is_object($thisUser) || !$thisUser->isActive()) {
        redirect_header("index.php", 3, _US_SELECTNG);
        exit();
    }
    $xoopsOption['template_main'] = 'system_userinfo.html';
    include(XOOPS_ROOT_PATH . '/header.php');
    $xoopsTpl->assign('user_ownpage', false);
}

if (is_object($xoopsUser) && $isAdmin) {
    $xoopsTpl->assign('user_uid', $thisUser->getVar('uid'));
}

// Assign user informations
$avatar = false;
$items = array();
$sql = "SELECT `itemname`, `title`, `itemtype`, `candel` FROM `$uitems_tbl` WHERE `infoorder` > 0 ORDER BY `infoorder` ASC";
$res = $xoopsDB->query($sql);
while (list($itemname, $title, $itemtype, $candel) = $xoopsDB->fetchRow($res)) {
    $item['itemname'] = $myts->htmlSpecialChars($itemname);
    $item['title'] = $candel ? $myts->htmlSpecialChars($title) : $titles[$itemname];
    if ($itemname == 'email') {
        if (is_object($xoopsUser)) {
            // All admins will be allowed to see emails, even those that are not allowed to edit users (I think it's ok like this)
            if ($isAdmin || ($xoopsUser->getVar('uid') == $thisUser->getVar('uid'))) {
                $item['value'] = $thisUser->getVar('email');
                $item['user_viewemail'] = $yesno_options[$thisUser->getVar('user_viewemail')];
            } else {
                if ($thisUser->getVar('user_viewemail') == 1) {
                    $item['value'] = $thisUser->getVar('email');
                } else {
                    $item['value'] = '&nbsp;';
                }
            }
        } elseif ($thisUser->getVar('user_viewemail') == 1) {
            $item['value'] = $thisUser->getVar('email');
        } else {
            $item['value'] = '&nbsp;';
        }
    } elseif ($itemname == 'url') {
        $item['value'] = '<a href="' . $thisUser->getVar('url') . '" target="_blank">' . $thisUser->getVar('url') . '</a>';
    } elseif ($itemname == 'user_avatar') {
        $avatar = true;
        $item['value'] = '<img src="' . XOOPS_URL . '/uploads/' . $thisUser->getVar('user_avatar') . '" alt="Avatar" />';
    } elseif ($itemname == 'user_regdate') {
        $item['value'] = formatTimestamp($thisUser->getVar('user_regdate'));
    } elseif ($itemname == 'user_sig') {
        $item['value'] = $myts->makeTareaData4Show($thisUser->getVar('user_sig', 'N'), 0, 1, 1);
        $item['attachsig'] = $yesno_options[$thisUser->getVar('attachsig')];
    } elseif ($itemname == 'rank') {
        $userrank = $thisUser->rank();
        if ($userrank['image']) {
            $item['value'] = '<img src="' . XOOPS_UPLOAD_URL . '/' . $userrank['image'] . '" alt="" /><br />' . $userrank['title'];
        } else {
            $item['value'] = $userrank['title'];
        }
    } elseif ($itemname == 'timezone_offset') {
        $item['value'] = $timezone_options[floatval($thisUser->getVar('timezone_offset'))];
    } elseif ($itemname == 'last_login') {
        $date = $thisUser->getVar('last_login');
        if (!empty($date)) {
            $item['value'] = formatTimestamp($date, 'm');
        } else {
            $item['value'] = '';
        }
    } elseif ($itemname == 'umode') {
        $item['value'] = $umode_options[$thisUser->getVar('umode')];
    } elseif ($itemname == 'uorder') {
        $item['value'] = $uorder_options[$thisUser->getVar('uorder')];
    } elseif ($itemname == 'notify_method') {
        $item['value'] = $notify_method_options[$thisUser->getVar('notify_method')];
    } elseif ($itemname == 'notify_mode') {
        $item['value'] = $notify_mode_options[$thisUser->getVar('notify_mode')];
    } elseif ($itemname == 'bio') {
        $item['value'] = $myts->makeTareaData4Show($thisUser->getVar('bio', 'N'), 0, 1, 1);
    } elseif ($itemname == 'user_mailok') {
        $item['value'] = $yesno_options[$thisUser->getVar('user_mailok')];
    } elseif ($itemname == 'pm') {
        if (is_object($xoopsUser)) {
            $item['value'] = "<a href=\"javascript:openWithSelfMain('" . XOOPS_URL . "/pmlite.php?send2=1&amp;to_userid=" . $thisUser->getVar('uid') . "', 'pmlite', 450, 380);\"><img src=\"" . XOOPS_URL . "/images/icons/pm.gif\" alt=\"" . sprintf(_SENDPMTO, $thisUser->getVar('uname')) . "\" /></a>";
        } else {
            $item['value'] = '';
        }
    } elseif ($candel) {
        if ($itemtype == 'text' || $itemtype == 'select' || $itemtype == 'radio') {
            $item['value'] = $thisUser->getVar($itemname);
        } elseif ($itemtype == 'textarea') {
            $item['value'] = $myts->makeTareaData4Show($thisUser->getVar($itemname, 'N'), 0, 0, 0);
        } elseif ($itemtype == 'yesno') {
            $item['value'] = $yesno_options[$thisUser->getVar($itemname)];
        } elseif ($itemtype == 'check') {
            $item['value'] = xoopsConvLineStr($thisUser->getVar($itemname));
        }
    } else {
        $item['value'] = $thisUser->getVar($itemname);
    }
    $items[] = $item;
    unset($item);
}
$xoopsTpl->assign('avatar', $avatar);
$xoopsTpl->assign('items', $items);
$xoopsTpl->assign('isAdmin', $isAdmin);

// Set posted history informations
$module_handler =& xoops_gethandler('module');
$criteria = new CriteriaCompo(new Criteria('hassearch', 1));
$criteria->add(new Criteria('isactive', 1));
$mids = array_keys($module_handler->getList($criteria));
foreach ($mids as $mid) {
    // Hack by marcan : only return results of modules for which user has access permission
    if ($gperm_handler->checkRight('module_read', $mid, $groups)) {
        $module =& $module_handler->get($mid);
        $results =& $module->search('', '', 5, 0, $thisUser->getVar('uid'));
        $count = count($results);
        if (is_array($results) && $count > 0) {
            for ($i = 0; $i < $count; $i++) {
                if (isset($results[$i]['image']) && $results[$i]['image'] != '') {
                    $results[$i]['image'] = 'modules/' . $module->getVar('dirname') . '/' . $results[$i]['image'];
                } else {
                    $results[$i]['image'] = 'images/icons/posticon2.gif';
                }
                $results[$i]['link'] = 'modules/' . $module->getVar('dirname') . '/' . $results[$i]['link'];
                $results[$i]['title'] = $myts->makeTboxData4Show($results[$i]['title']);
                $results[$i]['time'] = $results[$i]['time'] ? formatTimestamp($results[$i]['time']) : '';
            }
            if ($count == 5) {
                $showall_link = '<a href="search.php?action=showallbyuser&amp;mid=' . $mid . '&amp;uid=' . $thisUser->getVar('uid') . '">' . _US_SHOWALL . '</a>';
            } else {
                $showall_link = '';
            }
            $xoopsTpl->append('modules', array('name' => $module->getVar('name'), 'results' => $results, 'showall_link' => $showall_link));
        }
        unset($module);
    }
}

include XOOPS_ROOT_PATH . '/footer.php';

?>