<?php
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

$xoopsOption['pagetype'] = 'user';

// Include files
include 'mainfile.php';
include_once XOOPS_ROOT_PATH . '/class/xoopslists.php';
include_once XOOPS_ROOT_PATH . '/class/xoopsformloader.php';
include_once XOOPS_ROOT_PATH . '/include/notification_constants.php';
include_once XOOPS_ROOT_PATH . '/language/' . $xoopsConfig['language'] . '/timezone.php';
include_once XOOPS_ROOT_PATH . '/language/' . $xoopsConfig['language'] . '/notification.php';

// Initialize variables
$config_handler =& xoops_gethandler('config');
$xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);
$uitems_tbl = $xoopsDB->prefix('uitems');
$myts =& MyTextSanitizer::getInstance();
$yesno_options = array(1 => _YES, 0 => _NO);
$timezone_options = array("-12" => _TZ_GMTM12, "-11" => _TZ_GMTM11, "-10" => _TZ_GMTM10, "-9" => _TZ_GMTM9, "-8" => _TZ_GMTM8, "-7" => _TZ_GMTM7, "-6" => _TZ_GMTM6, "-5" => _TZ_GMTM5, "-4" => _TZ_GMTM4, "-3.5" => _TZ_GMTM35, "-3" => _TZ_GMTM3, "-2" => _TZ_GMTM2, "-1" => _TZ_GMTM1, "0" => _TZ_GMT0, "1" => _TZ_GMTP1, "2" => _TZ_GMTP2, "3" => _TZ_GMTP3, "3.5" => _TZ_GMTP35, "4" => _TZ_GMTP4, "4.5" => _TZ_GMTP45, "5" => _TZ_GMTP5, "5.5" => _TZ_GMTP55, "6" => _TZ_GMTP6, "7" => _TZ_GMTP7, "8" => _TZ_GMTP8, "9" => _TZ_GMTP9, "9.5" => _TZ_GMTP95, "10" => _TZ_GMTP10, "11" => _TZ_GMTP11, "12" => _TZ_GMTP12);
$uorder_options = array(0 => _OLDESTFIRST, 1 => _NEWESTFIRST);
$umode_options = array('nest' => _NESTED, 'flat' => _FLAT, 'thread' => _THREADED);
$notify_method_options = array(XOOPS_NOTIFICATION_METHOD_DISABLE => _NOT_METHOD_DISABLE, XOOPS_NOTIFICATION_METHOD_PM => _NOT_METHOD_PM, XOOPS_NOTIFICATION_METHOD_EMAIL => _NOT_METHOD_EMAIL);
$notify_mode_options = array(XOOPS_NOTIFICATION_MODE_SENDALWAYS => _NOT_MODE_SENDALWAYS, XOOPS_NOTIFICATION_MODE_SENDONCETHENDELETE => _NOT_MODE_SENDONCE, XOOPS_NOTIFICATION_MODE_SENDONCETHENWAIT => _NOT_MODE_SENDONCEPERLOGIN);
$titles = array('uname' => _US_USERNAME, 'email' => _US_EMAIL, 'url' => _US_WEBSITE, 'timezone_offset' => _US_TIMEZONE, 'pass' => _US_PASSWORD, 'user_mailok' => _US_MAILOK, 'name' => _US_REALNAME, 'user_icq' => _US_ICQ, 'user_from' => _US_LOCATION, 'user_sig' => _US_SIGNATURE, 'user_aim' => _US_AIM, 'user_yim' => _US_YIM, 'user_msnm' => _US_MSNM, 'uorder' => _US_CSORTORDER, 'notify_method' => _NOT_NOTIFYMETHOD, 'notify_mode' => _NOT_NOTIFYMODE, 'user_occ' => _US_OCCUPATION, 'bio' => _US_EXTRAINFO, 'user_intrest' => _US_INTEREST, 'umode' => _US_CDISPLAYMODE, 'user_avatar' => _US_AVATAR, 'user_regdate' => _US_MEMBERSINCE, 'posts' => _US_POSTS, 'rank' => _US_RANK, 'last_login' => _US_LASTLOGIN, 'pm' => _US_PM, 'usecookie' => _US_USECOOKIE, 'disclaimer' => _US_DISCLAIMER, 'captcha' => _CAPTCHA);

// Check access setting
if (empty($xoopsConfigUser['allow_register'])) {
    redirect_header('index.php', 6, _US_NOREGISTER);
    exit();
}

// Initialize default values from setting values
$requests = array();
$sql = "SELECT `itemname`, `regdefault` FROM `$uitems_tbl` WHERE `regorder` >= 0 ORDER BY `regorder` ASC";
$res = $xoopsDB->query($sql);
while (list($itemname, $regdefault) = $xoopsDB->fetchRow($res)) {
    if ($itemname == 'timezone_offset') $requests[$itemname] = $xoopsConfig['default_TZ'];
    elseif ($itemname == 'umode') $requests[$itemname] = $xoopsConfig['com_mode'];
    elseif ($itemname == 'uorder') $requests[$itemname] = $xoopsConfig['com_order'];
    else $requests[$itemname] = $regdefault;
}
$requests['pass'] = '';
$requests['vpass'] = '';
$requests['user_viewemail'] = '';
$requests['attachsig'] = '';
if ($xoopsConfigUser['reg_dispdsclmr']) $requests['disclaimer'] = '';
if ($xoopsConfigUser['register_captcha']) $requests['captcha'] = '';

// Check inputed values
if (!empty($_POST['conf_register']) || !empty($_POST['do_register']) || !empty($_POST['mod_register'])) {
    // Initialize default values from posted values
    $sql = "SELECT `itemname` FROM `$uitems_tbl` WHERE `regorder` > 0";
    $res = $xoopsDB->query($sql);
    while (list($itemname) = $xoopsDB->fetchRow($res)) {
        if (!isset($_POST[$itemname])) {
            $requests[$itemname] = '';
        } else {
            $requests[$itemname] = xoopsStripSlashesRec($_POST[$itemname]);
        }

        if ($itemname == 'pass') {
            $requests['vpass'] = xoopsStripSlashesRec($_POST['vpass']);
        } elseif ($itemname == 'email') {
            $requests['user_viewemail'] = isset($_POST['user_viewemail']) ? intval($_POST['user_viewemail']) : 0;
        } elseif ($itemname == 'user_sig') {
            $requests['attachsig'] = isset($_POST['attachsig']) ? intval($_POST['attachsig']) : 0;
        }
    }
    if ($xoopsConfigUser['reg_dispdsclmr']) {
        $requests['disclaimer'] = isset($_POST['disclaimer']) ? intval($_POST['disclaimer']) : 0;
    }
    if ($xoopsConfigUser['register_captcha']) {
        $requests['captcha'] = isset($_POST['captcha']) ? xoopsStripSlashesRec($_POST['captcha']) : '';
    }

    if (empty($_POST['mod_register'])) {
        // Check before register (uname, email, password)
        $stop_reasons = xoopsUserCheck($requests['uname'], $requests['email'], $requests['pass'], $requests['vpass']);
        // Check disclaimer
        if ($xoopsConfigUser['reg_dispdsclmr'] && empty($requests['disclaimer'])) {
            $stop_reasons['disclaimer'] = _US_UNEEDAGREE;
        }
        // Check captcha image
        if (!empty($_POST['conf_register']) && $xoopsConfigUser['register_captcha']) {
            require_once XOOPS_ROOT_PATH . '/class/captcha/captcha_x.php';
            $captcha = new captcha_x();
            if (!$captcha->validate($requests['captcha'])) {
                $stop_reasons['captcha'] = _CAPTCHA_ERR;
            }
        }
        // Check required values
        $sql = "SELECT `itemname`, `title`, `candel` FROM `$uitems_tbl` WHERE `regorder` > 0 AND `required` > 0";
        $res = $xoopsDB->query($sql);
        while (list($itemname, $title, $candel) = $xoopsDB->fetchRow($res)) {
            if ($itemname == 'uname' || $itemname == 'email' || $itemname == 'pass') continue;
            if ($requests[$itemname] == '') {
                $title = $candel ? $myts->htmlSpecialChars($title) : $titles[$itemname];
                $stop_reasons[$itemname] = sprintf(_US_CANT_EMPTY_ERR, $title);
            }
        }
    }
}

// Registering user
if (!empty($_POST['do_register']) && empty($stop_reasons)) {
    if (!XoopsSingleTokenHandler::quickValidate('do_register')) {
        redirect_header('register.php', 5, _INVALID_TICKET_MSG);
        exit();
    }

    include XOOPS_ROOT_PATH . '/header.php';

    // Add user informations
    $member_handler =& xoops_gethandler('member');
    $newuser =& $member_handler->createUser();
    $newuser->setVar('uname', $requests['uname'], true);
    $newuser->setVar('email', $requests['email'], true);
    $newuser->setVar('url', formatURL($requests['url']), true);
    $newuser->setVar('timezone_offset', $requests['timezone_offset'], true);
    $newuser->setVar('pass', md5($requests['pass']), true);
    $newuser->setVar('user_mailok', $requests['user_mailok'], true);
    $newuser->setVar('name', $requests['name'], true);
    $newuser->setVar('user_icq', $requests['user_icq'], true);
    $newuser->setVar('user_from', $requests['user_from'], true);
    $newuser->setVar('user_sig', $requests['user_sig'], true);
    $newuser->setVar('user_aim', $requests['user_aim'], true);
    $newuser->setVar('user_yim', $requests['user_yim'], true);
    $newuser->setVar('user_msnm', $requests['user_msnm'], true);
    $newuser->setVar('umode', $requests['umode'], true);
    $newuser->setVar('uorder', $requests['uorder'], true);
    $newuser->setVar('notify_method', $requests['notify_method'], true);
    $newuser->setVar('notify_mode', $requests['notify_mode'], true);
    $newuser->setVar('user_occ', $requests['user_occ'], true);
    $newuser->setVar('bio', $requests['bio'], true);
    $newuser->setVar('user_intrest', $requests['user_intrest'], true);
    $newuser->setVar('user_viewemail', $requests['user_viewemail'], true);
    $newuser->setVar('attachsig', $requests['attachsig'], true);
    $newuser->setVar('user_avatar', 'blank.gif', true);
    $actkey = substr(md5(uniqid(mt_rand(), 1)), 0, 8);
    $newuser->setVar('actkey', $actkey, true);
    $newuser->setVar('user_regdate', time(), true);
    if ($xoopsConfigUser['activation_type'] == 1) {
        $newuser->setVar('level', 1, true);
    }

    // Add extra user informations
    $sql = "SELECT `itemname` FROM `$uitems_tbl` WHERE `regorder` >= 0 AND `candel` > 0";
    $res = $xoopsDB->query($sql);
    while (list($itemname) = $xoopsDB->fetchRow($res)) {
        $newuser->setVar($itemname, $requests[$itemname], true);
    }

    if (!$member_handler->insertUser($newuser)) {
        echo _US_REGISTERNG;
        include XOOPS_ROOT_PATH . '/footer.php';
        exit();
    }
    $newid = $newuser->getVar('uid');

    // Add groups
    $auto_belong_groups = array(XOOPS_GROUP_USERS); // default (2)
    foreach ($auto_belong_groups as $group) {
        $member_handler->addUserToGroup(intval($group), $newid);
    }

    // Display complete page
    $xoopsOption['template_main'] = 'system_register_success.html';
    $items = array();
    $sql = "SELECT `itemname`, `title`, `itemtype`, `options`, `candel` FROM `$uitems_tbl` WHERE `regorder` > 0 ORDER BY `regorder` ASC";
    $res = $xoopsDB->query($sql);
    while (list($itemname, $title, $itemtype, $options, $candel) = $xoopsDB->fetchRow($res)) {
        if ($itemname == 'pass') continue;
        $item['itemname'] = $myts->htmlSpecialChars($itemname);
        $item['title'] = $candel ? $myts->htmlSpecialChars($title) : $titles[$itemname];
        if ($itemname == 'email') {
            $item['value'] = $myts->htmlSpecialChars($requests['email']);
            $item['user_viewemail'] = $requests['user_viewemail'] == 1 ? _YES : _NO;
        } elseif ($itemname == 'url') {
            $item['value'] = '<a href="' . $myts->htmlSpecialChars($requests['url']) . '" target="_blank">' . $myts->htmlSpecialChars($requests['url']) . '</a>';
        } elseif ($itemname == 'user_sig') {
            $item['value'] = $myts->makeTareaData4Show($requests['user_sig'], 0, 1, 1);
            $item['attachsig'] = !empty($requests['attachsig']) ? _YES : _NO;
        } elseif ($itemname == 'timezone_offset') {
            $item['value'] = $timezone_options[$requests['timezone_offset']];
        } elseif ($itemname == 'umode') {
            $item['value'] = $umode_options[$requests['umode']];
        } elseif ($itemname == 'uorder') {
            $item['value'] = $uorder_options[$requests['uorder']];
        } elseif ($itemname == 'notify_method') {
            $item['value'] = $notify_method_options[$requests['notify_method']];
        } elseif ($itemname == 'notify_mode') {
            $item['value'] = $notify_mode_options[$requests['notify_mode']];
        } elseif ($itemname == 'bio') {
            $item['value'] = $myts->makeTareaData4Show($requests['bio'], 0, 1, 1);
        } elseif ($itemname == 'user_mailok') {
            $item['value'] = $yesno_options[$requests['user_mailok']];
        } elseif ($candel) {
            if ($itemtype == 'text' || $itemtype == 'select' || $itemtype == 'radio') {
                $item['value'] = $myts->htmlSpecialChars($requests[$itemname]);
            } elseif ($itemtype == 'textarea') {
                $item['value'] = $myts->makeTareaData4Show($requests[$itemname], 0, 0, 0);
            } elseif ($itemtype == 'yesno') {
                $item['value'] = $yesno_options[$requests[$itemname]];
            } elseif ($itemtype == 'check') {
                $item['value'] = xoopsConvLineStr($requests[$itemname]);
            }
        } elseif ($itemname == 'uname' || $itemname == 'name' || $itemname == 'user_icq' || $itemname == 'user_from' || $itemname == 'user_aim' || $itemname == 'user_yim' || $itemname == 'user_msnm' || $itemname == 'user_occ' || $itemname == 'user_intrest') {
            $item['value'] = $myts->htmlSpecialChars($requests[$itemname]);
        }
        $items[] = $item;
        unset($item);
    }
    if ($xoopsConfigUser['reg_dispdsclmr']) {
        $item['itemname'] = 'disclaimer';
        $item['title'] = $titles['disclaimer'];
        $item['value'] = _US_IAGREE_CONF;
        $items[] = $item;
    }
    $xoopsTpl->assign('items', $items);

    if ($xoopsConfigUser['activation_type'] == 1) {
        $xoopsTpl->assign('message', _US_ACTLOGIN);
    } else if ($xoopsConfigUser['activation_type'] == 0) {
        $xoopsMailer =& getMailer();
        $xoopsMailer->useMail();
        $xoopsMailer->setTemplate('register.tpl');
        $xoopsMailer->assign('SITENAME', $xoopsConfig['sitename']);
        $xoopsMailer->assign('ADMINMAIL', $xoopsConfig['adminmail']);
        $xoopsMailer->assign('SITEURL', XOOPS_URL . "/");
        foreach ($requests as $key => $val) {
            $xoopsMailer->assign('REQUEST_' . strtoupper($key), $val);
        }
        $xoopsMailer->setToUsers(new XoopsUser($newid));
        $xoopsMailer->setFromEmail($xoopsConfig['adminmail']);
        $xoopsMailer->setFromName($xoopsConfig['sitename']);
        $xoopsMailer->setSubject(sprintf(_US_USERKEYFOR, $requests['uname']));
        if (!$xoopsMailer->send()) {
            $xoopsTpl->assign('message', _US_YOURREGMAILNG);
        } else {
            $xoopsTpl->assign('message', _US_YOURREGISTERED);
        }
    } elseif ($xoopsConfigUser['activation_type'] == 2) {
        $xoopsMailer =& getMailer();
        $xoopsMailer->useMail();
        $xoopsMailer->setTemplate('adminactivate.tpl');
        $xoopsMailer->assign('USERNAME', $requests['uname']);
        $xoopsMailer->assign('USEREMAIL', $requests['email']);
        $xoopsMailer->assign('USERACTLINK', XOOPS_URL . '/user.php?op=actv&id=' . $newid . '&actkey=' . $actkey);
        $xoopsMailer->assign('SITENAME', $xoopsConfig['sitename']);
        $xoopsMailer->assign('ADMINMAIL', $xoopsConfig['adminmail']);
        $xoopsMailer->assign('SITEURL', XOOPS_URL . "/");
        foreach ($requests as $key => $val) {
            $xoopsMailer->assign('REQUEST_' . strtoupper($key), $val);
        }
        $member_handler =& xoops_gethandler('member');
        $xoopsMailer->setToGroups($member_handler->getGroup($xoopsConfigUser['activation_group']));
        $xoopsMailer->setFromEmail($xoopsConfig['adminmail']);
        $xoopsMailer->setFromName($xoopsConfig['sitename']);
        $xoopsMailer->setSubject(sprintf(_US_USERKEYFOR, $requests['uname']));
        if (!$xoopsMailer->send()) {
            $xoopsTpl->assign('message', _US_YOURREGMAILNG);
        } else {
            $xoopsTpl->assign('message', _US_YOURREGISTERED2);
        }
    }

    if ($xoopsConfigUser['new_user_notify'] == 1 && !empty($xoopsConfigUser['new_user_notify_group'])) {
        $xoopsMailer =& getMailer();
        $xoopsMailer->useMail();
        $member_handler =& xoops_gethandler('member');
        $xoopsMailer->setToGroups($member_handler->getGroup($xoopsConfigUser['new_user_notify_group']));
        $xoopsMailer->setFromEmail($xoopsConfig['adminmail']);
        $xoopsMailer->setFromName($xoopsConfig['sitename']);
        $xoopsMailer->setSubject(sprintf(_US_NEWUSERREGAT, $xoopsConfig['sitename']));
        $xoopsMailer->setBody(sprintf(_US_HASJUSTREG, $requests['uname']));
        $xoopsMailer->send();
    }
    include XOOPS_ROOT_PATH . '/footer.php';
    exit;
} elseif (!empty($_POST['conf_register']) && empty($stop_reasons)) {
    if (!XoopsSingleTokenHandler::quickValidate('conf_register')) {
        redirect_header('register.php', 5, _INVALID_TICKET_MSG);
        exit();
    }

    include XOOPS_ROOT_PATH . '/header.php';
    $xoopsOption['template_main'] = 'system_register_confirm.html';

    $hiddens = '';
    foreach ($requests as $reqkey => $reqval) {
        $reqval = xoopsConvBarStr($reqval);
        $hiddens .= '<input type="hidden" name="' . $myts->htmlSpecialChars($reqkey) . '" value="' . $myts->htmlSpecialChars($reqval) . '" />';
    }
    $xoopsTpl->assign('hiddens', $hiddens);

    $items = array();
    $sql = "SELECT `itemname`, `title`, `itemtype`, `options`, `candel` FROM `$uitems_tbl` WHERE `regorder` > 0 ORDER BY `regorder` ASC";
    $res = $xoopsDB->query($sql);
    while (list($itemname, $title, $itemtype, $options, $candel) = $xoopsDB->fetchRow($res)) {
        if ($itemname == 'pass') continue;
        $item['itemname'] = $myts->htmlSpecialChars($itemname);
        $item['title'] = $candel ? $myts->htmlSpecialChars($title) : $titles[$itemname];
        if ($itemname == 'email') {
            $item['value'] = htmlSpecialChars($requests['email']);
            $item['user_viewemail'] = $requests['user_viewemail'] == 1 ? _YES : _NO;
        } elseif ($itemname == 'url') {
            $item['value'] = '<a href="' . htmlSpecialChars($requests['url']) . '" target="_blank">' . htmlSpecialChars($requests['url']) . '</a>';
        } elseif ($itemname == 'user_sig') {
            $item['value'] = $myts->makeTareaData4Show($requests['user_sig'], 0, 1, 1);
            $item['attachsig'] = !empty($requests['attachsig']) ? _YES : _NO;
        } elseif ($itemname == 'timezone_offset') {
            $item['value'] = $timezone_options[$requests['timezone_offset']];
        } elseif ($itemname == 'umode') {
            $item['value'] = $umode_options[$requests['umode']];
        } elseif ($itemname == 'uorder') {
            $item['value'] = $uorder_options[$requests['uorder']];
        } elseif ($itemname == 'notify_method') {
            $item['value'] = $notify_method_options[$requests['notify_method']];
        } elseif ($itemname == 'notify_mode') {
            $item['value'] = $notify_mode_options[$requests['notify_mode']];
        } elseif ($itemname == 'bio') {
            $item['value'] = $myts->makeTareaData4Show($requests['bio'], 0, 1, 1);
        } elseif ($itemname == 'user_mailok') {
            $item['value'] = $yesno_options[$requests['user_mailok']];
        } elseif ($candel) {
            if ($itemtype == 'text' || $itemtype == 'select' || $itemtype == 'radio') {
                $item['value'] = $myts->htmlSpecialChars($requests[$itemname]);
            } elseif ($itemtype == 'textarea') {
                $item['value'] = $myts->makeTareaData4Show($requests[$itemname], 0, 0, 0);
            } elseif ($itemtype == 'yesno') {
                $item['value'] = $yesno_options[$requests[$itemname]];
            } elseif ($itemtype == 'check') {
                $item['value'] = xoopsConvLineStr($requests[$itemname]);
            }
        } elseif ($itemname == 'uname' || $itemname == 'name' || $itemname == 'user_icq' || $itemname == 'user_from' || $itemname == 'user_aim' || $itemname == 'user_yim' || $itemname == 'user_msnm' || $itemname == 'user_occ' || $itemname == 'user_intrest') {
            $item['value'] = $myts->htmlSpecialChars($requests[$itemname]);
        }
        $items[] = $item;
        unset($item);
    }
    if ($xoopsConfigUser['reg_dispdsclmr']) {
        $item['itemname'] = 'disclaimer';
        $item['title'] = $titles['disclaimer'];
        $item['value'] = _US_IAGREE_CONF;
        $items[] = $item;
    }
    $xoopsTpl->assign('items', $items);
    $token =& XoopsSingleTokenHandler::quickCreate('do_register');
    $xoopsTpl->assign('token', $token->getHtml());

    include XOOPS_ROOT_PATH . '/footer.php';
    exit;
}

// Display input page
include XOOPS_ROOT_PATH . '/header.php';
$xoopsOption['template_main'] = 'system_register.html';

$items = array();
$error_msgs = '';
$sql = "SELECT `itemname`, `title`, `itemtype`, `options`, `required`, `candel`, `regdefault` FROM `$uitems_tbl` WHERE `regorder` > 0 ORDER BY `regorder` ASC";
$res = $xoopsDB->query($sql);
while (list($itemname, $title, $itemtype, $options, $required, $candel, $regdefault) = $xoopsDB->fetchRow($res)) {
    $item['itemname'] = $myts->htmlSpecialChars($itemname);
    $item['required'] = $required;
    $item['title'] = $candel ? $myts->htmlSpecialChars($title) : $titles[$itemname];
    $item['itemtype'] = $myts->htmlSpecialChars($itemtype);
    $item['candel'] = $candel;
    if (isset($stop_reasons[$itemname])) {
        $item['error'] = $stop_reasons[$itemname];
        $error_msgs .= $stop_reasons[$itemname] . '<br />';
    }

    if ($itemname == 'uname' || $itemname == 'email' || $itemname == 'url' || $itemname == 'name' || $itemname == 'user_icq' || $itemname == 'user_from' || $itemname == 'user_aim' || $itemname == 'user_yim' || $itemname == 'user_msnm' || $itemname == 'user_intrest' || $itemname == 'user_occ') {
        $item['value'] = $myts->htmlSpecialChars($requests[$itemname]);
        if ($itemname == 'user_icq') {
            $item['size'] = 15;
            $item['maxlength'] = 15;
        } elseif ($itemname == 'user_aim') {
            $item['size'] = 18;
            $item['maxlength'] = 18;
        } elseif ($itemname == 'uname' || $itemname == 'user_yim') {
            $item['size'] = 25;
            $item['maxlength'] = 25;
        } elseif ($itemname == 'name') {
            $item['size'] = 30;
            $item['maxlength'] = 60;
        } elseif ($itemname == 'url' || $itemname == 'user_from' || $itemname == 'user_msnm' || $itemname == 'user_occ') {
            $item['size'] = 50;
            $item['maxlength'] = 100;
        } elseif ($itemname == 'user_intrest') {
            $item['size'] = 50;
            $item['maxlength'] = 150;
        }
        if ($itemname == 'email' && !empty($requests['user_viewemail'])) $item['user_viewemail'] = 1;
    } elseif ($itemname == 'pass') {
        $item['value'] = '';
        $items[] = $item;
        $item['itemname'] = 'vpass';
        $item['title'] = _US_VERIFYPASS;
        if (!empty($item['error'])) $item['error'] = true;
        $items[] = $item;
        unset($item);
        continue;
    } elseif ($itemname == 'user_sig') {
        $user_sig_form = new XoopsFormDhtmlTextArea('', $itemname, $myts->htmlSpecialChars($requests[$itemname]));
        $item['value'] = $user_sig_form->render();
        if (!empty($requests['attachsig'])) $item['attachsig'] = 1;
    } elseif ($itemname == 'bio') {
        $item['value'] = $myts->htmlSpecialChars($requests[$itemname]);
    } elseif ($itemname == 'timezone_offset') {
        $item['options'] = $timezone_options;
        $item['value'] = floatval($requests[$itemname]);
    } elseif ($itemname == 'umode') {
        $item['options'] = $umode_options;
        $item['value'] = $myts->htmlSpecialChars($requests[$itemname]);
    } elseif ($itemname == 'uorder') {
        $item['options'] = $uorder_options;
        $item['value'] = intval($requests[$itemname]);
    } elseif ($itemname == 'notify_method') {
        $item['options'] = $notify_method_options;
        $item['value'] = intval($requests[$itemname]);
    } elseif ($itemname == 'notify_mode') {
        $item['options'] = $notify_mode_options;
        $item['value'] = intval($requests[$itemname]);
    } elseif ($itemname == 'user_mailok') {
        $item['options'] = $yesno_options;
        $item['value'] = intval($requests[$itemname]);
    } elseif ($candel) {
        if ($itemtype == 'text' || $itemtype == 'textarea') {
            $item['value'] = $myts->htmlSpecialChars($requests[$itemname]);
        } elseif ($itemtype == 'select' || $itemtype == 'radio') {
            $item['options'] = xoopsConvAry($options);
            $item['value'] = isset($requests[$itemname]) ? $myts->htmlSpecialChars($requests[$itemname]) : '';
        } elseif ($itemtype == 'yesno') {
            $item['options'] = $yesno_options;
            $item['value'] = intval($requests[$itemname]);
        } elseif ($itemtype == 'check') {
            $item['options'] = xoopsConvAry($options);
            $item['value'] = xoopsConvAry($requests[$itemname]);
        }
    }
    $items[] = $item;
    unset($item);
}
if ($xoopsConfigUser['reg_dispdsclmr']) {
    $item['itemname'] = 'disclaimer';
    $item['title'] = $titles['disclaimer'];
    $item['required'] = 1;
    if (isset($stop_reasons['disclaimer'])) {
        $item['error'] = $stop_reasons['disclaimer'];
        $error_msgs .= $stop_reasons['disclaimer'] . '<br />';
    }
    $items[] = $item;
    unset($item);
}
if ($xoopsConfigUser['register_captcha']) {
    $item['itemname'] = 'captcha';
    $item['title'] = $titles['captcha'];
    $item['required'] = 1;
    if (isset($stop_reasons['captcha'])) {
        $item['error'] = $stop_reasons['captcha'];
        $error_msgs .= $stop_reasons['captcha'] . '<br />';
    }
    $items[] = $item;
    unset($item);
}

$xoopsTpl->assign('items', $items);
$xoopsTpl->assign('error_msgs', $error_msgs);
$xoopsTpl->assign('reg_disclaimer', $xoopsConfigUser['reg_disclaimer']);
$token =& XoopsSingleTokenHandler::quickCreate('conf_register');
$xoopsTpl->assign('token', $token->getHtml());

include XOOPS_ROOT_PATH . '/footer.php';
exit;

?>
