<?php
// $Id: userform.php,v 1.4 2005/08/03 12:40:00 onokazu Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
// Author: Kazumi Ono (AKA onokazu)                                          //
// URL: http://www.myweb.ne.jp/, http://www.xoops.org/, http://jp.xoops.org/ //
// Project: The XOOPS Project                                                //
// ------------------------------------------------------------------------- //

$myts =& MyTextSanitizer::getInstance();

$uid_label = new XoopsFormLabel(_AM_USERID, $uid_value);
$uname_text = new XoopsFormText(_AM_NICKNAME, "uname", 25, 25, $uname_value);
$name_text = new XoopsFormText(_AM_NAME, "name", 30, 60, $name_value);
$email_tray = new XoopsFormElementTray(_AM_EMAIL, "<br />");
$email_text = new XoopsFormText("", "email", 30, 60, $email_value);
$email_tray->addElement($email_text, true);
$email_cbox = new XoopsFormCheckBox("", "user_viewemail", $email_cbox_value);
$email_cbox->addOption(1, _AM_AOUTVTEAD);
$email_tray->addElement($email_cbox);
$url_text = new XoopsFormText(_AM_URL, "url", 30, 100, $url_value);
$timezone_select = new XoopsFormSelectTimezone(_US_TIMEZONE, "timezone_offset", $timezone_value);
$icq_text = new XoopsFormText(_AM_ICQ, "user_icq", 15, 15, $icq_value);
$aim_text = new XoopsFormText(_AM_AIM, "user_aim", 18, 18, $aim_value);
$yim_text = new XoopsFormText(_AM_YIM, "user_yim", 25, 25, $yim_value);
$msnm_text = new XoopsFormText(_AM_MSNM, "user_msnm", 30, 100, $msnm_value);
$location_text = new XoopsFormText(_AM_LOCATION, "user_from", 30, 100, $location_value);
$occupation_text = new XoopsFormText(_AM_OCCUPATION, "user_occ", 30, 100, $occ_value);
$interest_text = new XoopsFormText(_AM_INTEREST, "user_intrest", 30, 150, $interest_value);
$sig_tray = new XoopsFormElementTray(_AM_SIGNATURE, "<br />");
$sig_tarea = new XoopsFormTextArea("", "user_sig", $sig_value);
$sig_tray->addElement($sig_tarea);
$sig_cbox = new XoopsFormCheckBox("", "attachsig", $sig_cbox_value);
$sig_cbox->addOption(1, _US_SHOWSIG);
$sig_tray->addElement($sig_cbox);
$umode_select = new XoopsFormSelect(_US_CDISPLAYMODE, "umode", $umode_value);
$umode_select->addOptionArray(array("nest" => _NESTED, "flat" => _FLAT, "thread" => _THREADED));
$uorder_select = new XoopsFormSelect(_US_CSORTORDER, "uorder", $uorder_value);
$uorder_select->addOptionArray(array("0" => _OLDESTFIRST, "1" => _NEWESTFIRST));
// RMV-NOTIFY
include_once XOOPS_ROOT_PATH . '/language/' . $xoopsConfig['language'] . '/notification.php';
include_once XOOPS_ROOT_PATH . '/include/notification_constants.php';
$notify_method_select = new XoopsFormSelect(_NOT_NOTIFYMETHOD, 'notify_method', $notify_method_value);
$notify_method_select->addOptionArray(array(XOOPS_NOTIFICATION_METHOD_DISABLE => _NOT_METHOD_DISABLE, XOOPS_NOTIFICATION_METHOD_PM => _NOT_METHOD_PM, XOOPS_NOTIFICATION_METHOD_EMAIL => _NOT_METHOD_EMAIL));
$notify_mode_select = new XoopsFormSelect(_NOT_NOTIFYMODE, 'notify_mode', $notify_mode_value);
$notify_mode_select->addOptionArray(array(XOOPS_NOTIFICATION_MODE_SENDALWAYS => _NOT_MODE_SENDALWAYS, XOOPS_NOTIFICATION_MODE_SENDONCETHENDELETE => _NOT_MODE_SENDONCE, XOOPS_NOTIFICATION_MODE_SENDONCETHENWAIT => _NOT_MODE_SENDONCEPERLOGIN));
$bio_tarea = new XoopsFormTextArea(_US_EXTRAINFO, "bio", $bio_value);
$rank_select = new XoopsFormSelect(_AM_RANK, "rank", $rank_value);
$ranklist = XoopsLists::getUserRankList();
if (count($ranklist) > 0) {
    $rank_select->addOption(0, _AM_NSRA);
    $rank_select->addOption(0, "--------------");
    $rank_select->addOptionArray($ranklist);
} else {
    $rank_select->addOption(0, _AM_NSRID);
}
$pwd_text = new XoopsFormPassword(_AM_PASSWORD, "pass", 10, 32);
$pwd_text2 = new XoopsFormPassword(_AM_RETYPEPD, "pass2", 10, 32);
$mailok_radio = new XoopsFormRadioYN(_US_MAILOK, 'user_mailok', $mailok_value);

// Groups administration addition XOOPS 2.0.9: Mith
global $xoopsUser;
$gperm_handler =& xoops_gethandler('groupperm');
//If user has admin rights on groups
if ($gperm_handler->checkRight("system_admin", XOOPS_SYSTEM_GROUP, $xoopsUser->getGroups(), 1)) {
    //add group selection
    $group_select = new XoopsFormSelectGroup(_US_GROUPS, 'groups', false, $groups, 5, true);
} else {
    //add empty variable
    $group_select = new XoopsFormHidden('groups[]', XOOPS_GROUP_USERS);
}

$fct_hidden = new XoopsFormHidden("fct", "users");
$op_hidden = new XoopsFormHidden("op", $op_value);
$submit_button = new XoopsFormButton("", "submit", _SUBMIT, "submit");

$form = new XoopsThemeForm($form_title, "userinfo", "admin.php");
$form->addElement(new XoopsFormToken(XoopsMultiTokenHandler::quickCreate('users_' . $op_value)));

if ($op == 'mod_users') $where = " WHERE regorder > 0 ORDER BY itemid ASC";
elseif ($op == 'modifyUser') $where = " WHERE editorder > 0 ORDER BY itemid ASC";

$sql = "SELECT itemname, title, itemtype, candel, options FROM " . $xoopsDB->prefix('uitems') . " $where";
$res = $xoopsDB->query($sql);
while (list($itemname, $title, $itemtype, $candel, $options) = $xoopsDB->fetchRow($res)) {
    if ($candel) {
        unset($element);
        //text textarea yesno select radio check
        if ($itemtype == 'text') {
            $element = new XoopsFormText($myts->htmlSpecialChars($title), $itemname, 30, 255, $myts->htmlSpecialChars($item_defaults[$itemname]));
        } elseif ($itemtype == 'textarea') {
            $element = new XoopsFormTextArea($myts->htmlSpecialChars($title), $itemname, $myts->htmlSpecialChars($item_defaults[$itemname]));
        } elseif ($itemtype == 'yesno') {
            $element = new XoopsFormRadioYN($myts->htmlSpecialChars($title), $itemname, $myts->htmlSpecialChars($item_defaults[$itemname]));
        } elseif ($itemtype == 'select') {
            $element = new XoopsFormSelect($myts->htmlSpecialChars($title), $itemname, $myts->htmlSpecialChars($item_defaults[$itemname]));
            $element->addOptionArray(xoopsConvAry($options));
        } elseif ($itemtype == 'radio') {
            $element = new XoopsFormRadio($myts->htmlSpecialChars($title), $itemname, $myts->htmlSpecialChars($item_defaults[$itemname]));
            $element->addOptionArray(xoopsConvAry($options));
        } elseif ($itemtype == 'check') {
            $element = new XoopsFormCheckBox($myts->htmlSpecialChars($title), $itemname, xoopsConvAry($item_defaults[$itemname]));
            $element->addOptionArray(xoopsConvAry($options));
        }
        $form->addElement($element);
    } else {
        if ($itemname == 'uname') $form->addElement($uname_text, true);
        elseif ($itemname == 'name') $form->addElement($name_text);
        elseif ($itemname == 'email') $form->addElement($email_tray, true);
        elseif ($itemname == 'url') $form->addElement($url_text);
        elseif ($itemname == 'timezone_offset') $form->addElement($timezone_select);
        elseif ($itemname == 'user_icq') $form->addElement($icq_text);
        elseif ($itemname == 'user_aim') $form->addElement($aim_text);
        elseif ($itemname == 'user_yim') $form->addElement($yim_text);
        elseif ($itemname == 'user_msnm') $form->addElement($msnm_text);
        elseif ($itemname == 'user_from') $form->addElement($location_text);
        elseif ($itemname == 'user_occ') $form->addElement($occupation_text);
        elseif ($itemname == 'user_intrest') $form->addElement($interest_text);
        elseif ($itemname == 'user_sig') $form->addElement($sig_tray);
        elseif ($itemname == 'umode') $form->addElement($umode_select);
        elseif ($itemname == 'uorder') $form->addElement($uorder_select);
        elseif ($itemname == 'notify_method') $form->addElement($notify_method_select);
        elseif ($itemname == 'notify_mode') $form->addElement($notify_mode_select);
        elseif ($itemname == 'bio') $form->addElement($bio_tarea);
        elseif ($itemname == 'user_mailok') $form->addElement($mailok_radio);
        elseif ($itemname == 'pass') {
            // adding a new user requires password fields
            if (!$form_isedit) {
                $form->addElement($pwd_text, true);
                $form->addElement($pwd_text2, true);
            } else {
                $form->addElement($pwd_text);
                $form->addElement($pwd_text2);
            }
        }
    }
}
$form->addElement($rank_select);
$form->addElement($group_select);
$form->addElement($fct_hidden);
$form->addElement($op_hidden);
$form->addElement($submit_button);
if (!empty($uid_value)) {
    $uid_hidden = new XoopsFormHidden("uid", $uid_value);
    $form->addElement($uid_hidden);
}

$form->display();

?>
