<?php
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

if (!is_object($xoopsUser) || !is_object($xoopsModule) || !$xoopsUser->isAdmin($xoopsModule->mid())) {
    exit("Access Denied");
}

include_once XOOPS_ROOT_PATH . '/class/template.php';
include_once XOOPS_ROOT_PATH . '/class/xoopsformloader.php';
include_once XOOPS_ROOT_PATH . '/include/notification_constants.php';
include_once XOOPS_ROOT_PATH . '/language/' . $xoopsConfig['language'] . '/timezone.php';
include_once XOOPS_ROOT_PATH . '/language/' . $xoopsConfig['language'] . '/user.php';
include_once XOOPS_ROOT_PATH . '/language/' . $xoopsConfig['language'] . '/notification.php';

$myts =& MyTextSanitizer::getInstance();
$uitems_tbl = $xoopsDB->prefix('uitems');
$users_tbl = $xoopsDB->prefix('users');

$titles = array(
    'uname'           => _US_USERNAME,
    'email'           => _US_EMAIL,
    'url'             => _US_WEBSITE,
    'timezone_offset' => _US_TIMEZONE,
    'pass'            => _US_PASSWORD,
    'user_mailok'     => _US_MAILOK,
    'name'            => _US_REALNAME,
    'user_icq'        => _US_ICQ,
    'user_from'       => _US_LOCATION,
    'user_sig'        => _US_SIGNATURE,
    'user_aim'        => _US_AIM,
    'user_yim'        => _US_YIM,
    'user_msnm'       => _US_MSNM,
    'uorder'          => _US_CSORTORDER,
    'notify_method'   => _NOT_NOTIFYMETHOD,
    'notify_mode'     => _NOT_NOTIFYMODE,
    'user_occ'        => _US_OCCUPATION,
    'bio'             => _US_EXTRAINFO,
    'user_intrest'    => _US_INTEREST,
    'umode'           => _US_CDISPLAYMODE,
    'user_avatar'     => _US_AVATAR,
    'user_regdate'    => _US_MEMBERSINCE,
    'posts'           => _US_POSTS,
    'rank'            => _US_RANK,
    'last_login'      => _US_LASTLOGIN,
    'pm'              => _US_PM,
    'usecookie'       => _US_USECOOKIE
);

$datatypes = array(
    'text'     => _AM_DT_TEXT,
    'textarea' => _AM_DT_TEXTAREA,
    'yesno'    => _AM_DT_YESNO,
    'select'   => _AM_DT_SELECTBOX . _AM_DT_SELECTABLE,
    'radio'    => _AM_DT_RADIOBUTTON . _AM_DT_SELECTABLE,
    'check'    => _AM_DT_CHECKBOX . _AM_DT_MULTI_SELECTABLE
);

$datatypes_other = array(
    'text'     => _AM_DT_TEXT,
    'textarea' => _AM_DT_TEXTAREA,
    'yesno'    => _AM_DT_YESNO,
    'select'   => _AM_DT_SELECTBOX,
    'radio'    => _AM_DT_RADIOBUTTON,
    'check'    => _AM_DT_CHECKBOX,
    ''         => _AM_DT_OTHER
);

$table_datatypes = array(
    'text'     => 'VARCHAR(255)',
    'textarea' => 'TEXT',
    'yesno'    => 'SMALLINT(1)',
    'select'   => 'VARCHAR(255)',
    'radio'    => 'VARCHAR(255)',
    'check'    => 'VARCHAR(255)'
);

$yesno_options = array(
    1 => _YES,
    0 => _NO
);

$timezone_options = array("-12" => _TZ_GMTM12, "-11" => _TZ_GMTM11, "-10" => _TZ_GMTM10, "-9" => _TZ_GMTM9, "-8" => _TZ_GMTM8, "-7" => _TZ_GMTM7, "-6" => _TZ_GMTM6, "-5" => _TZ_GMTM5, "-4" => _TZ_GMTM4, "-3.5" => _TZ_GMTM35, "-3" => _TZ_GMTM3, "-2" => _TZ_GMTM2, "-1" => _TZ_GMTM1, "0" => _TZ_GMT0, "1" => _TZ_GMTP1, "2" => _TZ_GMTP2, "3" => _TZ_GMTP3, "3.5" => _TZ_GMTP35, "4" => _TZ_GMTP4, "4.5" => _TZ_GMTP45, "5" => _TZ_GMTP5, "5.5" => _TZ_GMTP55, "6" => _TZ_GMTP6, "7" => _TZ_GMTP7, "8" => _TZ_GMTP8, "9" => _TZ_GMTP9, "9.5" => _TZ_GMTP95, "10" => _TZ_GMTP10, "11" => _TZ_GMTP11, "12" => _TZ_GMTP12);

$uorder_options = array(
    0 => _OLDESTFIRST,
    1 => _NEWESTFIRST
);

$umode_options = array(
    'nest'   => _NESTED,
    'flat'   => _FLAT,
    'thread' => _THREADED
);

$notify_method_options = array(
    XOOPS_NOTIFICATION_METHOD_DISABLE => _NOT_METHOD_DISABLE,
    XOOPS_NOTIFICATION_METHOD_PM => _NOT_METHOD_PM,
    XOOPS_NOTIFICATION_METHOD_EMAIL => _NOT_METHOD_EMAIL
);

$notify_mode_options = array(
    XOOPS_NOTIFICATION_MODE_SENDALWAYS => _NOT_MODE_SENDALWAYS,
    XOOPS_NOTIFICATION_MODE_SENDONCETHENDELETE => _NOT_MODE_SENDONCE,
    XOOPS_NOTIFICATION_MODE_SENDONCETHENWAIT => _NOT_MODE_SENDONCEPERLOGIN
);

$users_def_itemnames = array('uid', 'name', 'uname', 'email', 'url', 'user_avatar', 'user_regdate', 'user_icq', 'user_from', 'user_sig', 'user_viewemail', 'actkey', 'user_aim', 'user_yim', 'user_msnm', 'pass', 'posts', 'attachsig', 'rank', 'level', 'theme', 'timezone_offset', 'last_login', 'umode', 'uorder', 'notify_method', 'notify_mode', 'user_occ', 'bio', 'user_intrest', 'user_mailok');

if (get_magic_quotes_gpc()) {
    $_POST = array_map('xoopsStripSlashesRec', $_POST);
    $_GET = array_map('xoopsStripSlashesRec', $_GET);
}

$op = 'list';
if (isset($_POST['op']) && $_POST['op'] != '') $op = $_POST['op'];
elseif (isset($_GET['op']) && $_GET['op'] != '') $op = $_GET['op'];
elseif (isset($_POST['add_ok']) && $_POST['add_ok'] != '') $op = 'add_ok';
elseif (isset($_POST['edit']) && $_POST['edit'] != '') $op = 'edit';
elseif (isset($_POST['edit_ok']) && $_POST['edit_ok'] != '') $op = 'edit_ok';
elseif (isset($_POST['delete']) && $_POST['delete'] != '') $op = 'delete';
elseif (isset($_POST['delete_ok']) && $_POST['delete_ok'] != '') $op = 'delete_ok';
elseif (isset($_POST['list_update']) && $_POST['list_update'] != '') $op = 'list_update';
elseif (isset($_POST['list_update_ok']) && $_POST['list_update_ok'] != '') $op = 'list_update_ok';

if ($op == 'detail') {
    require_once 'detail.php';
} elseif ($op == 'add' || $op == 'add_ok') {
    require_once 'add.php';
} elseif ($op == 'edit' || $op == 'edit_ok') {
    require_once 'edit.php';
} elseif ($op == 'delete' || $op == 'delete_ok') {
    require_once 'delete.php';
} elseif ($op == 'list_update' || $op == 'list_update_ok') {
    require_once 'list_update.php';
} else {
    require_once 'list.php';
}

?>
