<?php
if (!defined("XOOPS_MAINFILE_INCLUDED")) exit();

list($getengine_name, $getengine_query) = xoops_se_getengine();
define("XOOPS_QUERY_WORD", $getengine_query);
define("XOOPS_SEARCH_ENGINE_NAME", $getengine_name);
unset($getengine_name, $getengine_query);

function xoops_se_getengine() {
    $_query = array_merge($_POST, $_GET);

    $query = (isset($_query['query'])) ? $_query['query'] : "";
    if (!$query) $query = (isset($_query['word'])) ? $_query['word'] : "";
    if (!$query) $query = (isset($_query['mes'])) ? $_query['mes'] : "";

    $se_name = ""; //Default

    if (!$query) {
        $reffer = "";
        if (isset($_SERVER['HTTP_REFERER'])) $reffer = $_SERVER['HTTP_REFERER'];

        if ($reffer) {
            if (substr($reffer, -1) == "/") $reffer = substr($reffer, 0, strlen($reffer) - 1);

            $se = file(XOOPS_ROOT_PATH . "/include/search_engines.dat");
            $found = 0;

            foreach ($se as $linea) {
                $linea = trim($linea);
                if ((substr($linea, 0, 2) != "//") && $linea != "") {
                    //$reffer = strtolower($reffer);
                    $tmp = explode("|", $linea);
                    if (_oops_se_search($reffer, $tmp[1])) if (strpos($reffer, chop($tmp[2])) !== false) {
                        $se_name = $tmp[0];
                        $found = 1;
                        break;
                    }
                }
            }

            if ($found == 1) {
                $vars = explode("?", $reffer);
                if (count($vars) > 1) {
                    $query = explode(chop($tmp[2]), $vars[1]);

                    if (count($query) > 1) {
                        $query = explode("&", $query[1]);
                        $query = $query[0];
                    }
                }
            }
        }
    }
    // decode function by nao-pon
    $query = _oops_se_urldecode_euc($query);

    // if the cache comes from google
    $query = preg_replace("/^cache\:[^ ]+ /", '', $query);
    $query = mb_convert_kana($query, "KVas", _CHARSET);

    return array($se_name, $query);
}

function _oops_se_search($string, $mask) {
    static $in = array('.', '^', '$', '{', '}', '(', ')', '[', ']', '+', '*', '?');
    static $out = array('\\.', '\\^', '\\$', '\\{', '\\}', '\\(', '\\)', '\\[', '\\]', '\\+', '.*', '.');
    $mask = '/^' . str_replace($in, $out, $mask) . '$/';
    return (preg_match($mask, $string));
}

// escuni2euc - convert "IE escaped Unicode" to "EUC-JP"
// Programmed : Ishigaki Kazuhito ishigaki@factory.gr.jp

// convert "single IE escaped unicode" to "UTF-8"
// uni2utf8("%u65E5") returns "\xE5\xB1\x80"
function uni2utf8($uniescape) {
    $c = "";

    $n = intval(substr($uniescape, -4), 16);
    if ($n < 0x7F) { // 0000-007F
        $c .= chr($n);
    } elseif ($n < 0x800) { // 0080-0800
        $c .= chr(0xC0 | ($n / 64));
        $c .= chr(0x80 | ($n % 64));
    } else { // 0800-FFFF
        $c .= chr(0xE0 | (($n / 64) / 64));
        $c .= chr(0x80 | (($n / 64) % 64));
        $c .= chr(0x80 | ($n % 64));
    }
    return $c;
}

// Convert "IE escaped Unicode" to "EUC-JP"
// escuni2euc("%u65E5%u672C%u8A9E123") returns "Japanese"
function _oops_se_escuni2euc($escunistr) {
    $eucstr = "";

    while (preg_match("/(.*)(%u[0-9A-F][0-9A-F][0-9A-F][0-9A-F])(.*)$/i", $escunistr, $fragment)) {
        //$eucstr = i18n_convert(uni2utf8($fragment[2]).$fragment[3], 'EUC-JP', 'UTF-8').$eucstr;
        $eucstr = mb_convert_encoding(uni2utf8($fragment[2]) . $fragment[3], _CHARSET, 'UTF-8') . $eucstr;
        $escunistr = $fragment[1];
    }
    return $fragment[1] . $eucstr;
}

// urldecode for Japanese(EUC-JP) by nao-pon
function _oops_se_urldecode_euc($str) {
    if (preg_match("/%u[0-9A-F][0-9A-F][0-9A-F][0-9A-F]/i", $str)) {
        $query = _oops_se_escuni2euc(urldecode($str)); //for IE unicode+urlencoding
        } else {
        $query = urldecode($str);
        //echo $query;
        $query = mb_convert_encoding($query, _CHARSET, "auto");
    }
    return $query;
}

function xoops_word_highlight($body, $q_word, $header = true) {
    // if external link, add class = "ext"
    $body = preg_replace("/(<a[^>]+?)(href=(\"|')?(?!https?:\/\/" . $_SERVER["HTTP_HOST"] . ")http)/i", "$1class=\"ext\" $2", $body);

    if (!$q_word || !$body) return $body;

    // highlite keyword
    $search_word = '';
    $words = array_flip(array_splice(preg_split('/\s+/', $q_word, -1, PREG_SPLIT_NO_EMPTY), 0, 10));
    $keys = array();
    foreach ($words as $word => $id) {
        $keys[$word] = strlen($word);
    }
    //arsort($keys, SORT_NUMERIC);
    $keys = xoops_get_search_words(array_keys($keys));
    $id = 0;
    foreach ($keys as $key => $pattern) {
        $s_key = htmlspecialchars($key);
        $search_word .= " <strong class=\"word$id\">$s_key</strong>";
        $pattern = ($s_key{0} == '&') ? "/(<textarea.*?<\/textarea>|<[^>]*>)|($pattern)/s" : "/(<textarea.*?<\/textarea>|<[^>]*>|&(?:#[0-9]+|#x[0-9a-f]+|[0-9a-zA-Z]+);)|($pattern)/s";
        $body = preg_replace_callback($pattern, create_function('$arr', 'return $arr[1] ? $arr[1] : "<strong class=\"word' . $id . '\">{$arr[2]}</strong>";'), $body);
        $id++;
    }

    if ($header) {
        return "<div class=\"searchKeyword\">" . _HIGHLIGHTED_KEYWORDS . "$search_word</div>\n$body";
    } else {
        return $body;
    }
}

// extend keywod
function xoops_get_search_words($words, $special = FALSE) {
    global $xoopsConfig;
    $retval = array();
    // Perl memo
    // http://www.din.or.jp/~ohzaki/perl.htm#JP_Match
    $eucpre = $eucpost = '';
    if ($xoopsConfig['language'] == "japanese") {
        $eucpre = '(?<!\x8F)';
        $eucpost = '(?=(?:[\xA1-\xFE][\xA1-\xFE])*(?:[\x00-\x7F\x8E\x8F]|\z))';
    }
    // $special : if use htmlspecialchars()
    $quote_func = create_function('$str', $special ? 'return preg_quote($str, "/");' : 'return preg_quote(htmlspecialchars($str), "/");');
    // if LANG=='ja' and can use mb_convert_kana, use mb_convert_kana
    $convert_kana = create_function('$str, $option', ($xoopsConfig['language'] == "japanese") ? 'return mb_convert_kana($str, $option, _CHARSET);' : 'return $str;');

    foreach ($words as $word) {
        $word_zk = $convert_kana($word, 'aKCV');
        $chars = array();
        $poscount = mb_strlen($word_zk, _CHARSET);
        for ($pos = 0; $pos < $poscount; $pos++) {
            $char = mb_substr($word_zk, $pos, 1, _CHARSET);
            $arr = array($quote_func($char));
            if (strlen($char) == 1) {
                $_char = strtoupper($char);
                $arr[] = $quote_func($_char);
                $arr[] = $quote_func($convert_kana($_char, "A"));
                $_char = strtolower($char);
                $arr[] = $quote_func($_char);
                $arr[] = $quote_func($convert_kana($_char, "A"));
            } else {
                $arr[] = $quote_func($convert_kana($char, "c"));
                $arr[] = $quote_func($convert_kana($char, "k"));
            }
            $chars[] = '(?:' . join('|', array_unique($arr)) . ')';
        }
        $retval[$word] = $eucpre . join('', $chars) . $eucpost;
    }
    return $retval;
}

?>