<?php
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

$xoopsOption['pagetype'] = 'user';

// Include files
include 'mainfile.php';
include_once XOOPS_ROOT_PATH . '/class/xoopsformloader.php';
include_once XOOPS_ROOT_PATH . '/class/xoopslists.php';
include_once XOOPS_ROOT_PATH . '/include/comment_constants.php';
include_once XOOPS_ROOT_PATH . '/include/notification_constants.php';
include_once XOOPS_ROOT_PATH . '/language/' . $xoopsConfig['language'] . '/timezone.php';
include_once XOOPS_ROOT_PATH . '/language/' . $xoopsConfig['language'] . '/notification.php';

// If not a user, redirect
if (!is_object($xoopsUser)) {
    redirect_header('index.php', 3, _US_NOEDITRIGHT);
    exit();
}

// Initialize variables
$uid = $xoopsUser->getVar('uid');
$config_handler =& xoops_gethandler('config');
$xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);
$uitems_tbl = $xoopsDB->prefix('uitems');
$myts =& MyTextSanitizer::getInstance();
$yesno_options = array(1 => _YES, 0 => _NO);
$timezone_options = array("-12" => _TZ_GMTM12, "-11" => _TZ_GMTM11, "-10" => _TZ_GMTM10, "-9" => _TZ_GMTM9, "-8" => _TZ_GMTM8, "-7" => _TZ_GMTM7, "-6" => _TZ_GMTM6, "-5" => _TZ_GMTM5, "-4" => _TZ_GMTM4, "-3.5" => _TZ_GMTM35, "-3" => _TZ_GMTM3, "-2" => _TZ_GMTM2, "-1" => _TZ_GMTM1, "0" => _TZ_GMT0, "1" => _TZ_GMTP1, "2" => _TZ_GMTP2, "3" => _TZ_GMTP3, "3.5" => _TZ_GMTP35, "4" => _TZ_GMTP4, "4.5" => _TZ_GMTP45, "5" => _TZ_GMTP5, "5.5" => _TZ_GMTP55, "6" => _TZ_GMTP6, "7" => _TZ_GMTP7, "8" => _TZ_GMTP8, "9" => _TZ_GMTP9, "9.5" => _TZ_GMTP95, "10" => _TZ_GMTP10, "11" => _TZ_GMTP11, "12" => _TZ_GMTP12);
$uorder_options = array(0 => _OLDESTFIRST, 1 => _NEWESTFIRST);
$umode_options = array('nest' => _NESTED, 'flat' => _FLAT, 'thread' => _THREADED);
$notify_method_options = array(XOOPS_NOTIFICATION_METHOD_DISABLE => _NOT_METHOD_DISABLE, XOOPS_NOTIFICATION_METHOD_PM => _NOT_METHOD_PM, XOOPS_NOTIFICATION_METHOD_EMAIL => _NOT_METHOD_EMAIL);
$notify_mode_options = array(XOOPS_NOTIFICATION_MODE_SENDALWAYS => _NOT_MODE_SENDALWAYS, XOOPS_NOTIFICATION_MODE_SENDONCETHENDELETE => _NOT_MODE_SENDONCE, XOOPS_NOTIFICATION_MODE_SENDONCETHENWAIT => _NOT_MODE_SENDONCEPERLOGIN);
$titles = array('uname' => _US_USERNAME, 'email' => _US_EMAIL, 'url' => _US_WEBSITE, 'timezone_offset' => _US_TIMEZONE, 'pass' => _US_PASSWORD, 'user_mailok' => _US_MAILOK, 'name' => _US_REALNAME, 'user_icq' => _US_ICQ, 'user_from' => _US_LOCATION, 'user_sig' => _US_SIGNATURE, 'user_aim' => _US_AIM, 'user_yim' => _US_YIM, 'user_msnm' => _US_MSNM, 'uorder' => _US_CSORTORDER, 'notify_method' => _NOT_NOTIFYMETHOD, 'notify_mode' => _NOT_NOTIFYMODE, 'user_occ' => _US_OCCUPATION, 'bio' => _US_EXTRAINFO, 'user_intrest' => _US_INTEREST, 'umode' => _US_CDISPLAYMODE, 'user_avatar' => _US_AVATAR, 'user_regdate' => _US_MEMBERSINCE, 'posts' => _US_POSTS, 'rank' => _US_RANK, 'last_login' => _US_LASTLOGIN, 'pm' => _US_PM, 'usecookie' => _US_USECOOKIE);

// Initialize updating items
$requests = array();
$sql = "SELECT `itemname`, `regdefault` FROM `$uitems_tbl` WHERE `editorder` >= 0 ORDER BY `editorder` ASC";
$res = $xoopsDB->query($sql);
while (list($itemname, $regdefault) = $xoopsDB->fetchRow($res)) {
    if ($itemname == 'usecookie') {
        $requests[$itemname] = $regdefault;
    } else {
        $requests[$itemname] = $xoopsUser->getVar($itemname, 'E');
    }
}
$requests['pass'] = '';
$requests['vpass'] = '';
$requests['user_viewemail'] = $xoopsUser->getVar('user_viewemail');
$requests['attachsig'] = $xoopsUser->getVar('attachsig');

// Get operation
$op = 'editprofile';
if (!empty($_POST['op'])) $op = $_POST['op'];
elseif (!empty($_GET['op'])) $op = $_GET['op'];

// Update user informations
$stop_reasons = array();
if ($op == 'saveuser') {
    if (!XoopsSingleTokenHandler::quickValidate('edituser')) {
        redirect_header('index.php', 3, _US_NOEDITRIGHT);
        exit;
    }

    // Initialize updating items from posted values
    $sql = "SELECT `itemname` FROM `$uitems_tbl` WHERE `editorder` > 0";
    $res = $xoopsDB->query($sql);
    while (list($itemname) = $xoopsDB->fetchRow($res)) {
        if (!isset($_POST[$itemname])) {
            $requests[$itemname] = '';
        } else {
            $requests[$itemname] = xoopsStripSlashesRec($_POST[$itemname]);
        }

        if ($itemname == 'pass') {
            $requests['vpass'] = xoopsStripSlashesRec($_POST['vpass']);
        } elseif ($itemname == 'email') {
            $requests['user_viewemail'] = isset($_POST['user_viewemail']) ? intval($_POST['user_viewemail']) : 0;
        } elseif ($itemname == 'user_sig') {
            $requests['attachsig'] = isset($_POST['attachsig']) ? intval($_POST['attachsig']) : 0;
        }
    }

    // Check password
    if ($requests['pass'] != '') {
        if (strlen($requests['pass']) < $xoopsConfigUser['minpass']) {
            $stop_reasons['pass'] = sprintf(_US_PWDTOOSHORT, $xoopsConfigUser['minpass']);
        }
        if ($requests['pass'] != $requests['vpass']) {
            $stop_reasons['pass'] = _US_PASSNOTSAME;
        }
    }
    // Check required values
    $sql = "SELECT `itemname`, `title`, `candel` FROM `$uitems_tbl` WHERE `editorder` > 0 AND `required` > 0";
    $res = $xoopsDB->query($sql);
    while (list($itemname, $title, $candel) = $xoopsDB->fetchRow($res)) {
        if ($itemname == 'uname' || $itemname == 'pass') continue;
        if ($itemname == 'email' && empty($xoopsConfigUser['allow_chgmail'])) continue;
        if ($requests[$itemname] == '') {
            $title = $candel ? $myts->htmlSpecialChars($title) : $titles[$itemname];
            $stop_reasons[$itemname] = sprintf(_US_CANT_EMPTY_ERR, $title);
        }
    }

    // Update user informations
    if (count($stop_reasons) == 0) {
        $member_handler =& xoops_gethandler('member');
        $edituser =& $member_handler->getUser($uid);
        $edituser->setVar('name', $requests['name'], true);
        if ($xoopsConfigUser['allow_chgmail'] == 1) {
            $edituser->setVar('email', $requests['email'], true);
        }
        $edituser->setVar('url', $requests['url'], true);
        $edituser->setVar('user_icq', $requests['user_icq'], true);
        $edituser->setVar('user_from', $requests['user_from'], true);
        $edituser->setVar('user_sig', xoops_substr($requests['user_sig'], 0, 255), true);
        $user_viewemail = !empty($requests['user_viewemail']) ? 1 : 0;
        $edituser->setVar('user_viewemail', $user_viewemail, true);
        $edituser->setVar('user_aim', $requests['user_aim'], true);
        $edituser->setVar('user_yim', $requests['user_yim'], true);
        $edituser->setVar('user_msnm', $requests['user_msnm'], true);
        if ($requests['pass'] != '') {
            $edituser->setVar('pass', md5($requests['pass']), true);
        }
        $attachsig = !empty($requests['attachsig']) ? 1 : 0;
        $edituser->setVar('attachsig', $attachsig, true);
        $edituser->setVar('timezone_offset', $requests['timezone_offset'], true);
        $edituser->setVar('uorder', $requests['uorder'], true);
        $edituser->setVar('umode', $requests['umode'], true);
        $edituser->setVar('notify_method', $requests['notify_method'], true);
        $edituser->setVar('notify_mode', $requests['notify_mode'], true);
        $edituser->setVar('bio', xoops_substr($requests['bio'], 0, 255), true);
        $edituser->setVar('user_occ', $requests['user_occ'], true);
        $edituser->setVar('user_intrest', $requests['user_intrest'], true);
        $edituser->setVar('user_mailok', $requests['user_mailok'], true);

        // Update extra user informations
        $sql = "SELECT `itemname`, `itemtype` FROM `$uitems_tbl` WHERE `editorder` > 0 AND `candel` > 0";
        $res = $xoopsDB->query($sql);
        while (list($itemname, $itemtype) = $xoopsDB->fetchRow($res)) {
            if ($itemtype == 'check') $requests[$itemname] = xoopsConvBarStr($requests[$itemname]);
            $edituser->setVar($itemname, $requests[$itemname], true);
        }

        if (!empty($requests['usecookie'])) {
            setcookie($xoopsConfig['usercookie'], $edituser->getVar('uname'), time() + 31536000);
        } else {
            setcookie($xoopsConfig['usercookie']);
        }

        if (!$member_handler->insertUser($edituser)) {
            include XOOPS_ROOT_PATH . '/header.php';
            echo $edituser->getHtmlErrors();
            include XOOPS_ROOT_PATH . '/footer.php';
        } else {
            redirect_header('userinfo.php?uid=' . $uid, 2, _US_PROFUPDATED);
        }
        exit;
    } else {
        $op = 'editprofile';
    }
}

if ($op == 'editprofile') {
    // Display input user informations page
    include_once XOOPS_ROOT_PATH . '/header.php';
    $xoopsOption['template_main'] = 'system_edituser.html';

    $items = array();
    $error_msgs = '';
    $sql = "SELECT `itemname`, `title`, `itemtype`, `options`, `required`, `candel` FROM `$uitems_tbl` WHERE `editorder` > 0 ORDER BY `editorder` ASC";
    $res = $xoopsDB->query($sql);
    while (list($itemname, $title, $itemtype, $options, $required, $candel) = $xoopsDB->fetchRow($res)) {
        $item['itemname'] = $myts->htmlSpecialChars($itemname);
        if ($itemname == 'uname' || $itemname == 'pass' || ($itemname == 'email' && empty($xoopsConfigUser['allow_chgmail']))) {
            $item['required'] = 0;
        } else {
            $item['required'] = $required;
        }
        $item['title'] = $candel ? $myts->htmlSpecialChars($title) : $titles[$itemname];
        $item['itemtype'] = $myts->htmlSpecialChars($itemtype);
        $item['candel'] = $candel;
        if (isset($stop_reasons[$itemname])) {
            $item['error'] = $stop_reasons[$itemname];
            $error_msgs .= $stop_reasons[$itemname] . '<br />';
        }
        if ($itemname == 'uname' || $itemname == 'email' || $itemname == 'url' || $itemname == 'name' || $itemname == 'user_icq' || $itemname == 'user_from' || $itemname == 'user_aim' || $itemname == 'user_yim' || $itemname == 'user_msnm' || $itemname == 'user_intrest' || $itemname == 'user_occ') {
            $item['value'] = $myts->htmlSpecialChars($requests[$itemname]);
            if ($itemname == 'user_icq') {
                $item['size'] = 15;
                $item['maxlength'] = 15;
            } elseif ($itemname == 'user_aim') {
                $item['size'] = 18;
                $item['maxlength'] = 18;
            } elseif ($itemname == 'uname' || $itemname == 'user_yim') {
                $item['size'] = 25;
                $item['maxlength'] = 25;
            } elseif ($itemname == 'name') {
                $item['size'] = 30;
                $item['maxlength'] = 60;
            } elseif ($itemname == 'url' || $itemname == 'user_from' || $itemname == 'user_msnm' || $itemname == 'user_occ') {
                $item['size'] = 50;
                $item['maxlength'] = 100;
            } elseif ($itemname == 'user_intrest') {
                $item['size'] = 50;
                $item['maxlength'] = 150;
            }
            if ($itemname == 'email' && !empty($requests['user_viewemail'])) $item['user_viewemail'] = 1;
        } elseif ($itemname == 'pass') {
            $item['value'] = '';
            $items[] = $item;
            $item['itemname'] = 'vpass';
            $item['title'] = _US_VERIFYPASS;
            if (!empty($item['error'])) $item['error'] = true;
            $items[] = $item;
            unset($item);
            continue;
        } elseif ($itemname == 'user_sig') {
            $user_sig_form = new XoopsFormDhtmlTextArea('', $itemname, $myts->htmlSpecialChars($requests[$itemname]));
            $item['value'] = $user_sig_form->render();
            if (!empty($requests['attachsig'])) $item['attachsig'] = 1;
        } elseif ($itemname == 'bio') {
            $item['value'] = $myts->htmlSpecialChars($requests[$itemname]);
        } elseif ($itemname == 'timezone_offset') {
            $item['options'] = $timezone_options;
            $item['value'] = floatval($requests[$itemname]);
        } elseif ($itemname == 'umode') {
            $item['options'] = $umode_options;
            $item['value'] = $myts->htmlSpecialChars($requests[$itemname]);
        } elseif ($itemname == 'uorder') {
            $item['options'] = $uorder_options;
            $item['value'] = intval($requests[$itemname]);
        } elseif ($itemname == 'notify_method') {
            $item['options'] = $notify_method_options;
            $item['value'] = intval($requests[$itemname]);
        } elseif ($itemname == 'notify_mode') {
            $item['options'] = $notify_mode_options;
            $item['value'] = intval($requests[$itemname]);
        } elseif ($itemname == 'user_mailok' || $itemname == 'usecookie') {
            $item['options'] = $yesno_options;
            $item['value'] = intval($requests[$itemname]);
        } elseif ($candel) {
            if ($itemtype == 'text' || $itemtype == 'textarea') {
                $item['value'] = $myts->htmlSpecialChars($requests[$itemname]);
            } elseif ($itemtype == 'select' || $itemtype == 'radio') {
                $item['options'] = xoopsConvAry($options);
                $item['value'] = isset($requests[$itemname]) ? $myts->htmlSpecialChars($requests[$itemname]) : '';
            } elseif ($itemtype == 'yesno') {
                $item['options'] = $yesno_options;
                $item['value'] = intval($requests[$itemname]);
            } elseif ($itemtype == 'check') {
                $item['options'] = xoopsConvAry($options);
                $item['value'] = xoopsConvAry($requests[$itemname]);
            }
        }
        $items[] = $item;
        unset($item);
    }
    $xoopsTpl->assign('items', $items);
    $xoopsTpl->assign('error_msgs', $error_msgs);
    $token =& XoopsSingleTokenHandler::quickCreate('edituser');
    $xoopsTpl->assign('token', $token->getHtml());
    $xoopsTpl->assign('allow_chgmail', $xoopsConfigUser['allow_chgmail']);

    include XOOPS_ROOT_PATH . '/footer.php';
    exit;
}

// Display avatar input page
if ($op == 'avatarform') {
    include XOOPS_ROOT_PATH . '/header.php';
    echo '<a href="userinfo.php?uid=' . $xoopsUser->getVar('uid') . '">' . _US_PROFILE . '</a>&nbsp;<span style="font-weight:bold;">&raquo;&raquo;</span>&nbsp;' . _US_UPLOADMYAVATAR . '<br /><br />';
    $oldavatar = $xoopsUser->getVar('user_avatar');
    if (!empty($oldavatar) && $oldavatar != 'blank.gif') {
        echo '<div style="text-align:center;"><h4 style="color:#ff0000; font-weight:bold;">' . _US_OLDDELETED . '</h4>';
        echo '<img src="' . XOOPS_UPLOAD_URL . '/' . $oldavatar . '" alt="" /></div>';
    }
    if ($xoopsConfigUser['avatar_allow_upload'] == 1 && $xoopsUser->getVar('posts') >= $xoopsConfigUser['avatar_minposts']) {
        include_once 'class/xoopsformloader.php';
        $form = new XoopsThemeForm(_US_UPLOADMYAVATAR, 'uploadavatar', 'edituser.php');
        $form->setExtra('enctype="multipart/form-data"');
        $form->addElement(new XoopsFormLabel(_US_MAXPIXEL, $xoopsConfigUser['avatar_width'] . ' x ' . $xoopsConfigUser['avatar_height']));
        $form->addElement(new XoopsFormLabel(_US_MAXIMGSZ, $xoopsConfigUser['avatar_maxsize']));
        $form->addElement(new XoopsFormFile(_US_SELFILE, 'avatarfile', $xoopsConfigUser['avatar_maxsize']), true);
        $form->addElement(new XoopsFormHidden('op', 'avatarupload'));
        $form->addElement(new XoopsFormToken(XoopsSingleTokenHandler::quickCreate('avatarupload')));
        $form->addElement(new XoopsFormHidden('uid', $xoopsUser->getVar('uid')));
        $form->addElement(new XoopsFormButton('', 'submit', _SUBMIT, 'submit'));
        $form->display();
    }
    $avatar_handler =& xoops_gethandler('avatar');
    $form2 = new XoopsThemeForm(_US_CHOOSEAVT, 'uploadavatar', 'edituser.php');
    $avatar_select = new XoopsFormSelect('', 'user_avatar', $xoopsUser->getVar('user_avatar'));
    $avatar_select->addOptionArray($avatar_handler->getList('S'));
    $avatar_select->setExtra("onchange='showImgSelected(\"avatar\", \"user_avatar\", \"uploads\", \"\", \"" . XOOPS_URL . "\")'");
    $avatar_tray = new XoopsFormElementTray(_US_AVATAR, '&nbsp;');
    $avatar_tray->addElement($avatar_select);
    $avatar_tray->addElement(new XoopsFormLabel('', "<img src='" . XOOPS_UPLOAD_URL . "/" . $xoopsUser->getVar("user_avatar", "E") . "' name='avatar' id='avatar' alt='' /> <a href=\"javascript:openWithSelfMain('" . XOOPS_URL . "/misc.php?action=showpopups&amp;type=avatars','avatars',600,400);\">" . _LIST . "</a>"));
    $form2->addElement($avatar_tray);
    $form2->addElement(new XoopsFormHidden('uid', $xoopsUser->getVar('uid')));
    $form2->addElement(new XoopsFormHidden('op', 'avatarchoose'));
    $form2->addElement(new XoopsFormToken(XoopsSingleTokenHandler::quickCreate('avatarchoose')));
    $form2->addElement(new XoopsFormButton('', 'submit2', _SUBMIT, 'submit'));
    $form2->display();
    include XOOPS_ROOT_PATH . '/footer.php';
} elseif ($op == 'avatarupload') {
    if (!XoopsSingleTokenHandler::quickValidate('avatarupload')) {
        redirect_header('index.php', 3, _US_NOEDITRIGHT);
        exit;
    }
    $xoops_upload_file = array();
    $uid = 0;
    if (!empty($_POST['xoops_upload_file']) && is_array($_POST['xoops_upload_file'])) {
        $xoops_upload_file = $_POST['xoops_upload_file'];
    }
    if (!empty($_POST['uid'])) {
        $uid = intval($_POST['uid']);
    }
    if (empty($uid) || $xoopsUser->getVar('uid') != $uid) {
        redirect_header('index.php', 3, _US_NOEDITRIGHT);
        exit();
    }
    if ($xoopsConfigUser['avatar_allow_upload'] == 1 && $xoopsUser->getVar('posts') >= $xoopsConfigUser['avatar_minposts']) {
        include_once XOOPS_ROOT_PATH . '/class/uploader.php';
        $uploader = new XoopsMediaUploader(XOOPS_UPLOAD_PATH, array('image/gif', 'image/jpeg', 'image/pjpeg', 'image/x-png', 'image/png'), $xoopsConfigUser['avatar_maxsize'], $xoopsConfigUser['avatar_width'], $xoopsConfigUser['avatar_height']);
        $uploader->setAllowedExtensions(array('gif', 'jpeg', 'jpg', 'png'));
        if ($uploader->fetchMedia($_POST['xoops_upload_file'][0])) {
            $uploader->setPrefix('cavt');
            if ($uploader->upload()) {
                $avt_handler =& xoops_gethandler('avatar');
                $avatar =& $avt_handler->create();
                $avatar->setVar('avatar_file', $uploader->getSavedFileName());
                $avatar->setVar('avatar_name', $xoopsUser->getVar('uname'));
                $avatar->setVar('avatar_mimetype', $uploader->getMediaType());
                $avatar->setVar('avatar_display', 1);
                $avatar->setVar('avatar_type', 'C');
                if (!$avt_handler->insert($avatar)) {
                    @unlink($uploader->getSavedDestination());
                } else {
                    $oldavatar = $xoopsUser->getVar('user_avatar');
                    if (!empty($oldavatar) && $oldavatar != 'blank.gif' && !preg_match("/^savt/", strtolower($oldavatar))) {
                        $avatars =& $avt_handler->getObjects(new Criteria('avatar_file', $oldavatar));
                        $avt_handler->delete($avatars[0]);
                        $oldavatar_path = str_replace("\\", "/", realpath(XOOPS_UPLOAD_PATH . '/' . $oldavatar));
                        if (0 === strpos($oldavatar_path, XOOPS_UPLOAD_PATH) && is_file($oldavatar_path)) {
                            unlink($oldavatar_path);
                        }
                    }
                    $sql = sprintf("UPDATE %s SET user_avatar = %s WHERE uid = %u", $xoopsDB->prefix('users'), $xoopsDB->quoteString($uploader->getSavedFileName()), $xoopsUser->getVar('uid'));
                    $xoopsDB->query($sql);
                    $avt_handler->addUser($avatar->getVar('avatar_id'), $xoopsUser->getVar('uid'));
                    redirect_header('userinfo.php?t=' . time() . '&amp;uid=' . $xoopsUser->getVar('uid'), 0, _US_PROFUPDATED);
                }
            }
        }
        include XOOPS_ROOT_PATH . '/header.php';
        echo $uploader->getErrors();
        include XOOPS_ROOT_PATH . '/footer.php';
    }
} elseif ($op == 'avatarchoose') {
    if (!XoopsSingleTokenHandler::quickValidate('avatarchoose')) {
        redirect_header('index.php', 3, _US_NOEDITRIGHT);
        exit;
    }
    $uid = 0;
    if (!empty($_POST['uid'])) {
        $uid = intval($_POST['uid']);
    }
    if (empty($uid) || $xoopsUser->getVar('uid') != $uid) {
        redirect_header('index.php', 3, _US_NOEDITRIGHT);
        exit();
    }
    $avt_handler =& xoops_gethandler('avatar');
    $user_avatar = 'blank.gif';
    $user_avatar_object = false;
    $myts =& MyTextSanitizer::getInstance();
    if ($user_avatar_req = trim($myts->stripSlashesGPC($_POST['user_avatar']))) {
        // allow system avatar selection only
        if (preg_match("/^savt/", $user_avatar_req)) {
            $criteria = new CriteriaCompo(new Criteria('avatar_file', addslashes($user_avatar_req)));
            $criteria->add(new Criteria('avatar_type', 'S'));
            if ($avatars = $avt_handler->getObjects($criteria)) {
                if (is_object($avatars[0])) {
                    $user_avatar = $avatars[0]->getVar('avatar_file');
                    $user_avatar_object =& $avatars[0];
                }
            }
        }
    }
    $user_avatarpath = str_replace("\\", "/", realpath(XOOPS_UPLOAD_PATH . '/' . $user_avatar));
    if (0 === strpos($user_avatarpath, XOOPS_UPLOAD_PATH) && is_file($user_avatarpath)) {
        $oldavatar = $xoopsUser->getVar('user_avatar');
        $xoopsUser->setVar('user_avatar', $user_avatar);
        $member_handler =& xoops_gethandler('member');
        if (!$member_handler->insertUser($xoopsUser)) {
            include XOOPS_ROOT_PATH . '/header.php';
            echo $xoopsUser->getHtmlErrors();
            include XOOPS_ROOT_PATH . '/footer.php';
            exit();
        }
        if ($oldavatar && $oldavatar != 'blank.gif' && preg_match("/^cavt/", strtolower($oldavatar))) {
            $criteria = new CriteriaCompo(new Criteria('avatar_file', addslashes($oldavatar)));
            $criteria->add(new Criteria('avatar_type', 'C'));
            $avatars =& $avt_handler->getObjects($criteria);
            if (is_object($avatars[0])) {
                $avt_handler->delete($avatars[0]);
            }
            $oldavatar_path = str_replace("\\", "/", realpath(XOOPS_UPLOAD_PATH . '/' . $oldavatar));
            if (0 === strpos($oldavatar_path, XOOPS_UPLOAD_PATH) && is_file($oldavatar_path)) {
                unlink($oldavatar_path);
            }
        }
        if (is_object($user_avatar_object)) {
            $avt_handler->addUser($user_avatar_object->getVar('avatar_id'), $xoopsUser->getVar('uid'));
        }
    }
    redirect_header('userinfo.php?uid=' . $uid, 0, _US_PROFUPDATED);
}
?>