<?php
// $Id: formcaptcha.php,v 1.2 2005/03/18 12:51:55 onokazu Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
/**
 * @package     kernel
 * @subpackage  form
 *
 * @author	    t.kishimoto <t-kishimoto@xoops-ri.jp>
 * @copyright	copyright (c) 2000-2003 XOOPS.org
 */
/**
 * A captcha image
 *
 * @package     kernel
 * @subpackage  form
 *
 * @author	    t.kishimoto <t-kishimoto@xoops-ri.jp>
 * @copyright	copyright (c) 2000-2003 XOOPS.org
 */
class XoopsFormCaptcha extends XoopsFormElement {

    /**
     * Length of the text
     * @var int
     */
    var $_length;

    /**
     * Set length
     *
     * @param int $length
     */
    function setLength($length) {
        $this->_length = $length;
    }

    /**
     * Get length
     *
     * @return int $_length
     */
    function getLength() {
        return $this->_length;
    }

    /**
     * Constructor
     *
     * @param string $extra Description
     * @param string $name Name
     */
    function XoopsFormCaptcha($caption, $extra = "", $name = "captcha", $length = 4) {
        $this->setCaption($caption);
        if ($extra === '') $extra = _CAPTCHA_DESC . '<br />' . _CAPTCHA_NOTE;
        $this->setExtra($extra);
        $this->setName($name);
        $this->setLength(intval($length));
    }

    /**
     * Prepare HTML for output
     *
     * @return	string
     */
    function render() {
        $ret = '<input maxlength="' . $this->getLength() . '" size="' . $this->getLength() . '" name="' . $this->getName() . '" type="text" />';
        $ret .= '<img class="captchaimg" name="captchaimg" src="' . XOOPS_URL . '/captcha.php" onclick="refreshImg(\'' . XOOPS_URL . '\');" alt="CAPTCHA image" align="middle"><br />';
        $ret .= $this->getExtra();

        return $ret;
    }
}
?>