<?php

/*********************************************************************************************************************\
 * LAST UPDATE
 * ============
 * March 22, 2007
 *
 *
 * AUTHOR
 * =============
 * Kwaku Otchere
 * ospinto@hotmail.com
 *
 * Thanks to Andrew Hewitt (rudebwoy@hotmail.com) for the idea and suggestion
 *
 * All the credit goes to ColdFusion's brilliant cfdump tag
 * Hope the next version of PHP can implement this or have something similar
 * I love PHP, but var_dump BLOWS!!!
 *
 * FOR DOCUMENTATION AND MORE EXAMPLES: VISIT http://dbug.ospinto.com
 *
 *
 * PURPOSE
 * =============
 * Dumps/Displays the contents of a variable in a colored tabular format
 * Based on the idea, javascript and css code of Macromedia's ColdFusion cfdump tag
 * A much better presentation of a variable's contents than PHP's var_dump and print_r functions
 *
 *
 * USAGE
 * =============
 * new dBug ( variable [,forceType] );
 * example:
 * new dBug ( $myVariable );
 *
 *
 * if the optional "forceType" string is given, the variable supplied to the
 * function is forced to have that forceType type.
 * example: new dBug( $myVariable , "array" );
 * will force $myVariable to be treated and dumped as an array type,
 * even though it might originally have been a string type, etc.
 *
 * NOTE!
 * ==============
 * forceType is REQUIRED for dumping an xml string or xml file
 * new dBug ( $strXml, "xml" );
 *
 \*********************************************************************************************************************/

class dBug {

    var $arrType = array("array", "object", "boolean");
    var $bInitialized = false;
    var $arrHistory = array();

    //constructor
    function dBug($var) {
        $forceType = "";
        $arrAccept = array("array", "object");
        if (in_array($forceType, $arrAccept)) {
            $this->{"varIs" . ucfirst($forceType)}($var);
        } else {
            $this->checkType($var);
        }
    }

    //get variable name
    function getVariableName() {
        $arrBacktrace = debug_backtrace();

        //possible 'included' functions
        $arrInclude = array("include", "include_once", "require", "require_once");

        //check for any included/required files. if found, get array of the last included file (they contain the right line numbers)
        for ($i = count($arrBacktrace) - 1; $i >= 0; $i--) {
            $arrCurrent = $arrBacktrace[$i];
            if (array_key_exists("function", $arrCurrent) && (in_array($arrCurrent["function"], $arrInclude) || (0 != strcasecmp($arrCurrent["function"], "dbug")))) continue;

            $arrFile = $arrCurrent;

            break;
        }

        if (isset($arrFile)) {
            $arrLines = file($arrFile["file"]);
            $code = $arrLines[($arrFile["line"] - 1)];

            //find call to dBug class
            preg_match('/\bnew dBug\s*\(\s*(.+)\s*\);/i', $code, $arrMatches);

            return $arrMatches[1];
        }
        return "";
    }

    //create the main table header
    function makeTableHeader($type, $header, $click = true, $colspan = 2) {
        if (!$this->bInitialized) {
            $header = $this->getVariableName();
            $this->bInitialized = true;
        }
        $str_i = ($click) ? ' onClick="dBugToggleTable(this)" style="font-style: italic; cursor: pointer;"' : ' style="cursor: default;"';

        echo "<table class=\"outer\" width=\"100%\" cellspacing=\"1\">
        <tr><th align=\"center\" $str_i colspan='$colspan'>$header</th></tr>";
    }

    //create the table row header
    function makeTDHeader($type, $header, $tdclass, $click) {
        if ($click) {
            echo '<tr style="display: none;"><td class="head" style="font-style: italic; cursor: pointer;" onClick="dBugToggleRow(this)">';
        } else {
            echo '<tr style="display: none;"><td class="head">';
        }
        echo htmlspecialchars($header, ENT_QUOTES) . "</td>
        <td class=\"$tdclass\">";
    }

    //close table row
    function closeTDRow() {
        return "</td></tr>\n";
    }

    //error
    function error($type) {
        $error = "Error: Variable cannot be a";
        // this just checks if the type starts with a vowel or "x" and displays either "a" or "an"
        if (in_array(substr($type, 0, 1), array("a", "e", "i", "o", "u", "x"))) $error .= "n";
        return ($error . " " . $type . " type");
    }

    //check variable type
    function checkType($var) {
        switch (gettype($var)) {
            case "object":
                $this->varIsObject($var);
                break;
            case "array":
                $this->varIsArray($var);
                break;
            case "NULL":
                $this->varIsNULL();
                break;
            case "boolean":
                $this->varIsBoolean($var);
                break;
            default:
                $var = ($var == "") ? "[empty string]" : $var;
                echo "<table cellspacing=0><tr>\n<td>" . htmlspecialchars($var, ENT_QUOTES) . "</td>\n</tr>\n</table>\n";
                break;
        }
    }

    //if variable is a NULL type
    function varIsNULL() {
        echo "NULL";
    }

    //if variable is a boolean type
    function varIsBoolean($var) {
        $var = ($var == 1) ? "TRUE" : "FALSE";
        echo $var;
    }

    //if variable is an array type
    function varIsArray($var) {
        $var_ser = serialize($var);
        array_push($this->arrHistory, $var_ser);

        if (is_array($var) && count($var) > 0) {
            $this->makeTableHeader("array", "array", true);
        } else {
            $this->makeTableHeader("array", "array", false);
        }
        if (is_array($var)) {
            $tdclass = 'odd';
            foreach ($var as $key => $value) {
                //check for recursion
                if (is_array($value)) {
                    $this->makeTDHeader("array", $key, $tdclass, true);
                    $var_ser = serialize($value);
                    if (in_array($var_ser, $this->arrHistory, TRUE)) $value = "*RECURSION*";
                } else {
                    $this->makeTDHeader("array", $key, $tdclass, false);
                }

                if (in_array(gettype($value), $this->arrType)) $this->checkType($value);
                else {
                    $value = (trim($value) == "") ? "[empty string]" : $value;
                    echo htmlspecialchars($value, ENT_QUOTES);
                }
                echo $this->closeTDRow();
                $tdclass = $tdclass == 'odd' ? 'even' : 'odd';
            }
        } else echo "<tr><td>" . $this->error("array") . $this->closeTDRow();
        array_pop($this->arrHistory);
        echo "</table>";
    }

    //if variable is an object type
    function varIsObject($var) {
        $var_ser = serialize($var);
        array_push($this->arrHistory, $var_ser);
        if (is_object($var)) {
            $arrObjVars = get_object_vars($var);
            if (count($arrObjVars) > 0) {
                $this->makeTableHeader("object", "object", true);
            } else {
                $this->makeTableHeader("object", "object", false);
            }
        } else {
            $this->makeTableHeader("object", "object", false);
        }

        if (is_object($var)) {
            $tdclass = 'odd';
            foreach ($arrObjVars as $key => $value) {

                $value = (!is_object($value) && !is_array($value) && trim($value) == "") ? "[empty string]" : $value;

                //check for recursion
                if (is_object($value) || is_array($value)) {
                    $this->makeTDHeader("object", $key, $tdclass, true);
                    $var_ser = serialize($value);
                    if (in_array($var_ser, $this->arrHistory, TRUE)) {
                        $value = (is_object($value)) ? "*RECURSION* -> $" . get_class($value) : "*RECURSION*";

                    }
                } else {
                    $this->makeTDHeader("object", $key, $tdclass, false);
                }

                if (in_array(gettype($value), $this->arrType)) $this->checkType($value);
                else echo htmlspecialchars($value, ENT_QUOTES);
                echo $this->closeTDRow();
                $tdclass = $tdclass == 'odd' ? 'even' : 'odd';
            }

            $tdclass = 'odd';
            $arrObjMethods = get_class_methods(get_class($var));
            foreach ($arrObjMethods as $key => $value) {
                $this->makeTDHeader("object", $value, $tdclass, false);
                echo "[function]" . $this->closeTDRow();
                $tdclass = $tdclass == 'odd' ? 'even' : 'odd';
            }
        } else echo "<tr><td>" . $this->error("object") . $this->closeTDRow();
        array_pop($this->arrHistory);
        echo "</table>";
    }
}
?>