<?php
/* $Id: viewaddress.php 16 2006-06-08 08:31:06Z hodaka $
 *  ------------------------------------------------------------------------ *
 *                XOOPS - PHP Content Management System                      *
 *                    Copyright (c) 2000 XOOPS.org                           *
 *                       <http://www.xoops.org/>                             *
 *  ------------------------------------------------------------------------ *
 *                      MyAddress - XOOPS addressbook                        *
 *                        <http://www.kuri3.net/>                            *
 *              Copyright (c) 2004 by hodaka <hodaka@kuri3.net>              *
 * ------------------------------------------------------------------------- *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * You may not change or alter any portion of this comment or credits        *
 * of supporting developers from this source code or any supporting          *
 * source code which is considered copyrighted (c) material of the           *
 * original comment or credit authors.                                       *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this program; if not, write to the Free Software               *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA  *
 */

include( "header.php" );

$myts =& MyTextSanitizer::getInstance();

// reject no perm group modified on v1.23
if( empty($xoopsModuleConfig['myaddress_guestperm']) && !is_object($xoopsUser) ) {
	redirect_header( XOOPS_URL."/user.php" , 2 , _MD_MYADDRESS_YOUMUSTREG );
	exit();
} elseif( !haveGroupPerm() ) {
	redirect_header( XOOPS_URL."/index.php", 2, _MD_MYADDRESS_YOUHAVENOPERM );
	exit();
}

// check if any category exists
$result = $xoopsDB->query( "SELECT count(cid) as count FROM $table_cat" ) ;
list( $count ) = $xoopsDB->fetchRow( $result ) ;
if( $count < 1 ) {
	redirect_header(XOOPS_URL."/modules/myaddress", 2, _MD_MYADDRESS_YOUMUSTADDCAT);
	exit();
}

$action = isset($_POST['add']) ? "add" : (isset($_POST['update']) ? "update" : (isset($_POST['del']) ? "del" :  "" ));
$op = isset( $_GET['op']) ? $_GET['op'] : (isset($_POST['op']) ? $_POST['op'] : "");

$pop = isset( $_GET['pop']) ? $_GET['pop'] : (isset($_POST['pop']) ? $_POST['pop'] : "") ;
$zipconvert = isset($_POST['ziptoadrs'])? "ziptoadrs" : (isset($_POST['adrstozip'])? "adrstozip" : "");
$mode = isset($_POST['mode']) ? $_POST['mode'] : (isset( $_GET['mode']) ? $_GET['mode'] : $myaddress_mode );
$cid = isset($_POST['cid']) ? $_POST['cid'] : (isset( $_GET['cid']) ? $_GET['cid'] : 0 );
$aid = isset($_POST['aid']) ? $_POST['aid'] : (isset( $_GET['aid']) ? $_GET['aid'] : 0 );

switch ( $action ) {
	//-----------------------------------------------------------------//
	//                     add a new address                           //
	//-----------------------------------------------------------------//
	case "add":

		$errors = array();

  	// Check if names exist
		if ($_POST["last_name"] == "") { 
			$errors[] = _MD_MYADDRESS_EH2102;
  	}
		if ($_POST["first_name"] == "") {
			$errors[] = _MD_MYADDRESS_EH2101;
  	}
		if ($_POST["last_name_jh"] == "") {
			$errors[] = _MD_MYADDRESS_EH2104;
  	}
		if ($_POST["first_name_jh"] == "") {
			$errors[] = _MD_MYADDRESS_EH2103;
  	}
		$myemail1 = $myts->stripSlashesGPC(trim($_POST["myemail1"]));
		if ($myemail1 != "" && !checkEmail($myemail1)) {
			$errors[] = sprintf( _MD_MYADDRESS_EH2107, _MD_MYADDRESS_EMAIL1);
		}
		$myemail2 = $myts->stripSlashesGPC(trim($_POST["myemail2"]));
		if ($myemail2 != "" && !checkEmail($myemail2)) {
			$errors[] = sprintf( _MD_MYADDRESS_EH2107, _MD_MYADDRESS_EMAIL2);
		}
		$myemail3 = $myts->stripSlashesGPC(trim($_POST["myemail3"]));
		if ($myemail3 != "" && !checkEmail($myemail3)) {
			$errors[] = sprintf( _MD_MYADDRESS_EH2107, _MD_MYADDRESS_EMAIL3);
		}
		$myemail4 = $myts->stripSlashesGPC(trim($_POST["myemail4"]));
		if ($myemail4 != "" && !checkEmail($myemail4)) {
			$errors[] = sprintf( _MD_MYADDRESS_EH2107, _MD_MYADDRESS_EMAIL4);
		}

		if (count($errors) > 0) {

			include XOOPS_ROOT_PATH.'/header.php';

			echo "<h4><b>".$xoopsConfig['sitename']. _MD_MYADDRESS_ERROR."</b></h4><br />";
			echo "<div>";
			foreach ($errors as $er) {
				echo '<span style=\"color: #ff0000; font-weight: bold;\">'.$er.'</span><br />';
			}
			echo "</div><br />";
			echo "<div>[ <a href='javascript:history.go(-1)'>". _BACK. "</a> ]</div>";

			include_once XOOPS_ROOT_PATH."/footer.php";
			exit();
		}

		add_myaddress();
		redirect_header("viewcat.php?mode=1&cid=$cid", 2, _MD_MYADDRESS_MYADDRESSRECEIVED );
		exit();
	break;

	//-----------------------------------------------------------------//
	//                     update myaddress                            //
	//-----------------------------------------------------------------//
	case "update":

		$errors = array();

  	// Check if names exist
		if ($_POST["last_name"] == "") { 
			$errors[] = _MD_MYADDRESS_EH2102;
  	}
		if ($_POST["first_name"] == "") {
			$errors[] = _MD_MYADDRESS_EH2101;
  	}
		if ($_POST["last_name_jh"] == "") {
			$errors[] = _MD_MYADDRESS_EH2104;
  	}
		if ($_POST["first_name_jh"] == "") {
			$errors[] = _MD_MYADDRESS_EH2103;
  	}

		$myemail1 = $myts->stripSlashesGPC(trim($_POST["myemail1"]));
		if ($myemail1 != "" && !checkEmail($myemail1)) {
			$errors[] = sprintf( _MD_MYADDRESS_EH2107, _MD_MYADDRESS_EMAIL1);
		}
		$myemail2 = $myts->stripSlashesGPC(trim($_POST["myemail2"]));
		if ($myemail2 != "" && !checkEmail($myemail2)) {
			$errors[] = sprintf( _MD_MYADDRESS_EH2107, _MD_MYADDRESS_EMAIL2);
		}
		$myemail3 = $myts->stripSlashesGPC(trim($_POST["myemail3"]));
		if ($myemail3 != "" && !checkEmail($myemail3)) {
			$errors[] = sprintf( _MD_MYADDRESS_EH2107, _MD_MYADDRESS_EMAIL3);
		}
		$myemail4 = $myts->stripSlashesGPC(trim($_POST["myemail4"]));
		if ($myemail4 != "" && !checkEmail($myemail4)) {
			$errors[] = sprintf( _MD_MYADDRESS_EH2107, _MD_MYADDRESS_EMAIL4);
		}

		if (count($errors) > 0) {

			include XOOPS_ROOT_PATH.'/header.php';

			echo "<h4><b>".$xoopsConfig['sitename']. _MD_MYADDRESS_ERROR."</b></h4><br />";
			echo "<div>";
			foreach ($errors as $er) {
				echo '<span style=\"color: #ff0000; font-weight: bold;\">'.$er.'</span><br />';
			}
			echo "</div><br />";
			echo "<div>[ <a href='javascript:history.go(-1)'>". _BACK. "</a> ]</div>";
			include_once XOOPS_ROOT_PATH."/footer.php";
			exit();
		}

		update_myaddress($aid);
		redirect_header( "viewcat.php?mode=1&cid=".$cid, 2, _MD_MYADDRESS_MYADDRESSUPDATING );
		exit();
	break;

	//-----------------------------------------------------------------//
	//                     delete myaddress                            //
	//-----------------------------------------------------------------//
	case "del":
		$delete_ok = isset($_POST['delete_ok']) ? intval($_POST['delete_ok']) : 0;
		if ($delete_ok != 1) {
			include(XOOPS_ROOT_PATH."/header.php");
			xoops_confirm(array('del' => 'del', 'delete_ok' => 1, 'aid' => $aid, 'mode' => 1, 'cid' => $cid), 'viewaddress.php', _MD_MYADDRESS_SURETODELADDRESS.'<br/>'._MD_MYADDRESS_REMOVEADDRESSINFO, _DELETE);
			include(XOOPS_ROOT_PATH."/footer.php");
		} else {
			delete_myaddress($aid);
			redirect_header("viewcat.php?mode=1&cid=".$cid, 2, _MD_MYADDRESS_MYADDRESSDELETING );
			exit();
		}
	break;

	//-----------------------------------------------------------------//
	//                     make form of add/edit/delete                //
	//-----------------------------------------------------------------//
	default:

		$xoopsOption['template_main'] = 'myaddress_addressbook_main.html';

		include(XOOPS_ROOT_PATH."/header.php");

		$xoopsTpl->assign( 'mod_url', $mod_url );
		$xoopsTpl->assign( 'mod_copyright', $mod_copyright );
		$xoopsTpl->assign( 'mode', $mode );
		$xoopsTpl->assign( 'cid', $cid );
		$xoopsTpl->assign( 'op', $op );

		include("include/editaddress.php");
		$xoopsTpl->assign( edit_address( $op, $zipconvert ) );
		include(XOOPS_ROOT_PATH."/footer.php");
	break;
}
?>