<?php
 /* $Id: index.php 16 2006-06-08 08:31:06Z hodaka $
 *  ------------------------------------------------------------------------ *
 *                XOOPS - PHP Content Management System                      *
 *                    Copyright (c) 2000 XOOPS.org                           *
 *                       <http://www.xoops.org/>                             *
 *  ------------------------------------------------------------------------ *
 *                      MyAddress - XOOPS addressbook                        *
 *                        <http://www.kuri3.net/>                            *
 *              Copyright (c) 2004 by hodaka <hodaka@kuri3.net>              *
 * ------------------------------------------------------------------------- *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * You may not change or alter any portion of this comment or credits        *
 * of supporting developers from this source code or any supporting          *
 * source code which is considered copyrighted (c) material of the           *
 * original comment or credit authors.                                       *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this program; if not, write to the Free Software               *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA  *
 */


// some initial settings

include("header.php");

// reject no perm modified on v1.23
if( empty($xoopsModuleConfig['myaddress_guestperm']) && !is_object($xoopsUser) ) {
	redirect_header( XOOPS_URL."/user.php" , 2 , _MD_MYADDRESS_YOUMUSTREG );
	exit();
} elseif( ! haveGroupPerm() ) {
	redirect_header( XOOPS_URL."/index.php", 2, _MD_MYADDRESS_YOUHAVENOPERM );
	exit();
}

$myts =& MyTextSanitizer::getInstance(); // MyTextSanitizer object

$xoopsOption['template_main'] = 'myaddress_index.html';
include( XOOPS_ROOT_PATH . "/header.php" );

$mode = isset($_GET['mode']) ? intval( $_GET['mode'] ) : (isset($_POST['mode']) ? intval( $_POST['mode'] ) : $myaddress_mode);
$cid = isset($_GET['cid']) ? intval( $_GET['cid'] ) : (isset($_POST['cid']) ? intval( $_POST['cid'] ) : 0);

$xoopsTpl->assign( array(
	'lang_total' => _MD_MYADDRESS_TOTAL,
	'mod_url' => $mod_url,
	'mod_copyright' => $mod_copyright,
	'lang_nomatch' => _MD_MYADDRESS_NOFOUND,
	'mode' => $mode,
	'cid' => $cid,
	'call_url' => "viewcat.php"
));

// show the select box to choose a base mode of name or company
$xoopsTpl->assign( 'select_mode' , select_mode( $mode, $cid ) );

// show a link to add an addressbook
if ( $mode == 1 ) {
	$xoopsTpl->assign( 'lang_add_data', _MD_MYADDRESS_ADDMYADDRESS );
	$xoopsTpl->assign( 'add_data_url', 'viewaddress.php?mode='.$mode.'&amp;cid='.$cid.'&amp;op=add' );
} elseif ( $mode == 2 ) {
	$xoopsTpl->assign( 'lang_add_data', _MD_MYADDRESS_ADDCOMPANY );
	$xoopsTpl->assign( 'add_data_url', 'viewcompany.php?mode='.$mode.'&amp;cid='.$cid.'&amp;op=add' );
}

//--------------------------------------------------------------------//
//             show category tree                                     //
//--------------------------------------------------------------------//

$xoopsTpl->assign( 'subcategories' , get_sub_categories( $mode, 0 ) );

//--------------------------------------------------------------------//
//               show numbers of addresses registered                 //
//--------------------------------------------------------------------//

$cids = $cattree->getAllChildId( 0 );
$cids = push_gperm_array( $cids, "myadrs_category" );
$whr_cid = "cid IN (";
foreach( $cids as $cat ) {
	$whr_cid .= "$cat," ;
}
$whr_cid = substr( $whr_cid , 0 , -1 ) . ")";

if ($mode == 1 ) {
	$prs = $xoopsDB->query( "SELECT COUNT(aid) FROM $table_addressbook WHERE $whr_cid" );
} else {
	$prs = $xoopsDB->query( "SELECT COUNT(c_id) FROM $table_company WHERE $whr_cid" );
}
list( $address_num_total ) = $xoopsDB->fetchRow( $prs );
$xoopsTpl->assign( 'address_global_sum' , sprintf( _MD_MYADDRESS_THEREARE, $address_num_total ) );

//--------------------------------------------------------------------//
//                      show buttons for search                       //
//--------------------------------------------------------------------//

$xoopsTpl->assign( show_searchnav( $mode, $cid ) );

// show footer

include(XOOPS_ROOT_PATH."/footer.php");
?>