<?php
/* $Id: categories.php 1 2006-06-07 08:07:41Z hodaka $
 *  ------------------------------------------------------------------------ *
 *                XOOPS - PHP Content Management System                      *
 *                    Copyright (c) 2000 XOOPS.org                           *
 *                       <http://www.xoops.org/>                             *
 *  ------------------------------------------------------------------------ *
 *                     MyAddress - XOOPS addressbook                         *
 *                        <http://www.kuri3.net/>                            *
 *             Copyright (c) 2004 by hodaka <hodaka@kuri3.net>               *
 * ------------------------------------------------------------------------- *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * You may not change or alter any portion of this comment or credits        *
 * of supporting developers from this source code or any supporting          *
 * source code which is considered copyrighted (c) material of the           *
 * original comment or credit authors.                                       *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this program; if not, write to the Free Software               *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA  *
 */

include("admin_header.php");
include_once( XOOPS_ROOT_PATH."/class/xoopstree.php" ) ;
include_once( XOOPS_ROOT_PATH."/class/xoopscomments.php" ) ;
include_once( XOOPS_ROOT_PATH."/class/xoopslists.php" ) ;

$myts =& MyTextSanitizer::getInstance();
$cattree = new XoopsTree($table_cat,"cid","pid");

$op = isset( $_GET['op'] ) ? $_GET['op'] : '' ;
if( $op == '' && isset( $_POST['op'] ) ) $op = $_POST['op'] ;

switch( $op ) {
	case "addCat":
		addCat();
		break;
	case "delCatConfirm":
		delCatConfirm();
		break;
	case "delCat":
		delCat();
		break;
	case "editCat":
		editCat();
		break;
	case "saveCat":
		saveCat();
		break;
	default :
	case "main" :
		mainCat();
		break;
}

function mainCat()
{
	global $xoopsModule, $xoopsDB, $xoopsConfig, $myts, $cattree;
	global $table_cat ;

	xoops_cp_header();
	include('./mymenu.php'); // GIJOE
	// Add a New Main Category
	OpenTable();
	echo "<form method='post' action='categories.php'>\n";
	echo "<h4>"._AM_MYADDRESS_ADDMAIN."</h4><br />"._AM_MYADDRESS_TITLEC."<input type='text' name='title' size='30' maxlength='50'><br />";
	echo ""._AM_MYADDRESS_IMGURL."<br /><input type='text' name='imgurl' size='100' maxlength='150' value='http://'><br /><br />";
	echo "<input type='hidden' name='cid' value='0'>\n";
	echo "<input type='hidden' name='op' value='addCat'>";
	echo "<input type='submit' value='"._AM_MYADDRESS_ADD."'><br /></form>";
	CloseTable();
	echo "<br />";

	$result = $xoopsDB->query( "SELECT count(*) FROM $table_cat" ) ;
	list( $numrows ) = $xoopsDB->fetchRow( $result ) ;
	if( $numrows > 0 ) {

		// Add a New Sub-Category
		OpenTable();
		echo "<form method='post' action='categories.php'>
		<h4>"._AM_MYADDRESS_ADDSUB."</h4><br />
		"._AM_MYADDRESS_TITLEC."<input type='text' name='title' size='30' maxlength='50'>&nbsp;"._AM_MYADDRESS_IN."&nbsp;";
		$cattree->makeMySelBox( "title" , "title" ) ;
		echo "<input type='hidden' name='op' value='addCat'><br /><br />";
		echo "<input type='submit' value='"._AM_MYADDRESS_ADD."'><br /></form>";
		CloseTable();
		echo "<br />";

		// Modify Category
		OpenTable();
		echo "<form method='post' action='categories.php'>
		<h4>"._AM_MYADDRESS_MODCAT."</h4><br />";
		echo _AM_MYADDRESS_CATEGORYC;
		$cattree->makeMySelBox( "title" , "title" ) ;
		echo "<br />
			<br />
			<input type='hidden' name='op' value='editCat'>
			<input type='submit' value='"._AM_MYADDRESS_MODIFY."'>
		</form>\n" ;
		CloseTable();
		echo "<br />";
	}

	xoops_cp_footer();
}


function editCat()
{
	global $xoopsModule, $xoopsDB, $_POST, $myts, $cattree;
	global $table_cat ;

	$cid = $_POST["cid"];
	xoops_cp_header();
	include('./mymenu.php'); // GIJOE
	OpenTable();
	echo "<h4>"._AM_MYADDRESS_MODCAT."</h4><br />";
	$result = $xoopsDB->query( "SELECT pid, title, imgurl FROM $table_cat WHERE cid=$cid" ) ;
	list( $pid , $title , $imgurl ) = $xoopsDB->fetchRow( $result ) ;
	$title = $myts->makeTboxData4Edit( $title ) ;
	$imgurl = $myts->makeTboxData4Edit( $imgurl ) ;
	echo "<form action='categories.php' method='post'>"._AM_MYADDRESS_TITLEC."<input type='text' name='title' value='$title' size='51' maxlength='50'><br /><br />"._AM_MYADDRESS_IMGURLMAIN."<br /><input type='text' name='imgurl' value='$imgurl' size='100' maxlength='150'><br /><br />";
	echo _AM_MYADDRESS_PARENT."&nbsp;";
	$cattree->makeMySelBox( "title" , "title" , $pid , 1 , 'pid' ) ;
	echo "<br /><input type='hidden' name='cid' value='$cid'>
	<input type='hidden' name='op' value='saveCat'><br />
	<input type='submit' value='"._AM_MYADDRESS_SAVE."'>
	<input type='button' value='"._AM_MYADDRESS_DELETE."' onClick='location=\"categories.php?pid=$pid&cid=$cid&op=delCatConfirm\"'>";
	echo "&nbsp;<input type='button' value='"._AM_MYADDRESS_CANCEL."' onclick='javascript:history.go(-1)'>";
	echo "</form>";
	CloseTable();
	xoops_cp_footer();
}


function saveCat()
{
	global $xoopsDB , $myts ;
	global $table_cat ;

	if( empty( $_POST['cid'] ) ) die( "'cid' not specified." ) ;
	else $cid = intval( $_POST['cid'] ) ;
	$pid = isset( $_POST['pid'] ) ? intval( $_POST['pid'] ) : 0 ;
	if( $cid == $pid ) die( "parent category cannot be the same id with the child category" ) ;
	$title =  $myts->makeTboxData4Save($_POST['title']);
	if ( ($_POST["imgurl"]) || ($_POST["imgurl"]!="") ) {
		$imgurl = $myts->makeTboxData4Save($_POST["imgurl"]);
	}
	$xoopsDB->query("UPDATE $table_cat SET pid=$pid , title='$title' , imgurl='$imgurl' WHERE cid=$cid" ) or die( "DB error: UPDATE cat table" ) ;
	redirect_header("categories.php",1,_AM_MYADDRESS_DBUPDATED);
}

function delCat()
{
	global $xoopsDB , $cattree ;
	global $table_addressbook , $table_cat ;
	// get and check if the cid is valid
	$cid = $_GET['cid'] ;
	if( empty( $_GET['cid'] ) || $cid < 1 || ! is_numeric( $cid ) ) die( "Invalid category id." ) ;

	//get all categories under the specified category
	$children = $cattree->getAllChildId( $cid ) ;
	$whr = "cid IN (" ;
	foreach( $children as $child ) {
		$whr .= "$child," ;
	}
	$whr .= "$cid)";

//	deleteMyAddress( $whr );

	$xoopsDB->query("DELETE FROM $table_cat WHERE $whr") or die( "DB error: DELETE cat table" ) ;
	redirect_header("categories.php",1,_AM_MYADDRESS_CATDELETED) ;
	exit() ;
}



function delCatConfirm()
{
	global $xoopsModule;
	xoops_cp_header();
	include('./mymenu.php'); // GIJOE
	OpenTable();

	// get and check cid is valid
	$cid = $_GET['cid'] ;
	if( empty( $_GET['cid'] ) || $cid < 1 || ! is_numeric( $cid ) ) die( "Invalid category id." ) ;

	echo "
		<center>
		<h4><font color='#ff0000'>"._AM_MYADDRESS_CATDEL_WARNING."</font></h4>
		<br />
		<table>
		<tr>
			<td>
				<form action='categories.php?op=delCat&cid=$cid' method='post'>
					<input type='submit' value='"._AM_MYADDRESS_YES."' />
				</form>
			</td>
			<td>
				<form action='categories.php' method='post'>
					<input type='submit' value='"._AM_MYADDRESS_NO."' />
				</form>
			</td>
		</tr>
		</table>
	\n" ;

	CloseTable();
	xoops_cp_footer();
}


function addCat()
{
	global $xoopsDB , $myts ;
	global $table_cat ;

	$pid = intval($_POST["cid"]);
	$title = $myts->makeTboxData4Save($_POST["title"]);
	if( isset( $_POST["imgurl"] ) && ( $_POST["imgurl"] != "" ) ) {
		$imgurl = $myts->makeTboxData4Save($_POST["imgurl"]) ;
	} else {
		$imgurl = '' ;
	}
//	$title = $myts->makeTboxData4Save($title);
	$newid = $xoopsDB->genId( $table_cat."_cid_seq" ) ;
	$xoopsDB->query("INSERT INTO $table_cat (cid, pid, title, imgurl) VALUES ($newid, $pid, '$title', '$imgurl')") or die( "DB error: INSERT category table" ) ;
	redirect_header("categories.php?op=editCategories",1,_AM_MYADDRESS_NEWCATADDED);
}
?>