<?php
/**
@file
@brief åϿΤ class
@note ƥΥåϿˤˤ碌뤿ΥåѡȤ¾ܥɤ $_SESSION ľȤ
*/

if(!defined('EXFRAME_SESSION_PREFIX'))
	define('EXFRAME_SESSION_PREFIX','__exf__');

/**
@brief å갷ΥåѡǤ
@deprecated Υ饹̾ϥեꥯȤ򵯤䤹ؤȤ exSession 饹ѤƤ
Υ饹 1.00 ޤǤ˺ͽǤ
*/
class Session {
	/**
	@brief ꤷ̾ǥåͤ¸ޤʥ饹᥽åɡ
	@param $name å̾
	@param $value 
	@note ºݤ¸̾ˤ EXFRAME_SESSION_PREFIX ȥĤûޤ
	*/
	function register($name,$value) {
		$name=EXFRAME_SESSION_PREFIX."__".$name;
		$_SESSION[$name]=$value;
	}

	/**
	@brief ꤷ̾ǥå֤ͤޤʥ饹᥽åɡ
	@param $name å̾
	@return 쥸ȤƤ
	@note ºݤ¸̾ˤ EXFRAME_SESSION_PREFIX ȥĤûޤ
	*/
	function &get($name) {
		$name=EXFRAME_SESSION_PREFIX."__".$name;
		if(isset($_SESSION[$name]))
			return $_SESSION[$name];
		else
			return false;
	}

	/**
	@brief ꤷ̾ǥå֤ͤȡͤޤʥ饹᥽åɡ
	@param $name å̾
	@return 쥸ȤƤ
	@note ºݤ¸̾ˤ EXFRAME_SESSION_PREFIX ȥĤûޤ
	*/
	function &pop($name) {
		$name=EXFRAME_SESSION_PREFIX."__".$name;
		if(isset($_SESSION[$name])) {
			$ret=$_SESSION[$name];
			unset($_SESSION[$name]);
			return $ret;
		}
		else
			return false;
	}

	/**
	@brief POST ꥯȤξ get, Ǥʤ pop ƤӽФåѡʥ饹᥽åɡ
	@param $name å̾
	@return 쥸ȤƤ
	@note ºݤ¸̾ˤ EXFRAME_SESSION_PREFIX ȥĤûޤ
	*/
	function &postPop($name) {
		if(exFrame::isPost())
			return Session::pop($name);
		else
			return Session::get($name);
	}
	
	/**
	@brief ꤷ̾Υåͤ뤫ɤĴޤʥ饹᥽åɡ
	@param $name å̾
	@return ¸ߤƤпƤʤе֤ޤ
	@note ºݤ¸̾ˤ EXFRAME_SESSION_PREFIX ȥĤûޤ
	*/
	function is_registered($name){
		$name=EXFRAME_SESSION_PREFIX."__".$name;

		return isset($_SESSION[$name]);
	}

	/**
	@brief ꤷ̾Υåͤޤʥ饹᥽åɡ
	@param $name å̾
	@note ºݤ¸̾ˤ EXFRAME_SESSION_PREFIX ȥĤûޤ
	*/
	function unregister($name){
		$name=EXFRAME_SESSION_PREFIX."__".$name;
		unset($_SESSION[$name]);
	}

	function addRole($major,$minor,$lifetime=0) {
		$role=array();
		if(Session::is_registered('exRole'))
			$role=&Session::get('exRole');

		if($lifetime) $lifetime+=time();
		$role[$major.":".$minor]=$lifetime;

		Session::register('exRole',$role);
	}

	function clearRole($major,$minor) {
		if(Session::is_registered('exRole')) {
			$role=&Session::get('exRole');
			unset($role[$major.":".$minor]);
			
			Session::register('exRole',$role);
		}
	}

	function isRole($major,$minor) {
		if(Session::is_registered('exRole')) {
			$role=&Session::get('exRole');
			if(!isset($role[$major.":".$minor]))
				return false;

			if(time()>$role[$major.":".$minor] && $role[$major.":".$minor]!==0 ) {
				Session::clearRole($major,$minor);
				return false;
			}

			return true;
		}
		else
			return false;
	}
}

/**
@brief åȤΤȤԤΥåѡ饹
 exSession ϥåؤϿͤ򥷥ꥢ벽ޤ
ˤ xoops ͭ session_start Υӥʥߥ󥰤򾯤餹ȤǤޤ
get ǼޤǤ˥饹Ƥ session_start ǤäƤ⹽ޤ
*/
class exSession extends Session {
	/**
	@brief ꤷ̾ǥåͤ¸ޤʥ饹᥽åɡ
	ΤȤꥢ饤Ѥޤ
	@param $name å̾
	@param $value 
	@note ºݤ¸̾ˤ EXFRAME_SESSION_PREFIX ȥĤûޤ
	*/
	function register($name,&$value) {
		$name=EXFRAME_SESSION_PREFIX."__".$name;
		$_SESSION[$name]=serialize($value);
	}

	/**
	@brief ꤷ̾ǥå֤ͤޤʥ饹᥽åɡ
	@param $name å̾
	@return 쥸ȤƤ
	@note ºݤ¸̾ˤ EXFRAME_SESSION_PREFIX ȥĤûޤ
	*/
	function &get($name) {
		$ret=null;
		$name=EXFRAME_SESSION_PREFIX."__".$name;
		if(isset($_SESSION[$name]))
			$ret = unserialize($_SESSION[$name]);

		return $ret;
	}
}

?>