<?php
// $Id: index.php 86 2006-09-01 02:46:06Z yosha_01 $
/**
 * @package controller
 */
require '../../mainfile.php';

$xoopsOption['template_main'] = 'discuss_index.html';
include XOOPS_ROOT_PATH.'/header.php';

require './class/discuss.php';
require_once  './class/xoopssimplecontroller.php';

class DiscussDiscussList extends XoopsTableObjectList
{
	function DiscussDiscussList() {
		$this->addElement('discuss_id', '#', 20);
		$this->addElement('subject', _MD_DISCUSS_SUBJECT, 120, array('sort'=>true, 'link'=>'./discuss.php?'));
		$this->addElement('description',  _DESCRIPTION, 500);
		$this->addElement('log', '', 50, array('extraVar'=>'Log', 'link'=>'./log.php?recent=1&amp;'));
	}
}

class DiscussDiscussForm extends XoopsTableObjectForm
{
	function DiscussDiscussForm() {
		$this->setPrefix('discuss');
		$this->addElement('discuss_id', 'Hidden', '', 0);
		$this->addElement('subject', 'Text', _MD_DISCUSS_SUBJECT);
		$this->addElement('description', 'Text', _DESCRIPTION);
	}
}

$simpleController =& new XoopsSimpleMainController('DiscussDiscuss', 'discuss', '');
$simpleController->allowedOp = array('list');
$simpleController->execute();

// auto discovery
$auto_discovery = "<link rel=\"alternate\" type=\"application/rss+xml\" title=\"rss\" href=\"./rss.php\" />";
$xoops_module_header = $xoopsTpl->get_template_vars("xoops_module_header");
$xoopsTpl->assign("xoops_module_header", $xoops_module_header.$auto_discovery);

include XOOPS_ROOT_PATH.'/footer.php';

//@yosha xoops_module_header に rss auto-discovery を入れてあげるとよいかも。
//@ref <link rel="alternate" type="application/rss+xml" title="RSS" href="{URL for RSS}" />
//@ref http://blog.bulknews.net/cookbook/blosxom/rss/rss_auto_discovery.html
?>