<?php
// $Id: message.php 86 2006-09-01 02:46:06Z yosha_01 $
/**
 * @package Discuss
 */
require_once dirname(__FILE__).'/xoopstableobject.php';
if(!class_exists('DiscussMessage')) {

/**
 * Class for discussion message
 *
 * @package discuss
 */
class DiscussMessage extends XoopsTableObject
{
	/**
	 * constructor
	 * @access public
	 */
	function DiscussMessage()
	{
		// call parent constructor
		$this->XoopsTableObject();

		// define object elements
		$this->initVar('discuss_id', XOBJ_DTYPE_INT, null, true);
		$this->initVar('message_id', XOBJ_DTYPE_INT, null, true);
		$this->initVar('uid', XOBJ_DTYPE_INT, null, false);
		$this->initVar('uname', XOBJ_DTYPE_TXTBOX, null, true, 60);
		$this->initVar('message', XOBJ_DTYPE_TXTAREA, null, true);
		$this->initVar('timestamp', XOBJ_DTYPE_INT, null, true);
		$this->initVar('color', XOBJ_DTYPE_TXTBOX, '000000', false);

		// define primary key
		$this->setKeyFields(array('discuss_id','message_id'));
		$this->setAutoIncrementField('message_id');
	}

	// checkVar
	function checkVar_color(&$value)
	{
		$colors = array("000000", "dc0000", "4cb5e8");
		if (!in_array($value, $colors)) {
            $this->setErrors('bad color posted.');
	        return false;
		}
		return true;
	}
}

/**
 * Discuss message handler class.
 *
 * @package Discuss
 */
class DiscussMessageHandler extends XoopsTableObjectHandler
{
	/**
	 * discussion object
	 * @var object {@link DiscussDiscuss} object
	 */
	var $_discuss = null;

	/**
	 * discussion id
	 * @var int
	 */
	var $_discuss_id = 0;
	
	/**
	 * @var string
	 */
	var $tableName = 'discuss_message';
	
	/**
	 * @param int $discuss_id
	 * @return bool
	 */
	function checkDiscuss($discuss_id)
	{
		$this->_discuss_id = intval($discuss_id);
		if ($this->_discuss_id > 0) {
			$discuss_handler =& xoops_getmodulehandler("discuss");
			$this->_discuss =& $discuss_handler->get($this->_discuss_id);
			if (!is_object($this->_discuss)){
				return false;
			}	
			return true;
		}
		return false;
	}

	/**
	 * get message-array
	 * @return array message objects.
	 */
	function &getMessages($discuss_id, $limit = 10)
	{
	    $criteria =& new CriteriaCompo();
	    $criteria->add(new Criteria('discuss_id', $discuss_id));
		$criteria->setSort('message_id');
		$criteria->setOrder('DESC');
		$criteria->setLimit($limit); 
		
	    $message_objects =& $this->getObjects($criteria);
        krsort($message_objects);    	    

        return $message_objects;
	}
	
}//end of class

}//end of if
?>