<?php
// $Id: discuss.php 93 2006-09-10 18:30:31Z yosha_01 $
/**
 * @package Discuss
 */
require_once dirname(__FILE__).'/xoopstableobject.php';

if(!class_exists('DiscussDiscuss')) {

/**
 * Class for discussion
 *
 * @package Discuss
 */
class DiscussDiscuss extends XoopsTableObject
{
	/**
	 * constructor
	 * @access public
	 */
	function DiscussDiscuss()
	{
		// call parent constructor
		$this->XoopsTableObject();

		// define object elements
		$this->initVar('discuss_id', XOBJ_DTYPE_INT, null, true);
		$this->initVar('subject', XOBJ_DTYPE_TXTBOX, null, true, 120);
		$this->initVar('description', XOBJ_DTYPE_TXTAREA, null, false);
		$this->initVar('open_time', XOBJ_DTYPE_INT, 0, false);
		$this->initVar('close_time', XOBJ_DTYPE_INT, 0, false);
		$this->initVar('closed', XOBJ_DTYPE_INT, 0, false);

		//　unused.
		$this->initVar('access_key', XOBJ_DTYPE_TXTBOX, '', false);
		$this->initVar('key_term', XOBJ_DTYPE_INT, 0, false);

		// define primary key
		$this->setKeyFields(array('discuss_id'));
		$this->setAutoIncrementField('discuss_id');
		$this->setNameField('subject');
	}
	
	/**
	 * check if discussion is open or not.
	 * @access public
	 * @return bool
	 */
	function isOpen(){
		return ($this->getVar('closed')) ? false : true;
	}

} // end of class


/**
 * Discuss discussion handler class.
 *
 * @package discuss
 */
class DiscussDiscussHandler extends XoopsTableObjectHandler
{
	var $tableName = 'discuss';
	
	/**
	 * get active dicuss
	 * @access public
	 * @return array
	 */
	function &getOpenDiscussions()
	{
		$criteria = new CriteriaCompo(new Criteria('closed', 0));

		$fieldlist = 'discuss_id, subject';
		$results =& $this->getObjects($criteria, true, $fieldlist);

		$ret = array();
		foreach($results as $k=>$v) {
			$ret[$k] = $v->getVar('subject');
		}
		return $ret;
	}

	/**
	 * @access public
	 * @param int $discuss_id
	 * @return string
	 */
	function getSubjectById($discuss_id)
	{
		$discuss =& $this->get($discuss_id);
		if (is_object($discuss)) {
			return $discuss->getVar('subject');
		}
		return false;
	}
} // end of class

} // end of if
?>