<?php
// $Id: attendee.php 47 2006-08-23 11:03:32Z yosha_01 $
/**
 * attendee class
 * @package discuss
 */
require_once dirname(__FILE__).'/xoopstableobject.php';

if (!class_exists('DiscussAttendee')) {
class DiscussAttendee extends XoopsTableObject
{
    function DiscussAttendee()
	{
        $this->XoopsTableObject();
        $this->initVar('attendee_id', XOBJ_DTYPE_INT, null, true);
        $this->initVar('discuss_id', XOBJ_DTYPE_INT, null, true);
        $this->initVar('uid', XOBJ_DTYPE_INT, null, true);
        $this->initVar('uname', XOBJ_DTYPE_TXTBOX, null, true, 60);
//     	$this->initVar('session_id', XOBJ_DTYPE_TXTBOX, null, true, 32);
        $this->initVar('ip', XOBJ_DTYPE_TXTBOX, null, true, 15);
//      $this->initVar('time_registered', XOBJ_DTYPE_INT, 0, true);
        $this->initVar('updated', XOBJ_DTYPE_INT, 0, true);
        $this->initVar('status', XOBJ_DTYPE_INT, 0, true);
        
        $this->setKeyFields(array('attendee_id'));
        $this->setAutoIncrementField('attendee_id');
	}
}

/**
 * attendee handler class
 * @package discuss
 */
class DiscussAttendeeHandler extends XoopsTableObjectHandler
{
    var $tableName = "discuss_attendee";

/**
 * update attendee's status
 * guests from the same ip is regarded as the same person.
 *
 * @access public
 * @param obj $attendee attendee object.
 * @return bool true when succeeded.
 * @todo it's better to use a session_id as an unique key.
 */
    function updateStatus(&$attendee)
    {
        if (strtolower(get_class($attendee)) != 'discussattendee') {
            return false;
        }
        if (!$attendee->cleanVars()) {
            return false;
        }
        foreach ($attendee->cleanVars as $k => $v) {
            ${$k} = $v;
        }
		
        if($uid == 0){
            $sql = 'SELECT COUNT(*) FROM '.$this->db->prefix('discuss_attendee').' WHERE discuss_id='.$discuss_id.' AND uid=0 AND ip='.$this->db->quoteString($ip);
            list($count) = $this->db->fetchRow($this->db->query($sql));
            if($count > 0){
                $sql = 'UPDATE '.$this->db->prefix('discuss_attendee').' SET updated='.$updated.', status=1 WHERE discuss_id='.$discuss_id.' AND uid=0 AND ip='.$this->db->quoteString($ip);
            } else {
                $sql = 'INSERT INTO '.$this->db->prefix('discuss_attendee').' (discuss_id, uid, uname, ip, updated, status) VALUES ('.$discuss_id.', '.$uid.', '.$this->db->quoteString($uname).', '.$this->db->quoteString($ip).', '.$updated.', '.$status.')';
            }
        } else {
            $sql = 'SELECT COUNT(*) FROM '.$this->db->prefix('discuss_attendee').' WHERE discuss_id='.$discuss_id.' AND uid='.$uid;
            list($count) = $this->db->fetchRow($this->db->query($sql));
            if($count > 0){
                $sql = 'UPDATE '.$this->db->prefix('discuss_attendee').' SET updated='.$updated.', status=1 WHERE discuss_id='.$discuss_id.' AND uid='.$uid;
            } else {
                $sql = 'INSERT INTO '.$this->db->prefix('discuss_attendee').' (discuss_id, uid, uname, ip, updated, status) VALUES ('.$discuss_id.', '.$uid.', '.$this->db->quoteString($uname).', '.$this->db->quoteString($ip).', '.$updated.', '.$status.')';
            }
        }
		
		// is secure?
        if (!$result = $this->db->queryF($sql)) {
            return false;
        }
        return true;
    }

/**
 * turns inactive attendees status to off(0).
 *
 * @access public
 * @param int $expire interval (in seconds)
 * @return bool true when succeeded.
 */
    function garbageCollect($expire)
    {
        $mintime = time() - intval($expire);
        $sql = 'UPDATE '.$this->db->prefix('discuss_attendee').' SET status = 0 WHERE updated < '.$mintime;
        return $this->db->queryF($sql);
    }

/**
 * returns attendee objects.
 *
 * @access public
 * @param int $discuss_id use "0" to get all attendees in the site.
 * @param int $status "1" for active attendees, "0" for all attendees who have joined the discussion.
 * @return array array containing attendee objects.
 */
    function &getAttendees($discuss_id, $status = 1)
    {
        $discuss_id = intval($discuss_id);
        $status = intval($status);
        $objs = array();
        if ($discuss_id > 0){
			// return objects that include infomation of attendees in the discussion.
            $sql = 'SELECT * FROM '.$this->db->prefix('discuss_attendee').' WHERE discuss_id = '.$discuss_id.' AND status = '.$status;
            $result = $this->db->query($sql);
            if (!$result) {
                return $objs;
            }
            while ($myrow = $this->db->fetchArray($result)) {
                $attendee = new DiscussAttendee();
                $attendee->assignVars($myrow);
                $objs[] =& $attendee;
                unset($attendee);
            }
            return $objs;
        } else {
			// this is used to limit the number of attendees in the whole site.
            return $objs;
        }
    }
}
}//end of if
?>